/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction.plumbing.billing;

import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogService;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.junction.JunctionTestSuiteNoDB;
import org.killbill.billing.junction.plumbing.billing.BillCycleDayCalculator;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseInternalApi;
import org.killbill.billing.subscription.api.user.SubscriptionBaseBundle;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBillCycleDayCalculator
extends JunctionTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testCalculateBCDForAOWithBPCancelledBundleAligned() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.UTC;
        DateTime bpStartDateUTC = new DateTime(2012, 7, 16, 21, 0, 0, DateTimeZone.UTC);
        int expectedBCDUTC = 16;
        SubscriptionBaseBundle bundle = (SubscriptionBaseBundle)Mockito.mock(SubscriptionBaseBundle.class);
        SubscriptionBase subscription = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)subscription.getStartDate()).thenReturn((Object)bpStartDateUTC);
        Mockito.when((Object)this.subscriptionInternalApi.getBaseSubscription((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)subscription);
        Plan plan = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)plan.dateOfFirstRecurringNonZeroCharge(bpStartDateUTC, null)).thenReturn((Object)bpStartDateUTC);
        Catalog catalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)catalog.findPlan(Mockito.anyString(), (DateTime)Mockito.any(), (DateTime)Mockito.any())).thenReturn((Object)plan);
        Mockito.when((Object)subscription.getLastActivePlan()).thenReturn((Object)plan);
        Account account = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account.getTimeZone()).thenReturn((Object)accountTimeZone);
        Integer billCycleDayLocal = this.billCycleDayCalculator.calculateBcdForAlignment(BillingAlignment.BUNDLE, bundle, subscription, account, catalog, null, this.internalCallContext);
        Assert.assertEquals((Object)billCycleDayLocal, (Object)16);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithTimeZoneHST() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.forID((String)"HST");
        DateTime startDateUTC = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.UTC);
        int bcdLocal = 16;
        this.verifyBCDCalculation(accountTimeZone, startDateUTC, 16);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithTimeZoneCEST() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.forID((String)"Europe/Paris");
        DateTime startDateUTC = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.UTC);
        int bcdLocal = 16;
        this.verifyBCDCalculation(accountTimeZone, startDateUTC, 16);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithTimeZoneUTC() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.UTC;
        DateTime startDateUTC = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.UTC);
        int bcdLocal = 16;
        this.verifyBCDCalculation(accountTimeZone, startDateUTC, 16);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithTimeZoneEEST() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.forID((String)"+0300");
        DateTime startDateUTC = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.UTC);
        int bcdLocal = 17;
        this.verifyBCDCalculation(accountTimeZone, startDateUTC, 17);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithTimeZoneJST() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.forID((String)"Asia/Tokyo");
        DateTime startDateUTC = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.UTC);
        int bcdLocal = 17;
        this.verifyBCDCalculation(accountTimeZone, startDateUTC, 17);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithSubscriptionDateNotInUTC() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.forID((String)"Asia/Tokyo");
        DateTime startDate = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.forID((String)"HST"));
        int bcdLocal = 17;
        this.verifyBCDCalculation(accountTimeZone, startDate, 17);
    }

    private void verifyBCDCalculation(DateTimeZone accountTimeZone, DateTime startDateUTC, int bcdLocal) throws AccountApiException, CatalogApiException {
        BillCycleDayCalculator billCycleDayCalculator = new BillCycleDayCalculator((CatalogService)Mockito.mock(CatalogService.class), (SubscriptionBaseInternalApi)Mockito.mock(SubscriptionBaseInternalApi.class));
        SubscriptionBase subscription = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)subscription.getStartDate()).thenReturn((Object)startDateUTC);
        Plan plan = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)plan.dateOfFirstRecurringNonZeroCharge(startDateUTC, null)).thenReturn((Object)startDateUTC);
        Account account = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account.getTimeZone()).thenReturn((Object)accountTimeZone);
        Integer bcd = billCycleDayCalculator.calculateBcdFromSubscription(subscription, plan, account, (Catalog)Mockito.mock(Catalog.class), this.internalCallContext);
        Assert.assertEquals((Object)bcd, (Object)bcdLocal);
    }
}

