/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import java.util.Collections;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.PaymentMethodResource;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestPaymentMethodResource
extends JaxrsTestSuiteNoDB {
    private HttpServletRequest servletRequest;
    private AccountUserApi accountUserApi;
    private JaxrsUriBuilder uriBuilder;
    private PaymentApi paymentApi;
    private AuditUserApi auditUserApi;
    private Context context;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        if (this.hasFailed()) {
            return;
        }
        this.servletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.accountUserApi = (AccountUserApi)Mockito.mock(AccountUserApi.class);
        this.uriBuilder = (JaxrsUriBuilder)Mockito.mock(JaxrsUriBuilder.class);
        this.paymentApi = (PaymentApi)Mockito.mock(PaymentApi.class);
        this.auditUserApi = (AuditUserApi)Mockito.mock(AuditUserApi.class);
        this.context = (Context)Mockito.mock(Context.class);
    }

    private PaymentMethodResource createPaymentMethodResource() {
        PaymentMethodResource toSpy = new PaymentMethodResource(this.accountUserApi, this.uriBuilder, null, null, this.auditUserApi, this.paymentApi, null, (Clock)this.clock, this.context);
        return (PaymentMethodResource)Mockito.spy((Object)toSpy);
    }

    @Test(groups={"fast"})
    public void testGetPaymentMethod() throws AccountApiException, PaymentApiException {
        PaymentMethod paymentMethod = (PaymentMethod)Mockito.mock(PaymentMethod.class);
        Account account = (Account)Mockito.mock(Account.class);
        AuditMode fullMode = new AuditMode("FULL");
        Mockito.when((Object)this.paymentApi.getPaymentMethodById((UUID)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean(), (Iterable)Mockito.anyList(), (TenantContext)Mockito.any())).thenReturn((Object)paymentMethod);
        Mockito.when((Object)this.accountUserApi.getAccountById((UUID)Mockito.any(), (TenantContext)Mockito.any())).thenReturn((Object)account);
        PaymentMethodResource resource = this.createPaymentMethodResource();
        resource.getPaymentMethod(UUIDs.randomUUID(), Boolean.valueOf(false), Boolean.valueOf(false), Collections.emptyList(), fullMode, this.servletRequest);
        ((AccountUserApi)Mockito.verify((Object)this.accountUserApi, (VerificationMode)Mockito.times((int)1))).getAccountById((UUID)Mockito.any(), (TenantContext)Mockito.any());
        ((AuditUserApi)Mockito.verify((Object)this.auditUserApi, (VerificationMode)Mockito.times((int)1))).getAccountAuditLogs((UUID)Mockito.any(), (AuditLevel)Mockito.eq((Object)fullMode.getLevel()), (TenantContext)Mockito.any());
    }

    @Test(groups={"fast"})
    public void testGetPaymentMethodByKey() throws AccountApiException, PaymentApiException {
        PaymentMethod paymentMethod = (PaymentMethod)Mockito.mock(PaymentMethod.class);
        Account account = (Account)Mockito.mock(Account.class);
        AuditMode fullMode = new AuditMode("FULL");
        Mockito.when((Object)this.paymentApi.getPaymentMethodByExternalKey((String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean(), (Iterable)Mockito.anyList(), (TenantContext)Mockito.any())).thenReturn((Object)paymentMethod);
        Mockito.when((Object)this.accountUserApi.getAccountById((UUID)Mockito.any(), (TenantContext)Mockito.any())).thenReturn((Object)account);
        PaymentMethodResource resource = this.createPaymentMethodResource();
        resource.getPaymentMethodByKey("external-key", Boolean.valueOf(false), Boolean.valueOf(false), Collections.emptyList(), fullMode, this.servletRequest);
        ((AccountUserApi)Mockito.verify((Object)this.accountUserApi, (VerificationMode)Mockito.times((int)1))).getAccountById((UUID)Mockito.any(), (TenantContext)Mockito.any());
        ((AuditUserApi)Mockito.verify((Object)this.auditUserApi, (VerificationMode)Mockito.times((int)1))).getAccountAuditLogs((UUID)Mockito.any(), (AuditLevel)Mockito.eq((Object)fullMode.getLevel()), (TenantContext)Mockito.any());
    }
}

