/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.InvoiceResource;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.TenantContext;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestInvoiceResource
extends JaxrsTestSuiteNoDB {
    private HttpServletRequest servletRequest;
    private InvoiceUserApi invoiceUserApi;
    private AuditUserApi auditUserApi;
    private Context context;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        if (this.hasFailed()) {
            return;
        }
        this.servletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.invoiceUserApi = (InvoiceUserApi)Mockito.mock(InvoiceUserApi.class);
        this.auditUserApi = (AuditUserApi)Mockito.mock(AuditUserApi.class);
        this.context = (Context)Mockito.mock(Context.class);
    }

    private InvoiceResource createInvoiceResource() {
        InvoiceResource toSpy = new InvoiceResource(null, this.invoiceUserApi, null, null, null, null, null, null, this.auditUserApi, null, this.context);
        return (InvoiceResource)Mockito.spy((Object)toSpy);
    }

    @Test(groups={"fast"})
    public void testGetInvoice() throws InvoiceApiException {
        Invoice invoice = (Invoice)Mockito.mock(Invoice.class);
        AccountAuditLogs accountAuditLogs = (AccountAuditLogs)Mockito.mock(AccountAuditLogs.class);
        Mockito.when((Object)this.invoiceUserApi.getInvoice((UUID)Mockito.any(), (TenantContext)Mockito.any())).thenReturn((Object)invoice);
        Mockito.when((Object)this.auditUserApi.getAccountAuditLogs((UUID)Mockito.any(), (AuditLevel)Mockito.any(), (TenantContext)Mockito.any())).thenReturn((Object)accountAuditLogs);
        InvoiceResource resource = this.createInvoiceResource();
        resource.getInvoice(UUIDs.randomUUID(), false, new AuditMode("NONE"), this.servletRequest);
        ((InvoiceUserApi)Mockito.verify((Object)this.invoiceUserApi, (VerificationMode)Mockito.never())).getInvoiceItemsByParentInvoice((UUID)Mockito.any(), (TenantContext)Mockito.any());
        ((AuditUserApi)Mockito.verify((Object)this.auditUserApi, (VerificationMode)Mockito.times((int)1))).getAccountAuditLogs((UUID)Mockito.any(), (AuditLevel)Mockito.any(), (TenantContext)Mockito.any());
        resource.getInvoice(UUIDs.randomUUID(), true, new AuditMode("NONE"), this.servletRequest);
        ((InvoiceUserApi)Mockito.verify((Object)this.invoiceUserApi, (VerificationMode)Mockito.times((int)1))).getInvoiceItemsByParentInvoice((UUID)Mockito.any(), (TenantContext)Mockito.any());
        ((AuditUserApi)Mockito.verify((Object)this.auditUserApi, (VerificationMode)Mockito.times((int)2))).getAccountAuditLogs((UUID)Mockito.any(), (AuditLevel)Mockito.any(), (TenantContext)Mockito.any());
    }

    @Test(groups={"fast"})
    public void testGetInvoiceByNumber() throws InvoiceApiException {
        Invoice invoice = (Invoice)Mockito.mock(Invoice.class);
        AccountAuditLogs accountAuditLogs = (AccountAuditLogs)Mockito.mock(AccountAuditLogs.class);
        Mockito.when((Object)this.invoiceUserApi.getInvoiceByNumber((Integer)Mockito.any(), (TenantContext)Mockito.any())).thenReturn((Object)invoice);
        Mockito.when((Object)this.auditUserApi.getAccountAuditLogs((UUID)Mockito.any(), (AuditLevel)Mockito.any(), (TenantContext)Mockito.any())).thenReturn((Object)accountAuditLogs);
        InvoiceResource resource = this.createInvoiceResource();
        resource.getInvoiceByNumber(Integer.valueOf(123), false, new AuditMode("NONE"), this.servletRequest);
        ((InvoiceUserApi)Mockito.verify((Object)this.invoiceUserApi, (VerificationMode)Mockito.never())).getInvoiceItemsByParentInvoice((UUID)Mockito.any(), (TenantContext)Mockito.any());
        ((AuditUserApi)Mockito.verify((Object)this.auditUserApi, (VerificationMode)Mockito.times((int)1))).getAccountAuditLogs((UUID)Mockito.any(), (AuditLevel)Mockito.any(), (TenantContext)Mockito.any());
        resource.getInvoiceByNumber(Integer.valueOf(123), true, new AuditMode("NONE"), this.servletRequest);
        ((InvoiceUserApi)Mockito.verify((Object)this.invoiceUserApi, (VerificationMode)Mockito.times((int)1))).getInvoiceItemsByParentInvoice((UUID)Mockito.any(), (TenantContext)Mockito.any());
        ((AuditUserApi)Mockito.verify((Object)this.auditUserApi, (VerificationMode)Mockito.times((int)2))).getAccountAuditLogs((UUID)Mockito.any(), (AuditLevel)Mockito.any(), (TenantContext)Mockito.any());
    }

    @Test(groups={"fast"})
    public void testGetInvoiceByItemId() throws InvoiceApiException {
        Invoice invoice = (Invoice)Mockito.mock(Invoice.class);
        AccountAuditLogs accountAuditLogs = (AccountAuditLogs)Mockito.mock(AccountAuditLogs.class);
        Mockito.when((Object)this.invoiceUserApi.getInvoiceByInvoiceItem((UUID)Mockito.any(), (TenantContext)Mockito.any())).thenReturn((Object)invoice);
        Mockito.when((Object)this.auditUserApi.getAccountAuditLogs((UUID)Mockito.any(), (AuditLevel)Mockito.any(), (TenantContext)Mockito.any())).thenReturn((Object)accountAuditLogs);
        InvoiceResource resource = this.createInvoiceResource();
        resource.getInvoiceByItemId(UUIDs.randomUUID(), false, new AuditMode("NONE"), this.servletRequest);
        ((InvoiceUserApi)Mockito.verify((Object)this.invoiceUserApi, (VerificationMode)Mockito.never())).getInvoiceItemsByParentInvoice((UUID)Mockito.any(), (TenantContext)Mockito.any());
        ((AuditUserApi)Mockito.verify((Object)this.auditUserApi, (VerificationMode)Mockito.times((int)1))).getAccountAuditLogs((UUID)Mockito.any(), (AuditLevel)Mockito.any(), (TenantContext)Mockito.any());
        resource.getInvoiceByItemId(UUIDs.randomUUID(), true, new AuditMode("NONE"), this.servletRequest);
        ((InvoiceUserApi)Mockito.verify((Object)this.invoiceUserApi, (VerificationMode)Mockito.times((int)1))).getInvoiceItemsByParentInvoice((UUID)Mockito.any(), (TenantContext)Mockito.any());
        ((AuditUserApi)Mockito.verify((Object)this.auditUserApi, (VerificationMode)Mockito.times((int)2))).getAccountAuditLogs((UUID)Mockito.any(), (AuditLevel)Mockito.any(), (TenantContext)Mockito.any());
    }
}

