/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.JaxrsTestUtils;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.BundleJson;
import org.killbill.billing.jaxrs.json.PhasePriceJson;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBundleJsonWithSubscriptions
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        UUID someUUID = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        String bundleExternalKey = UUID.randomUUID().toString();
        String externalKey = UUID.randomUUID().toString();
        List<AuditLogJson> auditLogs = JaxrsTestUtils.createAuditLogsJson(this.clock.getUTCNow());
        SubscriptionJson.EventSubscriptionJson event = new SubscriptionJson.EventSubscriptionJson(UUID.randomUUID(), BillingPeriod.NO_BILLING_PERIOD, new DateTime(), new DateTime(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), SubscriptionEventType.START_BILLING, Boolean.valueOf(true), Boolean.valueOf(false), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), null);
        PhasePriceJson priceOverride = new PhasePriceJson(null, null, "somePhaseType", BigDecimal.ONE, null, null);
        SubscriptionJson subscription = new SubscriptionJson(UUID.randomUUID(), UUID.randomUUID(), bundleExternalKey, UUID.randomUUID(), externalKey, new DateTime(), UUID.randomUUID().toString(), ProductCategory.BASE, BillingPeriod.MONTHLY, PhaseType.EVERGREEN, UUID.randomUUID().toString(), UUID.randomUUID().toString(), Entitlement.EntitlementState.ACTIVE, Entitlement.EntitlementSourceType.NATIVE, new DateTime(), new LocalDate(), new DateTime(), new DateTime(), null, Integer.valueOf(1), List.of(event), List.of(priceOverride), null, auditLogs);
        BundleJson bundleJson = new BundleJson(someUUID, bundleId, bundleExternalKey, List.of(subscription), null, auditLogs);
        Assert.assertEquals((Object)bundleJson.getBundleId(), (Object)bundleId);
        Assert.assertEquals((String)bundleJson.getExternalKey(), (String)bundleExternalKey);
        Assert.assertEquals((int)bundleJson.getSubscriptions().size(), (int)1);
        Assert.assertEquals((Collection)bundleJson.getAuditLogs(), auditLogs);
        String asJson = this.mapper.writeValueAsString((Object)bundleJson);
        BundleJson fromJson = (BundleJson)this.mapper.readValue(asJson, BundleJson.class);
        Assert.assertEquals((Object)fromJson, (Object)bundleJson);
    }
}

