/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.resources.OverdueResource;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.overdue.api.OverdueApi;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.utils.io.Resources;
import org.killbill.xmlloader.XMLLoader;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOverdueResource
extends JaxrsTestSuiteNoDB {
    private final ServletRequest servletRequest = (ServletRequest)Mockito.mock(ServletRequest.class);
    private final TenantContext tenantContext = (TenantContext)Mockito.mock(TenantContext.class);
    private final JaxrsUriBuilder jaxrsUriBuilder = (JaxrsUriBuilder)Mockito.mock(JaxrsUriBuilder.class);
    private final TagUserApi tagUserApi = (TagUserApi)Mockito.mock(TagUserApi.class);
    private final CustomFieldUserApi customFieldUserApi = (CustomFieldUserApi)Mockito.mock(CustomFieldUserApi.class);
    private final AuditUserApi auditUserApi = (AuditUserApi)Mockito.mock(AuditUserApi.class);
    private final AccountUserApi accountUserApi = (AccountUserApi)Mockito.mock(AccountUserApi.class);
    private final PaymentApi paymentApi = (PaymentApi)Mockito.mock(PaymentApi.class);
    private final InvoicePaymentApi invoicePaymentApi = (InvoicePaymentApi)Mockito.mock(InvoicePaymentApi.class);
    private final OverdueApi overdueApi = (OverdueApi)Mockito.mock(OverdueApi.class);
    private final Clock clock = (Clock)Mockito.mock(Clock.class);
    private final Context context = (Context)Mockito.mock(Context.class);

    private OverdueResource newOverdueResource() {
        return new OverdueResource(this.jaxrsUriBuilder, this.tagUserApi, this.customFieldUserApi, this.auditUserApi, this.accountUserApi, this.paymentApi, this.invoicePaymentApi, this.overdueApi, this.clock, this.context);
    }

    protected DefaultOverdueConfig getOverdueConfig(String name) throws Exception {
        return (DefaultOverdueConfig)XMLLoader.getObjectFromString((String)Resources.getResource((String)("org/killbill/billing/jaxrs/resources/overdue/" + name)).toExternalForm(), DefaultOverdueConfig.class);
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/1497")
    public void testGetOverdueConfigJsonNoTimeSinceEarliest() throws Exception {
        DefaultOverdueConfig overdueConfig = this.getOverdueConfig("overdue_noTimeSinceEarliest.xml");
        Mockito.when((Object)this.context.createTenantContextNoAccountId(this.servletRequest)).thenReturn((Object)this.tenantContext);
        Mockito.when((Object)this.overdueApi.getOverdueConfig((TenantContext)Mockito.any())).thenReturn((Object)overdueConfig);
        OverdueResource resource = this.newOverdueResource();
        Response response = resource.getOverdueConfigJson((HttpServletRequest)Mockito.any());
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }

    @Test(groups={"fast"})
    public void testGetOverdueConfigJson() throws Exception {
        DefaultOverdueConfig overdueConfig = this.getOverdueConfig("overdue_valid.xml");
        Mockito.when((Object)this.context.createTenantContextNoAccountId(this.servletRequest)).thenReturn((Object)this.tenantContext);
        Mockito.when((Object)this.overdueApi.getOverdueConfig((TenantContext)Mockito.any())).thenReturn((Object)overdueConfig);
        OverdueResource resource = this.newOverdueResource();
        Response response = resource.getOverdueConfigJson((HttpServletRequest)Mockito.any());
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/1497")
    public void testGetOverdueConfigJsonWithTimeSinceEarliest() throws Exception {
        DefaultOverdueConfig overdueConfig = this.getOverdueConfig("overdue_withTimeSinceEarliest.xml");
        Mockito.when((Object)this.context.createTenantContextNoAccountId(this.servletRequest)).thenReturn((Object)this.tenantContext);
        Mockito.when((Object)this.overdueApi.getOverdueConfig((TenantContext)Mockito.any())).thenReturn((Object)overdueConfig);
        OverdueResource resource = this.newOverdueResource();
        Response response = resource.getOverdueConfigJson((HttpServletRequest)Mockito.any());
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/1497")
    public void testGetOverdueConfigJsonWithTimeSinceEarliestNoTotalInvoice() throws Exception {
        DefaultOverdueConfig overdueConfig = this.getOverdueConfig("overdue_withTimeSinceEarliestNoTotalUnpaidInvoice.xml");
        Mockito.when((Object)this.context.createTenantContextNoAccountId(this.servletRequest)).thenReturn((Object)this.tenantContext);
        Mockito.when((Object)this.overdueApi.getOverdueConfig((TenantContext)Mockito.any())).thenReturn((Object)overdueConfig);
        OverdueResource resource = this.newOverdueResource();
        Response response = resource.getOverdueConfigJson((HttpServletRequest)Mockito.any());
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }
}

