/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.killbill.billing.ObjectType;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.entity.Entity;
import org.killbill.commons.utils.collect.Iterables;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestJaxRsResourceBase
extends JaxrsTestSuiteNoDB {
    private CustomFieldUserApi customFieldUserApi;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        if (this.hasFailed()) {
            return;
        }
        this.customFieldUserApi = (CustomFieldUserApi)Mockito.mock(CustomFieldUserApi.class);
    }

    private JaxRsResourceBase createJaxRsResourceBase() {
        JaxRsResourceBase testJaxRsResourceBase = new JaxRsResourceBase(null, null, this.customFieldUserApi, null, null, null, null, null, null, null){};
        return (JaxRsResourceBase)Mockito.spy((Object)testJaxRsResourceBase);
    }

    @Test(groups={"fast"})
    public void testExtractPluginProperties() {
        List<String> pluginPropertiesString = List.of("payment_cryptogram=EHuWW9PiBkWvqE5juRwDzAUFBAk=", "cc_number=4111111111111111", "cc_type=visa", "cc_expiration_month=09", "cc_expiration_year=2020");
        JaxRsResourceBase base = this.createJaxRsResourceBase();
        List pluginProperties = Iterables.toUnmodifiableList((Iterable)base.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]));
        Assert.assertEquals((int)pluginProperties.size(), (int)5);
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(0)).getKey(), (String)"payment_cryptogram");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(0)).getValue(), (Object)"EHuWW9PiBkWvqE5juRwDzAUFBAk=");
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(1)).getKey(), (String)"cc_number");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(1)).getValue(), (Object)"4111111111111111");
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(2)).getKey(), (String)"cc_type");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(2)).getValue(), (Object)"visa");
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(3)).getKey(), (String)"cc_expiration_month");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(3)).getValue(), (Object)"09");
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(4)).getKey(), (String)"cc_expiration_year");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(4)).getValue(), (Object)"2020");
    }

    @Test(groups={"fast"})
    public void testExtractPluginPropertiesWithNullProperty() {
        JaxRsResourceBase base = this.createJaxRsResourceBase();
        List<String> pluginPropertiesString = List.of("foo=", "bar=ttt");
        List pluginProperties = Iterables.toUnmodifiableList((Iterable)base.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]));
        Assert.assertEquals((int)pluginProperties.size(), (int)1);
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(0)).getKey(), (String)"bar");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(0)).getValue(), (Object)"ttt");
    }

    private List<CustomField> createCustomFields() {
        ArrayList<CustomField> result = new ArrayList<CustomField>();
        for (int i = 1; i <= 5; ++i) {
            CustomField customField = (CustomField)Mockito.mock(CustomField.class);
            Mockito.when((Object)customField.getId()).thenReturn((Object)UUIDs.randomUUID());
            Mockito.when((Object)customField.getFieldName()).thenReturn((Object)String.valueOf(i));
            result.add(customField);
        }
        return result;
    }

    @Test(groups={"fast"})
    public void testDeleteCustomFieldsWithSomeIds() throws CustomFieldApiException {
        UUID id = UUIDs.randomUUID();
        List<CustomField> fromDatabase = this.createCustomFields();
        List idsToCheck = fromDatabase.stream().filter(customField -> customField.getFieldName().contains("1") || customField.getFieldName().contains("2")).map(Entity::getId).collect(Collectors.toUnmodifiableList());
        JaxRsResourceBase base = this.createJaxRsResourceBase();
        Mockito.when((Object)this.customFieldUserApi.getCustomFieldsForObject((UUID)Mockito.any(), (ObjectType)Mockito.any(), (TenantContext)Mockito.any())).thenReturn(fromDatabase);
        base.deleteCustomFields(id, idsToCheck, (CallContext)this.callContext);
        ((CustomFieldUserApi)Mockito.verify((Object)this.customFieldUserApi, (VerificationMode)Mockito.times((int)1))).removeCustomFields(Mockito.anyList(), (CallContext)Mockito.any());
    }

    @Test(groups={"fast"})
    public void testDeleteCustomFieldsWithoutMatchingIds() throws CustomFieldApiException {
        UUID id = UUIDs.randomUUID();
        List<CustomField> fromDatabase = this.createCustomFields();
        List<UUID> idsToCheck = List.of(UUIDs.randomUUID(), UUIDs.randomUUID(), UUIDs.randomUUID());
        JaxRsResourceBase base = this.createJaxRsResourceBase();
        Mockito.when((Object)this.customFieldUserApi.getCustomFieldsForObject((UUID)Mockito.any(), (ObjectType)Mockito.any(), (TenantContext)Mockito.any())).thenReturn(fromDatabase);
        base.deleteCustomFields(id, idsToCheck, (CallContext)this.callContext);
        ((CustomFieldUserApi)Mockito.verify((Object)this.customFieldUserApi, (VerificationMode)Mockito.never())).removeCustomFields(Mockito.anyList(), (CallContext)Mockito.any());
    }

    @Test(groups={"fast"})
    public void testDeleteCustomFieldsWithEmptyIds() throws CustomFieldApiException {
        UUID id = UUIDs.randomUUID();
        List<CustomField> fromDatabase = this.createCustomFields();
        List idsToCheck = Collections.emptyList();
        JaxRsResourceBase base = this.createJaxRsResourceBase();
        Mockito.when((Object)this.customFieldUserApi.getCustomFieldsForObject((UUID)Mockito.any(), (ObjectType)Mockito.any(), (TenantContext)Mockito.any())).thenReturn(fromDatabase);
        base.deleteCustomFields(id, idsToCheck, (CallContext)this.callContext);
        ((CustomFieldUserApi)Mockito.verify((Object)this.customFieldUserApi, (VerificationMode)Mockito.times((int)1))).removeCustomFields(Mockito.anyList(), (CallContext)Mockito.any());
    }

    @Test(groups={"fast"})
    public void testDeleteCustomFieldsWithNullIds() throws CustomFieldApiException {
        UUID id = UUIDs.randomUUID();
        List<CustomField> fromDatabase = this.createCustomFields();
        JaxRsResourceBase base = this.createJaxRsResourceBase();
        Mockito.when((Object)this.customFieldUserApi.getCustomFieldsForObject((UUID)Mockito.any(), (ObjectType)Mockito.any(), (TenantContext)Mockito.any())).thenReturn(fromDatabase);
        base.deleteCustomFields(id, null, (CallContext)this.callContext);
        ((CustomFieldUserApi)Mockito.verify((Object)this.customFieldUserApi, (VerificationMode)Mockito.times((int)1))).removeCustomFields(Mockito.anyList(), (CallContext)Mockito.any());
    }
}

