/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.JaxrsTestUtils;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.PhasePriceJson;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.killbill.clock.DefaultClock;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEntitlementJsonWithEvents
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        String bundleExternalKey = UUID.randomUUID().toString();
        String externalKey = UUID.randomUUID().toString();
        DateTime effectiveDate = DefaultClock.toUTCDateTime((DateTime)new DateTime(DateTimeZone.UTC));
        DateTime catalogEffectiveDate = DefaultClock.toUTCDateTime((DateTime)new DateTime(DateTimeZone.UTC));
        UUID eventId = UUID.randomUUID();
        List<AuditLogJson> auditLogs = JaxrsTestUtils.createAuditLogsJson(this.clock.getUTCNow());
        SubscriptionJson.EventSubscriptionJson newEvent = new SubscriptionJson.EventSubscriptionJson(eventId, BillingPeriod.NO_BILLING_PERIOD, effectiveDate, catalogEffectiveDate, UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), SubscriptionEventType.PHASE, Boolean.valueOf(false), Boolean.valueOf(true), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), auditLogs);
        PhasePriceJson priceOverride = new PhasePriceJson("foo", "bar", null, BigDecimal.TEN, BigDecimal.ONE, null);
        SubscriptionJson entitlementJsonWithEvents = new SubscriptionJson(UUID.randomUUID(), UUID.randomUUID(), bundleExternalKey, UUID.randomUUID(), externalKey, new DateTime(), UUID.randomUUID().toString(), ProductCategory.BASE, BillingPeriod.MONTHLY, PhaseType.EVERGREEN, UUID.randomUUID().toString(), UUID.randomUUID().toString(), Entitlement.EntitlementState.ACTIVE, Entitlement.EntitlementSourceType.NATIVE, new DateTime(), new LocalDate(), new DateTime(), new DateTime(), null, Integer.valueOf(1), List.of(newEvent), List.of(priceOverride), null, auditLogs);
        String asJson = this.mapper.writeValueAsString((Object)entitlementJsonWithEvents);
        SubscriptionJson fromJson = (SubscriptionJson)this.mapper.readValue(asJson, SubscriptionJson.class);
        Assert.assertEquals((Object)fromJson, (Object)entitlementJsonWithEvents);
    }
}

