/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.util;

import com.google.common.base.MoreObjects;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.resources.JaxrsResource;
import org.killbill.billing.util.config.definition.JaxrsConfig;

public class JaxrsUriBuilder {
    private final JaxrsConfig jaxrsConfig;
    private final Map<Class, UriBuilder> classToUriBuilder = new HashMap<Class, UriBuilder>();
    private final Map<String, UriBuilder> classAndMethodToUriBuilder = new HashMap<String, UriBuilder>();
    private final Map<String, UriBuilder> pathAndClassToUriBuilder = new HashMap<String, UriBuilder>();
    private final Map<String, UriBuilder> pathClassAndMethodToUriBuilder = new HashMap<String, UriBuilder>();

    @Inject
    public JaxrsUriBuilder(JaxrsConfig jaxrsConfig) {
        this.jaxrsConfig = jaxrsConfig;
    }

    public Response buildResponse(UriInfo uriInfo, Class<? extends JaxrsResource> theClass, String getMethodName, Object objectId, ServletRequest request) {
        return this.buildResponse(uriInfo, theClass, getMethodName, objectId, null, request);
    }

    public Response buildResponse(UriInfo uriInfo, Class<? extends JaxrsResource> theClass, String getMethodName, Object objectId, Map<String, String> params, ServletRequest request) {
        return this.buildResponse(Response.status((Response.Status)Response.Status.CREATED), uriInfo, theClass, getMethodName, objectId, params, request);
    }

    public Response buildResponse(Response.ResponseBuilder responseBuilder, UriInfo uriInfo, Class<? extends JaxrsResource> theClass, String getMethodName, Object objectId, ServletRequest request) {
        return this.buildResponse(responseBuilder, uriInfo, theClass, getMethodName, objectId, null, request);
    }

    public Response buildResponse(Response.ResponseBuilder responseBuilder, UriInfo uriInfo, Class<? extends JaxrsResource> theClass, String getMethodName, Object objectId, Map<String, String> params, ServletRequest request) {
        URI location = this.buildLocation(uriInfo, theClass, getMethodName, objectId, params, request);
        return !this.jaxrsConfig.isJaxrsLocationFullUrl() ? responseBuilder.header("Location", (Object)location.getPath()).build() : responseBuilder.location(location).build();
    }

    private URI buildLocation(UriInfo uriInfo, Class<? extends JaxrsResource> theClass, String getMethodName, Object objectId, Map<String, String> params, ServletRequest request) {
        UriBuilder uriBuilder = this.getUriBuilder(uriInfo.getBaseUri().getPath(), theClass, getMethodName);
        if (null != params && !params.isEmpty()) {
            for (String key : params.keySet()) {
                uriBuilder.queryParam(key, new Object[]{params.get(key)});
            }
        }
        if (this.jaxrsConfig.isJaxrsLocationFullUrl()) {
            if (this.jaxrsConfig.isJaxrsLocationUseForwardHeaders()) {
                uriBuilder.scheme(request.getScheme()).host((String)MoreObjects.firstNonNull((Object)this.jaxrsConfig.getJaxrsLocationHost(), (Object)request.getServerName())).port(request.getServerPort());
            } else {
                uriBuilder.scheme(uriInfo.getAbsolutePath().getScheme()).host(uriInfo.getAbsolutePath().getHost()).port(uriInfo.getAbsolutePath().getPort());
            }
        }
        return objectId != null ? uriBuilder.build(new Object[]{objectId}) : uriBuilder.build(new Object[0]);
    }

    public URI nextPage(Class<? extends JaxrsResource> theClass, String getMethodName, Long nextOffset, Long limit, Map<String, String> params) {
        if (nextOffset == null || limit == null) {
            return null;
        }
        UriBuilder uriBuilder = this.getUriBuilder(theClass, getMethodName).queryParam("offset", new Object[]{nextOffset}).queryParam("limit", new Object[]{limit});
        for (String key : params.keySet()) {
            uriBuilder.queryParam(key, new Object[]{params.get(key)});
        }
        return uriBuilder.build(new Object[0]);
    }

    private UriBuilder getUriBuilder(String path, Class<? extends JaxrsResource> theClassMaybeEnhanced, @Nullable String getMethodName) {
        Class theClass = this.getNonEnhancedClass(theClassMaybeEnhanced);
        return getMethodName != null ? this.fromPath(path.equals("/") ? path.substring(1) : path, theClass, getMethodName) : this.fromPath(path, theClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UriBuilder fromPath(String path, Class theClass, String getMethodName) {
        String key = path + theClass.getName() + getMethodName;
        UriBuilder uriBuilder = this.pathClassAndMethodToUriBuilder.get(key);
        if (uriBuilder == null) {
            Map<String, UriBuilder> map = this.pathClassAndMethodToUriBuilder;
            synchronized (map) {
                uriBuilder = this.pathClassAndMethodToUriBuilder.get(key);
                if (uriBuilder == null) {
                    uriBuilder = this.fromPath(path, theClass).path(theClass, getMethodName);
                    this.pathClassAndMethodToUriBuilder.put(key, uriBuilder);
                }
            }
        }
        return uriBuilder.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UriBuilder fromPath(String path, Class theClass) {
        String key = path + theClass.getName();
        UriBuilder uriBuilder = this.pathAndClassToUriBuilder.get(key);
        if (uriBuilder == null) {
            Map<String, UriBuilder> map = this.pathAndClassToUriBuilder;
            synchronized (map) {
                uriBuilder = this.pathAndClassToUriBuilder.get(key);
                if (uriBuilder == null) {
                    uriBuilder = UriBuilder.fromPath((String)path).path(theClass);
                    this.pathAndClassToUriBuilder.put(key, uriBuilder);
                }
            }
        }
        return uriBuilder.clone();
    }

    private UriBuilder getUriBuilder(Class<? extends JaxrsResource> theClassMaybeEnhanced, @Nullable String getMethodName) {
        Class theClass = this.getNonEnhancedClass(theClassMaybeEnhanced);
        return getMethodName != null ? this.fromResource(theClass, getMethodName) : this.fromResource(theClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UriBuilder fromResource(Class theClass, String getMethodName) {
        String key = theClass.getName() + getMethodName;
        UriBuilder uriBuilder = this.classAndMethodToUriBuilder.get(key);
        if (uriBuilder == null) {
            Map<String, UriBuilder> map = this.classAndMethodToUriBuilder;
            synchronized (map) {
                uriBuilder = this.classAndMethodToUriBuilder.get(key);
                if (uriBuilder == null) {
                    uriBuilder = this.fromResource(theClass).path(theClass, getMethodName);
                    this.classAndMethodToUriBuilder.put(key, uriBuilder);
                }
            }
        }
        return uriBuilder.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UriBuilder fromResource(Class theClass) {
        UriBuilder uriBuilder = this.classToUriBuilder.get(theClass);
        if (uriBuilder == null) {
            Map<Class, UriBuilder> map = this.classToUriBuilder;
            synchronized (map) {
                uriBuilder = this.classToUriBuilder.get(theClass);
                if (uriBuilder == null) {
                    uriBuilder = UriBuilder.fromResource((Class)theClass);
                    this.classToUriBuilder.put(theClass, uriBuilder);
                }
            }
        }
        return uriBuilder.clone();
    }

    private Class getNonEnhancedClass(Class<? extends JaxrsResource> theClassMaybeEnhanced) {
        Class<? extends JaxrsResource> theClass = theClassMaybeEnhanced;
        while (theClass.getAnnotation(Path.class) == null && JaxRsResourceBase.class.isAssignableFrom(theClass)) {
            theClass = theClass.getSuperclass();
        }
        return theClass;
    }
}

