/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.util;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.UUID;
import javax.servlet.ServletRequest;
import org.killbill.billing.tenant.api.Tenant;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.CallContextFactory;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.callcontext.UserType;
import org.killbill.commons.request.Request;

public class Context {
    private final CallOrigin origin = CallOrigin.EXTERNAL;
    private final UserType userType = UserType.CUSTOMER;
    private final CallContextFactory contextFactory;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public Context(CallContextFactory factory, InternalCallContextFactory internalCallContextFactory) {
        this.contextFactory = factory;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public CallContext createCallContextNoAccountId(String createdBy, String reason, String comment, ServletRequest request) throws IllegalArgumentException {
        return this.createCallContextWithAccountId(null, createdBy, reason, comment, request);
    }

    public CallContext createCallContextWithAccountId(UUID accountId, String createdBy, String reason, String comment, ServletRequest request) throws IllegalArgumentException {
        try {
            Preconditions.checkNotNull((Object)createdBy, (Object)String.format("Header %s needs to be set", "X-Killbill-CreatedBy"));
            Tenant tenant = this.getTenantFromRequest(request);
            UUID tenantId = tenant == null ? null : tenant.getId();
            CallContext callContext = this.contextFactory.createCallContext(accountId, tenantId, createdBy, this.origin, this.userType, reason, comment, Context.getOrCreateUserToken());
            this.populateMDCContext(callContext);
            return callContext;
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public TenantContext createTenantContextNoAccountId(ServletRequest request) {
        return this.createTenantContextWithAccountId(null, request);
    }

    public TenantContext createTenantContextWithAccountId(UUID accountId, ServletRequest request) {
        Tenant tenant = this.getTenantFromRequest(request);
        TenantContext tenantContext = tenant == null ? this.contextFactory.createTenantContext(accountId, null) : this.contextFactory.createTenantContext(accountId, tenant.getId());
        this.populateMDCContext(tenantContext);
        return tenantContext;
    }

    public static UUID getOrCreateUserToken() {
        UUID userToken;
        if (Request.getPerThreadRequestData().getRequestId() != null) {
            try {
                userToken = UUID.fromString(Request.getPerThreadRequestData().getRequestId());
            }
            catch (IllegalArgumentException ignored) {
                userToken = UUIDs.randomUUID();
            }
        } else {
            userToken = UUIDs.randomUUID();
        }
        return userToken;
    }

    private Tenant getTenantFromRequest(ServletRequest request) {
        Object tenantObject = request.getAttribute("killbill_tenant");
        if (tenantObject == null) {
            return null;
        }
        return (Tenant)tenantObject;
    }

    private void populateMDCContext(CallContext callContext) {
        this.internalCallContextFactory.createInternalCallContextWithoutAccountRecordId(callContext);
    }

    private void populateMDCContext(TenantContext tenantContext) {
        this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(tenantContext);
    }
}

