/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.inject.Singleton;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.EntitlementApi;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.jaxrs.json.RolledUpUsageJson;
import org.killbill.billing.jaxrs.json.SubscriptionUsageRecordJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.usage.api.RolledUpUsage;
import org.killbill.billing.usage.api.SubscriptionUsageRecord;
import org.killbill.billing.usage.api.UsageApiException;
import org.killbill.billing.usage.api.UsageUserApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Singleton
@Path(value="/1.0/kb/usages")
@Api(value="/1.0/kb/usages", description="Operations on usage", tags={"Usage"})
public class UsageResource
extends JaxRsResourceBase {
    private final UsageUserApi usageUserApi;
    private final EntitlementApi entitlementApi;

    @Inject
    public UsageResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, UsageUserApi usageUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, EntitlementApi entitlementApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
        this.usageUserApi = usageUserApi;
        this.entitlementApi = entitlementApi;
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Record usage for a subscription")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully recorded usage data change"), @ApiResponse(code=400, message="Invalid subscription (e.g. inactive)")})
    public Response recordUsage(SubscriptionUsageRecordJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws EntitlementApiException, AccountApiException, UsageApiException {
        this.verifyNonNullOrEmpty(json, "SubscriptionUsageRecordJson body should be specified");
        this.verifyNonNullOrEmpty(json.getSubscriptionId(), "SubscriptionUsageRecordJson subscriptionId needs to be set", json.getUnitUsageRecords(), "SubscriptionUsageRecordJson unitUsageRecords needs to be set");
        Preconditions.checkArgument((!json.getUnitUsageRecords().isEmpty() ? 1 : 0) != 0);
        for (SubscriptionUsageRecordJson.UnitUsageRecordJson unitUsageRecordJson : json.getUnitUsageRecords()) {
            this.verifyNonNullOrEmpty(unitUsageRecordJson.getUnitType(), "UnitUsageRecordJson unitType need to be set");
            Preconditions.checkArgument((Iterables.size(unitUsageRecordJson.getUsageRecords()) > 0 ? 1 : 0) != 0, (Object)"UnitUsageRecordJson usageRecords must have at least one element.");
            for (SubscriptionUsageRecordJson.UsageRecordJson usageRecordJson : unitUsageRecordJson.getUsageRecords()) {
                this.verifyNonNull(usageRecordJson.getAmount(), "UsageRecordJson amount needs to be set");
                this.verifyNonNull(usageRecordJson.getRecordDate(), "UsageRecordJson recordDate needs to be set");
            }
        }
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Entitlement entitlement = this.entitlementApi.getEntitlementForId(json.getSubscriptionId(), (TenantContext)callContext);
        if (entitlement.getEffectiveEndDate() != null) {
            LocalDate highestRecordDate = this.getHighestRecordDate(json.getUnitUsageRecords());
            if (entitlement.getEffectiveEndDate().compareTo((ReadablePartial)highestRecordDate) < 0) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        SubscriptionUsageRecord record = json.toSubscriptionUsageRecord();
        this.usageUserApi.recordRolledUpUsage(record, callContext);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @VisibleForTesting
    LocalDate getHighestRecordDate(List<SubscriptionUsageRecordJson.UnitUsageRecordJson> records) {
        Iterable recordedDates = Iterables.transform(records, (Function)new Function<SubscriptionUsageRecordJson.UnitUsageRecordJson, Iterable<LocalDate>>(){

            public Iterable<LocalDate> apply(SubscriptionUsageRecordJson.UnitUsageRecordJson input) {
                Iterable result = Iterables.transform(input.getUsageRecords(), (Function)new Function<SubscriptionUsageRecordJson.UsageRecordJson, LocalDate>(){

                    public LocalDate apply(SubscriptionUsageRecordJson.UsageRecordJson input) {
                        return input.getRecordDate();
                    }
                });
                return result;
            }
        });
        List sortedRecordedDates = Ordering.natural().reverse().sortedCopy(Iterables.concat((Iterable)recordedDates));
        return (LocalDate)Iterables.getFirst((Iterable)sortedRecordedDates, null);
    }

    @TimedResource
    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/{unitType}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve usage for a subscription and unit type", response=RolledUpUsageJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Missing start date or end date")})
    public Response getUsage(@PathParam(value="subscriptionId") UUID subscriptionId, @PathParam(value="unitType") String unitType, @QueryParam(value="startDate") String startDate, @QueryParam(value="endDate") String endDate, @Context HttpServletRequest request) {
        if (startDate == null || endDate == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        LocalDate usageStartDate = this.LOCAL_DATE_FORMATTER.parseLocalDate(startDate);
        LocalDate usageEndDate = this.LOCAL_DATE_FORMATTER.parseLocalDate(endDate);
        RolledUpUsage usage = this.usageUserApi.getUsageForSubscription(subscriptionId, unitType, usageStartDate, usageEndDate, tenantContext);
        RolledUpUsageJson result = new RolledUpUsageJson(usage);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve usage for a subscription", response=RolledUpUsageJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Missing start date or end date")})
    public Response getAllUsage(@PathParam(value="subscriptionId") UUID subscriptionId, @QueryParam(value="startDate") String startDate, @QueryParam(value="endDate") String endDate, @Context HttpServletRequest request) {
        if (startDate == null || endDate == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        LocalDate usageStartDate = this.LOCAL_DATE_FORMATTER.parseLocalDate(startDate);
        LocalDate usageEndDate = this.LOCAL_DATE_FORMATTER.parseLocalDate(endDate);
        ImmutableList startEndDate = ImmutableList.builder().add((Object)usageStartDate).add((Object)usageEndDate).build();
        List usage = this.usageUserApi.getAllUsageForSubscription(subscriptionId, (List)startEndDate, tenantContext);
        RolledUpUsageJson result = new RolledUpUsageJson((RolledUpUsage)usage.get(0));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }
}

