/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterables;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Iterator;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.CatalogUserApi;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.tenant.api.TenantUserApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.RecordIdApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;
import org.killbill.notificationq.api.NotificationEventWithMetadata;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/1.0/kb/test")
@Api(value="/1.0/kb/test", description="Operations for testing", hidden=true)
public class TestResource
extends JaxRsResourceBase {
    private static final Logger log = LoggerFactory.getLogger(TestResource.class);
    private static final int MILLIS_IN_SEC = 1000;
    private final PersistentBus persistentBus;
    private final NotificationQueueService notificationQueueService;
    private final RecordIdApi recordIdApi;
    private final TenantUserApi tenantApi;
    private final CatalogUserApi catalogUserApi;
    private final CacheControllerDispatcher cacheControllerDispatcher;

    @Inject
    public TestResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, RecordIdApi recordIdApi, PersistentBus persistentBus, NotificationQueueService notificationQueueService, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, TenantUserApi tenantApi, CatalogUserApi catalogUserApi, Clock clock, CacheControllerDispatcher cacheControllerDispatcher, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
        this.persistentBus = persistentBus;
        this.notificationQueueService = notificationQueueService;
        this.recordIdApi = recordIdApi;
        this.catalogUserApi = catalogUserApi;
        this.tenantApi = tenantApi;
        this.cacheControllerDispatcher = cacheControllerDispatcher;
    }

    @GET
    @Path(value="/queues")
    @ApiOperation(value="Wait for all available bus events and notifications to be processed")
    @ApiResponses(value={@ApiResponse(code=412, message="Timeout too short")})
    public Response waitForQueuesToComplete(@QueryParam(value="timeoutSec") @DefaultValue(value="5") Long timeoutSec, @Context HttpServletRequest request) {
        boolean areAllNotificationsProcessed = this.waitForNotificationToComplete((ServletRequest)request, timeoutSec);
        return Response.status((Response.Status)(areAllNotificationsProcessed ? Response.Status.OK : Response.Status.PRECONDITION_FAILED)).build();
    }

    @GET
    @Path(value="/clock")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the current time", response=ClockResource.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timezone supplied")})
    public Response getCurrentTime(@QueryParam(value="timeZone") String timeZoneStr) {
        DateTimeZone timeZone = timeZoneStr != null ? DateTimeZone.forID((String)timeZoneStr) : DateTimeZone.UTC;
        DateTime now = this.clock.getUTCNow();
        ClockResource result = new ClockResource(now, timeZone.getID(), new LocalDate((Object)now, timeZone));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @POST
    @Path(value="/clock")
    @Produces(value={"application/json"})
    @ApiOperation(value="Set the current time", response=ClockResource.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid time or timezone supplied")})
    public Response setTestClockTime(@QueryParam(value="requestedDate") String requestedClockDate, @QueryParam(value="timeZone") String timeZoneStr, @QueryParam(value="timeoutSec") @DefaultValue(value="5") Long timeoutSec, @Context HttpServletRequest request) {
        ClockMock testClock = this.getClockMock();
        if (requestedClockDate == null) {
            testClock.resetDeltaFromReality();
        } else {
            DateTime newTime = this.DATE_TIME_FORMATTER.parseDateTime(requestedClockDate).toDateTime(DateTimeZone.UTC);
            testClock.setTime(newTime);
        }
        this.waitForNotificationToComplete((ServletRequest)request, timeoutSec);
        return this.getCurrentTime(timeZoneStr);
    }

    @PUT
    @Path(value="/clock")
    @Produces(value={"application/json"})
    @ApiOperation(value="Move the current time", response=ClockResource.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timezone supplied")})
    public Response updateTestClockTime(@QueryParam(value="days") Integer addDays, @QueryParam(value="weeks") Integer addWeeks, @QueryParam(value="months") Integer addMonths, @QueryParam(value="years") Integer addYears, @QueryParam(value="timeZone") String timeZoneStr, @QueryParam(value="timeoutSec") @DefaultValue(value="5") Long timeoutSec, @Context HttpServletRequest request) {
        ClockMock testClock = this.getClockMock();
        if (addDays != null) {
            testClock.addDays(addDays.intValue());
        } else if (addWeeks != null) {
            testClock.addWeeks(addWeeks.intValue());
        } else if (addMonths != null) {
            testClock.addMonths(addMonths.intValue());
        } else if (addYears != null) {
            testClock.addYears(addYears.intValue());
        }
        this.waitForNotificationToComplete((ServletRequest)request, timeoutSec);
        return this.getCurrentTime(timeZoneStr);
    }

    private boolean waitForNotificationToComplete(ServletRequest request, Long timeoutSec) {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId(request);
        Long tenantRecordId = this.recordIdApi.getRecordId(tenantContext.getTenantId(), ObjectType.TENANT, tenantContext);
        int nbTryLeft = timeoutSec != null ? timeoutSec.intValue() : 0;
        boolean areAllNotificationsProcessed = false;
        try {
            while (!areAllNotificationsProcessed && nbTryLeft > 0) {
                areAllNotificationsProcessed = this.areAllNotificationsProcessed(tenantRecordId);
                areAllNotificationsProcessed = areAllNotificationsProcessed && this.areAllBusEventsProcessed(tenantRecordId);
                areAllNotificationsProcessed = areAllNotificationsProcessed && this.areAllNotificationsProcessed(tenantRecordId);
                if (areAllNotificationsProcessed = areAllNotificationsProcessed && this.areAllBusEventsProcessed(tenantRecordId)) continue;
                Thread.sleep(1000L);
                --nbTryLeft;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!areAllNotificationsProcessed) {
            log.warn("TestResource: there are more notifications or bus events to process, consider increasing the timeout (currently {}s)", (Object)timeoutSec);
        }
        return areAllNotificationsProcessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areAllNotificationsProcessed(Long tenantRecordId) {
        int nbNotifications = 0;
        for (NotificationQueue notificationQueue : this.notificationQueueService.getNotificationQueues()) {
            Iterator iterator = notificationQueue.getFutureOrInProcessingNotificationForSearchKey2(null, tenantRecordId).iterator();
            try {
                while (iterator.hasNext()) {
                    NotificationEventWithMetadata notificationEvent = (NotificationEventWithMetadata)iterator.next();
                    if (notificationEvent.getEffectiveDate().isAfter((ReadableInstant)this.clock.getUTCNow())) continue;
                    ++nbNotifications;
                }
            }
            finally {
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
        }
        if (nbNotifications != 0) {
            log.info("TestResource: {} queue(s) with more notification(s) to process", (Object)nbNotifications);
        }
        return nbNotifications == 0;
    }

    private boolean areAllBusEventsProcessed(Long tenantRecordId) {
        Iterable availableBusEventForSearchKey2 = this.persistentBus.getAvailableOrInProcessingBusEventsForSearchKey2(null, tenantRecordId);
        int nbBusEvents = Iterables.size((Iterable)availableBusEventForSearchKey2);
        if (nbBusEvents != 0) {
            log.info("TestResource: at least {} more bus event(s) to process", (Object)nbBusEvents);
        }
        return nbBusEvents == 0;
    }

    private ClockMock getClockMock() {
        if (!(this.clock instanceof ClockMock)) {
            throw new UnsupportedOperationException("Kill Bill has not been configured to update the time");
        }
        return (ClockMock)this.clock;
    }

    public final class ClockResource {
        private final DateTime currentUtcTime;
        private final String timeZone;
        private final LocalDate localDate;

        @JsonCreator
        public ClockResource(@JsonProperty(value="timeZone") DateTime currentUtcTime, @JsonProperty(value="localDate") String timeZone, LocalDate localDate) {
            this.currentUtcTime = currentUtcTime;
            this.timeZone = timeZone;
            this.localDate = localDate;
        }

        public DateTime getCurrentUtcTime() {
            return this.currentUtcTime;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public LocalDate getLocalDate() {
            return this.localDate;
        }
    }
}

