/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.TagDefinitionJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Singleton
@Path(value="/1.0/kb/tagDefinitions")
@Api(value="/1.0/kb/tagDefinitions", description="Operations on tag definitions", tags={"TagDefinition"})
public class TagDefinitionResource
extends JaxRsResourceBase {
    @Inject
    public TagDefinitionResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List tag definitions", response=TagDefinitionJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getTagDefinitions(@Context HttpServletRequest request, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode) {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List tagDefinitions = this.tagUserApi.getTagDefinitions(tenantContext);
        LinkedList<TagDefinitionJson> result = new LinkedList<TagDefinitionJson>();
        for (TagDefinition tagDefinition : tagDefinitions) {
            List auditLogs = this.auditUserApi.getAuditLogs(tagDefinition.getId(), ObjectType.TAG_DEFINITION, auditMode.getLevel(), tenantContext);
            result.add(new TagDefinitionJson(tagDefinition, auditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @TimedResource
    @GET
    @Path(value="/{tagDefinitionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a tag definition", response=TagDefinitionJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tagDefinitionId supplied")})
    public Response getTagDefinition(@PathParam(value="tagDefinitionId") UUID tagDefId, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws TagDefinitionApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        TagDefinition tagDefinition = this.tagUserApi.getTagDefinition(tagDefId, tenantContext);
        List auditLogs = this.auditUserApi.getAuditLogs(tagDefinition.getId(), ObjectType.TAG_DEFINITION, auditMode.getLevel(), tenantContext);
        TagDefinitionJson json = new TagDefinitionJson(tagDefinition, auditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a tag definition", response=TagDefinitionJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Tag definition created successfully"), @ApiResponse(code=400, message="Invalid name or description supplied")})
    public Response createTagDefinition(TagDefinitionJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws TagDefinitionApiException {
        this.verifyNonNullOrEmpty(json, "TagDefinitionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getName(), "TagDefinition name needs to be set", json.getDescription(), "TagDefinition description needs to be set");
        Preconditions.checkArgument((json.getApplicableObjectTypes() != null && !json.getApplicableObjectTypes().isEmpty() ? 1 : 0) != 0, (Object)"Applicable object types must be set");
        TagDefinition createdTagDef = this.tagUserApi.createTagDefinition(json.getName(), json.getDescription(), json.getApplicableObjectTypes(), this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
        return this.uriBuilder.buildResponse(uriInfo, TagDefinitionResource.class, "getTagDefinition", createdTagDef.getId(), (ServletRequest)request);
    }

    @TimedResource
    @DELETE
    @Path(value="/{tagDefinitionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a tag definition")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid tagDefinitionId supplied")})
    public Response deleteTagDefinition(@PathParam(value="tagDefinitionId") UUID tagDefId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagDefinitionApiException {
        this.tagUserApi.deleteTagDefinition(tagDefId, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @GET
    @Path(value="/{tagDefinitionId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve tag definition audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response getTagDefinitionAuditLogsWithHistory(@PathParam(value="tagDefinitionId") UUID tagDefinitionId, @Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.tagUserApi.getTagDefinitionAuditLogsWithHistoryForId(tagDefinitionId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.TAG_DEFINITION;
    }
}

