/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.TierPriceOverride;
import org.killbill.billing.catalog.api.TieredBlockPriceOverride;
import org.killbill.billing.catalog.api.UsagePriceOverride;
import org.killbill.billing.catalog.api.UsageType;
import org.killbill.billing.entitlement.api.BaseEntitlementWithAddOnsSpecifier;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;
import org.killbill.billing.jaxrs.json.BlockPriceJson;
import org.killbill.billing.jaxrs.json.PhasePriceJson;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.killbill.billing.jaxrs.json.TierPriceJson;
import org.killbill.billing.jaxrs.json.UsagePriceJson;

public class SubscriptionResourceHelpers {
    public static EntitlementSpecifier buildEntitlementSpecifier(final SubscriptionJson subscriptionJson, Currency currency, final String externalKey) {
        final PlanPhaseSpecifier planPhaseSpecifier = subscriptionJson.getPlanName() != null ? new PlanPhaseSpecifier(subscriptionJson.getPlanName(), subscriptionJson.getPhaseType()) : new PlanPhaseSpecifier(subscriptionJson.getProductName(), subscriptionJson.getBillingPeriod(), subscriptionJson.getPriceList(), subscriptionJson.getPhaseType());
        final List<PlanPhasePriceOverride> overrides = SubscriptionResourceHelpers.buildPlanPhasePriceOverrides(subscriptionJson.getPriceOverrides(), currency, planPhaseSpecifier);
        return new EntitlementSpecifier(){

            public PlanPhaseSpecifier getPlanPhaseSpecifier() {
                return planPhaseSpecifier;
            }

            public Integer getBillCycleDay() {
                return subscriptionJson.getBillCycleDayLocal();
            }

            public String getExternalKey() {
                return externalKey;
            }

            public List<PlanPhasePriceOverride> getOverrides() {
                return overrides;
            }
        };
    }

    public static List<PlanPhasePriceOverride> buildPlanPhasePriceOverrides(Iterable<PhasePriceJson> priceOverrides, Currency currency, PlanPhaseSpecifier planPhaseSpecifier) {
        LinkedList<PlanPhasePriceOverride> overrides = new LinkedList<PlanPhasePriceOverride>();
        if (priceOverrides != null) {
            for (PhasePriceJson input : priceOverrides) {
                Preconditions.checkNotNull((Object)input);
                LinkedList<UsagePriceOverride> usagePrices = new LinkedList<UsagePriceOverride>();
                if (input.getUsagePrices() != null) {
                    SubscriptionResourceHelpers.buildUsagePrices(currency, input, usagePrices);
                }
                overrides.add(SubscriptionResourceHelpers.buildPlanPhasePriceOverride((PlanSpecifier)planPhaseSpecifier, currency, input, usagePrices));
            }
        }
        return overrides;
    }

    private static void buildUsagePrices(final Currency currency, PhasePriceJson input, Collection<UsagePriceOverride> usagePrices) {
        for (final UsagePriceJson usageOverrideJson : input.getUsagePrices()) {
            final LinkedList<3> tierPriceOverrides = new LinkedList<3>();
            for (TierPriceJson tierPriceJson : usageOverrideJson.getTierPrices()) {
                final LinkedList<2> blockPriceOverrides = new LinkedList<2>();
                for (final BlockPriceJson block : tierPriceJson.getBlockPrices()) {
                    blockPriceOverrides.add(new TieredBlockPriceOverride(){

                        public String getUnitName() {
                            return block.getUnitName();
                        }

                        public Double getSize() {
                            return block.getSize();
                        }

                        public BigDecimal getPrice() {
                            return block.getPrice();
                        }

                        public Currency getCurrency() {
                            return currency;
                        }

                        public Double getMax() {
                            return block.getMax();
                        }
                    });
                }
                tierPriceOverrides.add(new TierPriceOverride(){

                    public List<TieredBlockPriceOverride> getTieredBlockPriceOverrides() {
                        return blockPriceOverrides;
                    }
                });
            }
            usagePrices.add(new UsagePriceOverride(){

                public String getName() {
                    return usageOverrideJson.getUsageName();
                }

                public UsageType getUsageType() {
                    return usageOverrideJson.getUsageType();
                }

                public List<TierPriceOverride> getTierPriceOverrides() {
                    return tierPriceOverrides;
                }
            });
        }
    }

    private static PlanPhasePriceOverride buildPlanPhasePriceOverride(PlanSpecifier spec, final Currency currency, final PhasePriceJson input, final List<UsagePriceOverride> usagePrices) {
        if (input.getPhaseName() != null) {
            return new PlanPhasePriceOverride(){

                public String getPhaseName() {
                    return input.getPhaseName();
                }

                public PlanPhaseSpecifier getPlanPhaseSpecifier() {
                    return null;
                }

                public Currency getCurrency() {
                    return currency;
                }

                public BigDecimal getFixedPrice() {
                    return input.getFixedPrice();
                }

                public BigDecimal getRecurringPrice() {
                    return input.getRecurringPrice();
                }

                public List<UsagePriceOverride> getUsagePriceOverrides() {
                    return usagePrices;
                }
            };
        }
        PhaseType phaseType = input.getPhaseType() != null ? PhaseType.valueOf((String)input.getPhaseType()) : null;
        final PlanPhaseSpecifier planPhaseSpecifier = spec.getPlanName() != null ? new PlanPhaseSpecifier(spec.getPlanName(), phaseType) : new PlanPhaseSpecifier(spec.getProductName(), spec.getBillingPeriod(), spec.getPriceListName(), phaseType);
        final Currency resolvedCurrency = input.getFixedPrice() != null || input.getRecurringPrice() != null ? currency : null;
        return new PlanPhasePriceOverride(){

            public String getPhaseName() {
                return null;
            }

            public PlanPhaseSpecifier getPlanPhaseSpecifier() {
                return planPhaseSpecifier;
            }

            public Currency getCurrency() {
                return resolvedCurrency;
            }

            public BigDecimal getFixedPrice() {
                return input.getFixedPrice();
            }

            public BigDecimal getRecurringPrice() {
                return input.getRecurringPrice();
            }

            public List<UsagePriceOverride> getUsagePriceOverrides() {
                return usagePrices;
            }
        };
    }

    public static BaseEntitlementWithAddOnsSpecifier buildBaseEntitlementWithAddOnsSpecifier(final Iterable<EntitlementSpecifier> entitlementSpecifierList, final LocalDate resolvedEntitlementDate, final LocalDate resolvedBillingDate, final @Nullable UUID bundleId, final @Nullable String bundleExternalKey, final Boolean isMigrated) {
        return new BaseEntitlementWithAddOnsSpecifier(){

            public UUID getBundleId() {
                return bundleId;
            }

            public String getBundleExternalKey() {
                return bundleExternalKey;
            }

            public Iterable<EntitlementSpecifier> getEntitlementSpecifier() {
                return entitlementSpecifierList;
            }

            public LocalDate getEntitlementEffectiveDate() {
                return resolvedEntitlementDate;
            }

            public LocalDate getBillingEffectiveDate() {
                return resolvedBillingDate;
            }

            public boolean isMigrated() {
                return isMigrated;
            }
        };
    }
}

