/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.TimeAwareContext;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.entitlement.api.BaseEntitlementWithAddOnsSpecifier;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.EntitlementApi;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.events.BlockingTransitionInternalEvent;
import org.killbill.billing.events.EffectiveSubscriptionInternalEvent;
import org.killbill.billing.events.InvoiceCreationInternalEvent;
import org.killbill.billing.events.InvoicePaymentErrorInternalEvent;
import org.killbill.billing.events.InvoicePaymentInfoInternalEvent;
import org.killbill.billing.events.NullInvoiceInternalEvent;
import org.killbill.billing.events.PaymentErrorInternalEvent;
import org.killbill.billing.events.PaymentInfoInternalEvent;
import org.killbill.billing.events.PaymentPluginErrorInternalEvent;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.BlockingStateJson;
import org.killbill.billing.jaxrs.json.BulkSubscriptionsBundleJson;
import org.killbill.billing.jaxrs.json.BundleJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AccountResource;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.BundleResource;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.resources.SubscriptionResourceHelpers;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.jaxrs.util.KillbillEventHandler;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.userrequest.CompletionUserRequest;
import org.killbill.billing.util.userrequest.CompletionUserRequestBase;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/1.0/kb/subscriptions")
@Api(value="/1.0/kb/subscriptions", description="Operations on subscriptions", tags={"Subscription"})
public class SubscriptionResource
extends JaxRsResourceBase {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionResource.class);
    private static final String ID_PARAM_NAME = "subscriptionId";
    private final KillbillEventHandler killbillHandler;
    private final EntitlementApi entitlementApi;
    private final SubscriptionApi subscriptionApi;

    @Inject
    public SubscriptionResource(KillbillEventHandler killbillHandler, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, EntitlementApi entitlementApi, SubscriptionApi subscriptionApi, AccountUserApi accountUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, Clock clock, Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, subscriptionApi, clock, context);
        this.killbillHandler = killbillHandler;
        this.entitlementApi = entitlementApi;
        this.subscriptionApi = subscriptionApi;
    }

    @TimedResource
    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a subscription by id", response=SubscriptionJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid subscription id supplied"), @ApiResponse(code=404, message="Subscription not found")})
    public Response getSubscription(@PathParam(value="subscriptionId") UUID subscriptionId, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws SubscriptionApiException, AccountApiException, CatalogApiException {
        TenantContext context = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Subscription subscription = this.subscriptionApi.getSubscriptionForEntitlementId(subscriptionId, context);
        Account account = this.accountUserApi.getAccountById(subscription.getAccountId(), context);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(subscription.getAccountId(), auditMode.getLevel(), context);
        SubscriptionJson json = new SubscriptionJson(subscription, account.getCurrency(), accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a subscription by external key", response=SubscriptionJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Subscription not found")})
    public Response getSubscriptionByKey(@ApiParam(required=true) @QueryParam(value="externalKey") String externalKey, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws SubscriptionApiException, AccountApiException, CatalogApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Subscription subscription = this.subscriptionApi.getSubscriptionForExternalKey(externalKey, tenantContext);
        Account account = this.accountUserApi.getAccountById(subscription.getAccountId(), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(subscription.getAccountId(), auditMode.getLevel(), tenantContext);
        SubscriptionJson json = new SubscriptionJson(subscription, account.getCurrency(), accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve subscription audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Subscription not found")})
    public Response getSubscriptionAuditLogsWithHistory(@PathParam(value="subscriptionId") UUID subscriptionId, @javax.ws.rs.core.Context HttpServletRequest request) {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.subscriptionApi.getSubscriptionAuditLogsWithHistoryForId(subscriptionId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @TimedResource
    @GET
    @Path(value="/events/{eventId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve subscription event audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Subscription event not found")})
    public Response getSubscriptionEventAuditLogsWithHistory(@PathParam(value="eventId") UUID eventId, @javax.ws.rs.core.Context HttpServletRequest request) {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.subscriptionApi.getSubscriptionEventAuditLogsWithHistoryForId(eventId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create an subscription", response=SubscriptionJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Subscription created successfully")})
    public Response createSubscription(SubscriptionJson subscription, @QueryParam(value="entitlementDate") String entitlementDate, @QueryParam(value="billingDate") String billingDate, @QueryParam(value="renameKeyIfExistsAndUnused") @DefaultValue(value="true") Boolean renameKeyIfExistsAndUnused, @QueryParam(value="migrated") @DefaultValue(value="false") Boolean isMigrated, @QueryParam(value="callCompletion") @DefaultValue(value="false") Boolean callCompletion, @QueryParam(value="callTimeoutSec") @DefaultValue(value="3") long timeoutSec, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws EntitlementApiException, AccountApiException, SubscriptionApiException {
        ImmutableList entitlementsWithAddOns = ImmutableList.of((Object)new BulkSubscriptionsBundleJson((List<SubscriptionJson>)ImmutableList.of((Object)subscription)));
        return this.createSubscriptionsWithAddOnsInternal((List<BulkSubscriptionsBundleJson>)entitlementsWithAddOns, entitlementDate, billingDate, isMigrated, renameKeyIfExistsAndUnused, callCompletion, timeoutSec, pluginPropertiesString, createdBy, reason, comment, request, uriInfo, ObjectType.SUBSCRIPTION);
    }

    @TimedResource
    @POST
    @Path(value="/createSubscriptionWithAddOns")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create an entitlement with addOn products", response=BundleJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Subscriptions created successfully")})
    public Response createSubscriptionWithAddOns(List<SubscriptionJson> entitlements, @QueryParam(value="entitlementDate") String entitlementDate, @QueryParam(value="billingDate") String billingDate, @QueryParam(value="migrated") @DefaultValue(value="false") Boolean isMigrated, @QueryParam(value="renameKeyIfExistsAndUnused") @DefaultValue(value="true") Boolean renameKeyIfExistsAndUnused, @QueryParam(value="callCompletion") @DefaultValue(value="false") Boolean callCompletion, @QueryParam(value="callTimeoutSec") @DefaultValue(value="3") long timeoutSec, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws EntitlementApiException, AccountApiException, SubscriptionApiException {
        ImmutableList entitlementsWithAddOns = ImmutableList.of((Object)new BulkSubscriptionsBundleJson(entitlements));
        return this.createSubscriptionsWithAddOnsInternal((List<BulkSubscriptionsBundleJson>)entitlementsWithAddOns, entitlementDate, billingDate, isMigrated, renameKeyIfExistsAndUnused, callCompletion, timeoutSec, pluginPropertiesString, createdBy, reason, comment, request, uriInfo, ObjectType.BUNDLE);
    }

    @TimedResource
    @POST
    @Path(value="/createSubscriptionsWithAddOns")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create multiple entitlements with addOn products", response=BundleJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Subscriptions created successfully")})
    public Response createSubscriptionsWithAddOns(List<BulkSubscriptionsBundleJson> entitlementsWithAddOns, @QueryParam(value="entitlementDate") String entitlementDate, @QueryParam(value="billingDate") String billingDate, @QueryParam(value="renameKeyIfExistsAndUnused") @DefaultValue(value="true") Boolean renameKeyIfExistsAndUnused, @QueryParam(value="migrated") @DefaultValue(value="false") Boolean isMigrated, @QueryParam(value="callCompletion") @DefaultValue(value="false") Boolean callCompletion, @QueryParam(value="callTimeoutSec") @DefaultValue(value="3") long timeoutSec, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws EntitlementApiException, AccountApiException, SubscriptionApiException {
        return this.createSubscriptionsWithAddOnsInternal(entitlementsWithAddOns, entitlementDate, billingDate, isMigrated, renameKeyIfExistsAndUnused, callCompletion, timeoutSec, pluginPropertiesString, createdBy, reason, comment, request, uriInfo, ObjectType.ACCOUNT);
    }

    public Response createSubscriptionsWithAddOnsInternal(List<BulkSubscriptionsBundleJson> entitlementsWithAddOns, String entitlementDate, String billingDate, Boolean isMigrated, final Boolean renameKeyIfExistsAndUnused, Boolean callCompletion, long timeoutSec, List<String> pluginPropertiesString, String createdBy, String reason, String comment, final HttpServletRequest request, final UriInfo uriInfo, final ObjectType responseObject) throws EntitlementApiException, AccountApiException, SubscriptionApiException {
        Preconditions.checkArgument((Iterables.size(entitlementsWithAddOns) > 0 ? 1 : 0) != 0, (Object)"No subscription specified to create");
        final Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContextNoAccountId = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Preconditions.checkArgument((Iterables.size(entitlementsWithAddOns.get(0).getBaseEntitlementAndAddOns()) > 0 ? 1 : 0) != 0, (Object)"SubscriptionJson body should be specified");
        final Account account = this.accountUserApi.getAccountById(entitlementsWithAddOns.get(0).getBaseEntitlementAndAddOns().get(0).getAccountId(), (TenantContext)callContextNoAccountId);
        final CallContext callContext = this.context.createCallContextWithAccountId(account.getId(), createdBy, reason, comment, (ServletRequest)request);
        final ArrayList<BaseEntitlementWithAddOnsSpecifier> baseEntitlementWithAddOnsSpecifierList = new ArrayList<BaseEntitlementWithAddOnsSpecifier>();
        for (BulkSubscriptionsBundleJson subscriptionsBundleJson : entitlementsWithAddOns) {
            UUID bundleId = null;
            String bundleExternalKey = null;
            ArrayList<EntitlementSpecifier> entitlementSpecifierList = new ArrayList<EntitlementSpecifier>();
            for (SubscriptionJson entitlement : subscriptionsBundleJson.getBaseEntitlementAndAddOns()) {
                this.verifyNonNullOrEmpty(entitlement, "SubscriptionJson body should be specified for each element");
                if (entitlement.getPlanName() == null) {
                    this.verifyNonNullOrEmpty(entitlement.getProductName(), "SubscriptionJson productName needs to be set when no planName is specified", entitlement.getProductCategory(), "SubscriptionJson productCategory needs to be set when no planName is specified", entitlement.getBillingPeriod(), "SubscriptionJson billingPeriod needs to be set when no planName is specified", entitlement.getPriceList(), "SubscriptionJson priceList needs to be set when no planName is specified");
                } else {
                    Preconditions.checkArgument((entitlement.getProductName() == null ? 1 : 0) != 0, (Object)"SubscriptionJson productName should not be set when planName is specified");
                    Preconditions.checkArgument((entitlement.getProductCategory() == null ? 1 : 0) != 0, (Object)"SubscriptionJson productCategory should not be set when planName is specified");
                    Preconditions.checkArgument((entitlement.getBillingPeriod() == null ? 1 : 0) != 0, (Object)"SubscriptionJson billingPeriod should not be set when planName is specified");
                    Preconditions.checkArgument((entitlement.getPriceList() == null ? 1 : 0) != 0, (Object)"SubscriptionJson priceList should not be set when planName is specified");
                }
                Preconditions.checkArgument((boolean)account.getId().equals(entitlement.getAccountId()), (Object)"SubscriptionJson accountId should be the same for each element");
                Preconditions.checkArgument((bundleId == null || bundleId.equals(entitlement.getBundleId()) ? 1 : 0) != 0, (Object)"SubscriptionJson bundleId should be the same for each element");
                if (bundleId == null) {
                    bundleId = entitlement.getBundleId();
                }
                Preconditions.checkArgument((bundleExternalKey == null || entitlement.getBundleExternalKey() == null || bundleExternalKey.equals(entitlement.getBundleExternalKey()) ? 1 : 0) != 0, (Object)"SubscriptionJson externalKey should be the same for each element");
                if (bundleExternalKey == null) {
                    bundleExternalKey = entitlement.getBundleExternalKey();
                }
                EntitlementSpecifier spec = SubscriptionResourceHelpers.buildEntitlementSpecifier(entitlement, account.getCurrency(), entitlement.getExternalKey());
                entitlementSpecifierList.add(spec);
            }
            LocalDate resolvedEntitlementDate = this.toLocalDate(entitlementDate);
            LocalDate resolvedBillingDate = this.toLocalDate(billingDate);
            BaseEntitlementWithAddOnsSpecifier baseEntitlementSpecifierWithAddOns = SubscriptionResourceHelpers.buildBaseEntitlementWithAddOnsSpecifier(entitlementSpecifierList, resolvedEntitlementDate, resolvedBillingDate, bundleId, bundleExternalKey, isMigrated);
            baseEntitlementWithAddOnsSpecifierList.add(baseEntitlementSpecifierWithAddOns);
        }
        EntitlementCallCompletionCallback<List<UUID>> callback = new EntitlementCallCompletionCallback<List<UUID>>(){
            private boolean isImmediateOp = true;

            @Override
            public List<UUID> doOperation(CallContext ctx) throws EntitlementApiException {
                for (BaseEntitlementWithAddOnsSpecifier spec : baseEntitlementWithAddOnsSpecifierList) {
                    boolean inTheFuture;
                    if (spec.getBillingEffectiveDate() == null || !(inTheFuture = SubscriptionResource.this.isInTheFuture(spec.getBillingEffectiveDate(), (ImmutableAccountData)account))) continue;
                    this.isImmediateOp = false;
                    break;
                }
                return SubscriptionResource.this.entitlementApi.createBaseEntitlementsWithAddOns(account.getId(), (Iterable)baseEntitlementWithAddOnsSpecifierList, renameKeyIfExistsAndUnused.booleanValue(), pluginProperties, callContext);
            }

            @Override
            public boolean isImmOperation() {
                return this.isImmediateOp;
            }

            @Override
            public Response doResponseOk(List<UUID> entitlementIds) {
                if (responseObject == ObjectType.SUBSCRIPTION) {
                    return SubscriptionResource.this.uriBuilder.buildResponse(uriInfo, SubscriptionResource.class, "getSubscription", Iterables.getFirst(entitlementIds, null), (ServletRequest)request);
                }
                LinkedHashSet<String> bundleIds = new LinkedHashSet<String>();
                try {
                    for (Entitlement entitlement : SubscriptionResource.this.entitlementApi.getAllEntitlementsForAccountId(account.getId(), (TenantContext)callContext)) {
                        if (!entitlementIds.contains(entitlement.getId())) continue;
                        bundleIds.add(entitlement.getBundleId().toString());
                    }
                }
                catch (EntitlementApiException e) {
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
                if (responseObject == ObjectType.ACCOUNT) {
                    return SubscriptionResource.this.uriBuilder.buildResponse(uriInfo, AccountResource.class, "getAccountBundles", account.getId(), SubscriptionResource.this.buildQueryParams(bundleIds), (ServletRequest)request);
                }
                if (responseObject == ObjectType.BUNDLE) {
                    return SubscriptionResource.this.uriBuilder.buildResponse(uriInfo, BundleResource.class, "getBundle", Iterables.getFirst(bundleIds, null), (ServletRequest)request);
                }
                throw new IllegalStateException("Unexpected input responseObject " + responseObject);
            }
        };
        EntitlementCallCompletion<List<UUID>> callCompletionCreation = new EntitlementCallCompletion<List<UUID>>();
        return callCompletionCreation.withSynchronization(callback, timeoutSec, callCompletion, callContext);
    }

    private Map<String, String> buildQueryParams(Iterable<String> bundleIdList) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        String value = "";
        for (String bundleId : bundleIdList) {
            if (value.equals("")) {
                value = value + bundleId;
                continue;
            }
            value = value + "," + bundleId;
        }
        queryParams.put("bundlesFilter", value);
        return queryParams;
    }

    @TimedResource
    @PUT
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/uncancel")
    @Produces(value={"application/json"})
    @ApiOperation(value="Un-cancel an entitlement")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid subscription id supplied"), @ApiResponse(code=404, message="Entitlement not found")})
    public Response uncancelSubscriptionPlan(@PathParam(value="subscriptionId") UUID subscriptionId, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws EntitlementApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        Entitlement current = this.entitlementApi.getEntitlementForId(subscriptionId, (TenantContext)this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
        current.uncancelEntitlement(pluginProperties, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @PUT
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/undoChangePlan")
    @Produces(value={"application/json"})
    @ApiOperation(value="Undo a pending change plan on an entitlement")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid subscription id supplied"), @ApiResponse(code=404, message="Entitlement not found")})
    public Response undoChangeSubscriptionPlan(@PathParam(value="subscriptionId") UUID subscriptionId, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws EntitlementApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        Entitlement current = this.entitlementApi.getEntitlementForId(subscriptionId, (TenantContext)this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
        current.undoChangePlan(pluginProperties, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @ApiOperation(value="Change entitlement plan")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid subscription id supplied"), @ApiResponse(code=404, message="Entitlement not found")})
    public Response changeSubscriptionPlan(@PathParam(value="subscriptionId") UUID subscriptionId, final SubscriptionJson entitlement, final @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="callCompletion") @DefaultValue(value="false") Boolean callCompletion, @QueryParam(value="callTimeoutSec") @DefaultValue(value="3") long timeoutSec, final @QueryParam(value="billingPolicy") BillingActionPolicy billingPolicy, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws EntitlementApiException, AccountApiException, SubscriptionApiException {
        this.verifyNonNullOrEmpty(entitlement, "SubscriptionJson body should be specified");
        if (entitlement.getPlanName() == null) {
            this.verifyNonNullOrEmpty(entitlement.getProductName(), "SubscriptionJson productName needs to be set", entitlement.getBillingPeriod(), "SubscriptionJson billingPeriod needs to be set", entitlement.getPriceList(), "SubscriptionJson priceList needs to be set");
        }
        Preconditions.checkArgument((requestedDate == null || billingPolicy == null ? 1 : 0) != 0, (Object)"Only one of requestedDate or billingPolicy should be specified");
        final Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContextNoAccountId = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        final Entitlement current = this.entitlementApi.getEntitlementForId(subscriptionId, (TenantContext)callContextNoAccountId);
        final CallContext callContext = this.context.createCallContextWithAccountId(current.getAccountId(), createdBy, reason, comment, (ServletRequest)request);
        EntitlementCallCompletionCallback<Response> callback = new EntitlementCallCompletionCallback<Response>(){
            private boolean isImmediateOp = true;

            @Override
            public Response doOperation(CallContext ctx) throws EntitlementApiException, AccountApiException {
                LocalDate inputLocalDate = SubscriptionResource.this.toLocalDate(requestedDate);
                Account account = SubscriptionResource.this.accountUserApi.getAccountById(current.getAccountId(), (TenantContext)callContext);
                EntitlementSpecifier spec = SubscriptionResourceHelpers.buildEntitlementSpecifier(entitlement, account.getCurrency(), entitlement.getExternalKey());
                Entitlement newEntitlement = requestedDate == null && billingPolicy == null ? current.changePlan(spec, pluginProperties, ctx) : (billingPolicy == null ? current.changePlanWithDate(spec, inputLocalDate, pluginProperties, ctx) : current.changePlanOverrideBillingPolicy(spec, null, billingPolicy, pluginProperties, ctx));
                this.isImmediateOp = newEntitlement.getLastActiveProduct().getName().equals(entitlement.getProductName()) && newEntitlement.getLastActivePlan().getRecurringBillingPeriod() == entitlement.getBillingPeriod() && newEntitlement.getLastActivePriceList().getName().equals(entitlement.getPriceList());
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }

            @Override
            public boolean isImmOperation() {
                return this.isImmediateOp;
            }

            @Override
            public Response doResponseOk(Response operationResponse) throws SubscriptionApiException, AccountApiException, CatalogApiException {
                if (operationResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                    return operationResponse;
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        };
        EntitlementCallCompletion<Response> callCompletionCreation = new EntitlementCallCompletion<Response>();
        return callCompletionCreation.withSynchronization(callback, timeoutSec, callCompletion, callContext);
    }

    @TimedResource
    @POST
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/block")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Block a subscription", response=BlockingStateJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Blocking state created successfully"), @ApiResponse(code=400, message="Invalid subscription id supplied"), @ApiResponse(code=404, message="Subscription not found")})
    public Response addSubscriptionBlockingState(@PathParam(value="subscriptionId") UUID id, BlockingStateJson json, @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws SubscriptionApiException, EntitlementApiException, AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Entitlement entitlement = this.entitlementApi.getEntitlementForId(id, tenantContext);
        return this.addBlockingState(json, entitlement.getAccountId(), id, BlockingStateType.SUBSCRIPTION, requestedDate, pluginPropertiesString, createdBy, reason, comment, request, uriInfo);
    }

    @TimedResource
    @DELETE
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Cancel an entitlement plan")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid subscription id supplied"), @ApiResponse(code=404, message="Entitlement not found")})
    public Response cancelSubscriptionPlan(@PathParam(value="subscriptionId") UUID subscriptionId, final @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="callCompletion") @DefaultValue(value="false") Boolean callCompletion, @QueryParam(value="callTimeoutSec") @DefaultValue(value="5") long timeoutSec, final @QueryParam(value="entitlementPolicy") Entitlement.EntitlementActionPolicy entitlementPolicy, final @QueryParam(value="billingPolicy") BillingActionPolicy billingPolicy, final @QueryParam(value="useRequestedDateForBilling") @DefaultValue(value="false") Boolean useRequestedDateForBilling, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws EntitlementApiException, AccountApiException, SubscriptionApiException {
        CallContext callContextNoAccountId = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        final Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        final Entitlement current = this.entitlementApi.getEntitlementForId(subscriptionId, (TenantContext)callContextNoAccountId);
        final CallContext callContext = this.context.createCallContextWithAccountId(current.getAccountId(), createdBy, reason, comment, (ServletRequest)request);
        EntitlementCallCompletionCallback<Response> callback = new EntitlementCallCompletionCallback<Response>(){
            private boolean isImmediateOp = true;

            @Override
            public Response doOperation(CallContext ctx) throws EntitlementApiException, SubscriptionApiException, AccountApiException {
                LocalDate inputLocalDate = SubscriptionResource.this.toLocalDate(requestedDate);
                Entitlement newEntitlement = billingPolicy == null && entitlementPolicy == null ? current.cancelEntitlementWithDate(inputLocalDate, useRequestedDateForBilling.booleanValue(), pluginProperties, ctx) : (billingPolicy == null && entitlementPolicy != null ? current.cancelEntitlementWithPolicy(entitlementPolicy, pluginProperties, ctx) : (billingPolicy != null && entitlementPolicy == null ? current.cancelEntitlementWithDateOverrideBillingPolicy(inputLocalDate, billingPolicy, pluginProperties, ctx) : current.cancelEntitlementWithPolicyOverrideBillingPolicy(entitlementPolicy, billingPolicy, pluginProperties, ctx)));
                Subscription subscription = SubscriptionResource.this.subscriptionApi.getSubscriptionForEntitlementId(newEntitlement.getId(), (TenantContext)ctx);
                if (subscription.getBillingEndDate() != null) {
                    Account account = SubscriptionResource.this.accountUserApi.getAccountById(subscription.getAccountId(), (TenantContext)callContext);
                    boolean inTheFuture = SubscriptionResource.this.isInTheFuture(subscription.getBillingEndDate(), (ImmutableAccountData)account);
                    if (inTheFuture) {
                        this.isImmediateOp = false;
                    }
                } else {
                    this.isImmediateOp = false;
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }

            @Override
            public boolean isImmOperation() {
                return this.isImmediateOp;
            }

            @Override
            public Response doResponseOk(Response operationResponse) {
                return operationResponse;
            }
        };
        EntitlementCallCompletion<Response> callCompletionCreation = new EntitlementCallCompletion<Response>();
        return callCompletionCreation.withSynchronization(callback, timeoutSec, callCompletion, callContext);
    }

    @TimedResource
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/bcd")
    @ApiOperation(value="Update the BCD associated to a subscription")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid entitlement supplied")})
    public Response updateSubscriptionBCD(@PathParam(value="subscriptionId") UUID subscriptionId, SubscriptionJson json, @QueryParam(value="effectiveFromDate") String effectiveFromDateStr, @QueryParam(value="forceNewBcdWithPastEffectiveDate") @DefaultValue(value="false") Boolean forceNewBcdWithPastEffectiveDate, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws EntitlementApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "SubscriptionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getBillCycleDayLocal(), "SubscriptionJson new BCD should be specified");
        LocalDate effectiveFromDate = this.toLocalDate(effectiveFromDateStr);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Entitlement entitlement = this.entitlementApi.getEntitlementForId(subscriptionId, (TenantContext)callContext);
        if (effectiveFromDateStr != null) {
            Account account = this.accountUserApi.getAccountById(entitlement.getAccountId(), (TenantContext)callContext);
            LocalDate accountToday = new LocalDate((Object)callContext.getCreatedDate(), account.getTimeZone());
            int comp = effectiveFromDate.compareTo((ReadablePartial)accountToday);
            switch (comp) {
                case -1: {
                    if (forceNewBcdWithPastEffectiveDate.booleanValue()) break;
                    throw new IllegalArgumentException("Changing a subscription BCD in the past may have consequences on previous invoice generated. Use flag forceNewBcdWithPastEffectiveDate to force this behavior");
                }
                case 0: {
                    effectiveFromDate = null;
                    break;
                }
            }
        }
        entitlement.updateBCD(json.getBillCycleDayLocal().intValue(), effectiveFromDate, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve subscription custom fields", response=CustomFieldJson.class, responseContainer="List", nickname="getSubscriptionCustomFields")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid subscription id supplied")})
    public Response getCustomFields(@PathParam(value="subscriptionId") UUID id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) {
        return super.getCustomFields(id, auditMode, this.context.createTenantContextNoAccountId((ServletRequest)request));
    }

    @POST
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to subscription")
    @ApiResponses(value={@ApiResponse(code=201, message="Custom field created successfully"), @ApiResponse(code=400, message="Invalid subscription id supplied")})
    public Response createSubscriptionCustomFields(@PathParam(value="subscriptionId") UUID id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(id, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), uriInfo, request);
    }

    @PUT
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Modify custom fields to subscription")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid subscription id supplied")})
    public Response modifySubscriptionCustomFields(@PathParam(value="subscriptionId") UUID id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws CustomFieldApiException {
        return super.modifyCustomFields(id, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @DELETE
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from subscription")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid subscription id supplied")})
    public Response deleteSubscriptionCustomFields(@PathParam(value="subscriptionId") UUID id, @QueryParam(value="customField") List<UUID> customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(id, customFieldList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve subscription tags", response=TagJson.class, responseContainer="List", nickname="getSubscriptionTags")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid subscription id supplied"), @ApiResponse(code=404, message="Subscription not found")})
    public Response getTags(@PathParam(value="subscriptionId") UUID subscriptionId, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws TagDefinitionApiException, SubscriptionApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Subscription subscription = this.subscriptionApi.getSubscriptionForEntitlementId(subscriptionId, tenantContext);
        return super.getTags(subscription.getAccountId(), subscriptionId, auditMode, includedDeleted, tenantContext);
    }

    @POST
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=201, message="Tag created successfully"), @ApiResponse(code=400, message="Invalid subscription id supplied")})
    public Response createSubscriptionTags(@PathParam(value="subscriptionId") UUID id, List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws TagApiException {
        return super.createTags(id, tagList, uriInfo, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), request);
    }

    @DELETE
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove tags from subscription")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid subscription id supplied")})
    public Response deleteSubscriptionTags(@PathParam(value="subscriptionId") UUID id, @QueryParam(value="tagDef") List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(id, tagList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.SUBSCRIPTION;
    }

    private boolean isInTheFuture(LocalDate effectiveDate, ImmutableAccountData account) {
        TimeAwareContext timeAwareContext = new TimeAwareContext(account.getFixedOffsetTimeZone(), account.getReferenceTime());
        return timeAwareContext.toUTCDateTime(effectiveDate).isAfter((ReadableInstant)this.clock.getUTCNow());
    }

    private Account getAccountFromSubscriptionJson(SubscriptionJson entitlementJson, CallContext callContext) throws SubscriptionApiException, AccountApiException, EntitlementApiException {
        UUID accountId;
        if (entitlementJson.getAccountId() != null) {
            accountId = entitlementJson.getAccountId();
        } else if (entitlementJson.getSubscriptionId() != null) {
            Entitlement entitlement = this.entitlementApi.getEntitlementForId(entitlementJson.getSubscriptionId(), (TenantContext)callContext);
            accountId = entitlement.getAccountId();
        } else {
            SubscriptionBundle subscriptionBundle = this.subscriptionApi.getSubscriptionBundle(entitlementJson.getBundleId(), (TenantContext)callContext);
            accountId = subscriptionBundle.getAccountId();
        }
        return this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
    }

    private class EntitlementCallCompletion<T> {
        private EntitlementCallCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Response withSynchronization(EntitlementCallCompletionCallback<T> callback, long timeoutSec, boolean callCompletion, CallContext callContext) throws SubscriptionApiException, AccountApiException, EntitlementApiException {
            CompletionUserRequestEntitlement waiter;
            if (callCompletion) {
                List accountTags = SubscriptionResource.this.tagUserApi.getTagsForAccountType(callContext.getAccountId(), ObjectType.ACCOUNT, false, (TenantContext)callContext);
                waiter = new CompletionUserRequestEntitlement(callContext.getUserToken(), accountTags);
            } else {
                waiter = null;
            }
            try {
                if (waiter != null) {
                    SubscriptionResource.this.killbillHandler.registerCompletionUserRequestWaiter((CompletionUserRequest)waiter);
                }
                T operationValue = callback.doOperation(callContext);
                if (waiter != null && callback.isImmOperation()) {
                    waiter.waitForCompletion(timeoutSec * 1000L);
                }
                Response response = callback.doResponseOk(operationValue);
                if (waiter == null) return response;
                SubscriptionResource.this.killbillHandler.unregisterCompletionUserRequestWaiter((CompletionUserRequest)waiter);
                return response;
            }
            catch (InterruptedException e) {
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                if (waiter == null) return response;
                SubscriptionResource.this.killbillHandler.unregisterCompletionUserRequestWaiter((CompletionUserRequest)waiter);
                return response;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (CatalogApiException e2) {
                    throw new EntitlementApiException((BillingExceptionBase)e2);
                    catch (TimeoutException e3) {
                        Response response2 = Response.status((int)408).build();
                        return response2;
                    }
                }
            }
            finally {
                if (waiter != null) {
                    SubscriptionResource.this.killbillHandler.unregisterCompletionUserRequestWaiter((CompletionUserRequest)waiter);
                }
            }
        }
    }

    private static interface EntitlementCallCompletionCallback<T> {
        public T doOperation(CallContext var1) throws EntitlementApiException, InterruptedException, TimeoutException, AccountApiException, SubscriptionApiException;

        public boolean isImmOperation();

        public Response doResponseOk(T var1) throws SubscriptionApiException, AccountApiException, CatalogApiException;
    }

    private static final class CompletionUserRequestEntitlement
    extends CompletionUserRequestBase {
        private final List<Tag> accountTags;

        public CompletionUserRequestEntitlement(UUID userToken, List<Tag> accountTags) {
            super(userToken);
            this.accountTags = accountTags;
        }

        public void onSubscriptionBaseTransition(EffectiveSubscriptionInternalEvent event) {
            log.info("Got event SubscriptionBaseTransition token='{}', type='{}', remaining='{}'", new Object[]{event.getUserToken(), event.getTransitionType(), event.getRemainingEventsForUserOperation()});
        }

        public void onBlockingState(BlockingTransitionInternalEvent event) {
            log.info(String.format("Got event BlockingTransitionInternalEvent token = %s", event.getUserToken()));
            boolean found_AUTO_INVOICING_OFF = ControlTagType.isAutoInvoicingOff((Collection)Collections2.transform(this.accountTags, (Function)new Function<Tag, UUID>(){

                public UUID apply(Tag tag) {
                    return tag.getTagDefinitionId();
                }
            }));
            if (found_AUTO_INVOICING_OFF) {
                this.notifyForCompletion();
                return;
            }
            for (Tag tag : this.accountTags) {
                if (!ControlTagType.AUTO_INVOICING_DRAFT.getId().equals(tag.getTagDefinitionId())) continue;
                this.notifyForCompletion();
                return;
            }
        }

        public void onEmptyInvoice(NullInvoiceInternalEvent event) {
            log.info("Got event EmptyInvoiceNotification token='{}'", (Object)event.getUserToken());
            this.notifyForCompletion();
        }

        public void onInvoiceCreation(InvoiceCreationInternalEvent event) {
            boolean found_AUTO_PAY_OFF;
            log.info("Got event InvoiceCreationNotification token='{}'", (Object)event.getUserToken());
            if (event.getAmountOwed().compareTo(BigDecimal.ZERO) <= 0) {
                this.notifyForCompletion();
            }
            if (found_AUTO_PAY_OFF = ControlTagType.isAutoPayOff((Collection)Collections2.transform(this.accountTags, (Function)new Function<Tag, UUID>(){

                public UUID apply(Tag tag) {
                    return tag.getTagDefinitionId();
                }
            }))) {
                this.notifyForCompletion();
            }
        }

        public void onPaymentInfo(PaymentInfoInternalEvent event) {
            log.info("Got event PaymentInfo token='{}'", (Object)event.getUserToken());
            this.notifyForCompletion();
        }

        public void onPaymentError(PaymentErrorInternalEvent event) {
            log.info("Got event PaymentError token='{}'", (Object)event.getUserToken());
            this.notifyForCompletion();
        }

        public void onPaymentPluginError(PaymentPluginErrorInternalEvent event) {
            log.info("Got event PaymentPluginError token='{}'", (Object)event.getUserToken());
            this.notifyForCompletion();
        }

        public void onInvoicePaymentInfo(InvoicePaymentInfoInternalEvent event) {
            log.info("Got event InvoicePaymentInfo token='{}'", (Object)event.getUserToken());
            this.notifyForCompletion();
        }

        public void onInvoicePaymentError(InvoicePaymentErrorInternalEvent event) {
            log.info("Got event InvoicePaymentError token='{}'", (Object)event.getUserToken());
            this.notifyForCompletion();
        }
    }
}

