/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.jaxrs.json.PluginInfoJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.osgi.api.PluginInfo;
import org.killbill.billing.osgi.api.PluginsInfoApi;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Path(value="/1.0/kb/pluginsInfo")
@Api(value="/1.0/kb/pluginsInfo", description="Operations on plugins", tags={"PluginInfo"})
public class PluginInfoResource
extends JaxRsResourceBase {
    private final PluginsInfoApi pluginsInfoApi;

    @Inject
    public PluginInfoResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, PluginsInfoApi pluginsInfoApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
        this.pluginsInfoApi = pluginsInfoApi;
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the list of registered plugins", response=PluginInfoJson.class, responseContainer="List")
    public Response getPluginsInfo(@Context HttpServletRequest request) throws SubscriptionApiException {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.pluginsInfoApi.getPluginsInfo(), (Function)new Function<PluginInfo, PluginInfoJson>(){

            public PluginInfoJson apply(PluginInfo input) {
                return new PluginInfoJson(input);
            }
        }))).build();
    }
}

