/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.ComboPaymentTransactionJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.PaymentJson;
import org.killbill.billing.jaxrs.json.PaymentTransactionJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.ComboPaymentResource;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentOptions;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.api.TransactionType;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.MetricTag;
import org.killbill.commons.metrics.TimedResource;

@Path(value="/1.0/kb/payments")
@Api(value="/1.0/kb/payments", description="Operations on payments", tags={"Payment"})
public class PaymentResource
extends ComboPaymentResource {
    private static final String ID_PARAM_NAME = "paymentId";

    @Inject
    public PaymentResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, clock, context);
    }

    @TimedResource(name="getPayment")
    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a payment by id", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Payment not found")})
    public Response getPayment(@PathParam(value="paymentId") UUID paymentId, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="withAttempts") @DefaultValue(value="false") Boolean withAttempts, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentId, withPluginInfo.booleanValue(), withAttempts.booleanValue(), pluginProperties, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext);
        PaymentJson result = new PaymentJson(payment, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource(name="getPayment")
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a payment by external key", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Payment not found")})
    public Response getPaymentByExternalKey(@QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="withAttempts") @DefaultValue(value="false") Boolean withAttempts, @ApiParam(required=true) @QueryParam(value="externalKey") String paymentExternalKey, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        this.verifyNonNullOrEmpty(paymentExternalKey, "Payment externalKey needs to be specified");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Payment payment = this.paymentApi.getPaymentByExternalKey(paymentExternalKey, withPluginInfo.booleanValue(), withAttempts.booleanValue(), pluginProperties, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext);
        PaymentJson result = new PaymentJson(payment, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get payments", response=PaymentJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getPayments(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="withAttempts") @DefaultValue(value="false") Boolean withAttempts, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination payments = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.getPayments(offset, limit, withPluginInfo.booleanValue(), withAttempts.booleanValue(), pluginProperties, tenantContext) : this.paymentApi.getPayments(offset, limit, pluginName, withPluginInfo.booleanValue(), withAttempts.booleanValue(), pluginProperties, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentResource.class, "getPayments", payments.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(payments, new Function<Payment, PaymentJson>(){

            public PaymentJson apply(Payment payment) {
                if (((Map)accountsAuditLogs.get()).get(payment.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(payment.getAccountId(), PaymentResource.this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                AccountAuditLogs accountAuditLogs = (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(payment.getAccountId());
                return new PaymentJson(payment, accountAuditLogs);
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search payments", response=PaymentJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchPayments(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="withAttempts") @DefaultValue(value="false") Boolean withAttempts, @QueryParam(value="pluginName") String pluginName, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination payments = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.searchPayments(searchKey, offset, limit, withPluginInfo.booleanValue(), withAttempts.booleanValue(), pluginProperties, tenantContext) : this.paymentApi.searchPayments(searchKey, offset, limit, pluginName, withPluginInfo.booleanValue(), withAttempts.booleanValue(), pluginProperties, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentResource.class, "searchPayments", payments.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(payments, new Function<Payment, PaymentJson>(){

            public PaymentJson apply(Payment payment) {
                if (((Map)accountsAuditLogs.get()).get(payment.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(payment.getAccountId(), PaymentResource.this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                AccountAuditLogs accountAuditLogs = (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(payment.getAccountId());
                return new PaymentJson(payment, accountAuditLogs);
            }
        }, nextPageUri);
    }

    @TimedResource(name="completeTransaction")
    @PUT
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Complete an existing transaction")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response completeTransaction(@PathParam(value="paymentId") UUID paymentId, @MetricTag(tag="type", property="transactionType") PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.completeTransactionInternalWithoutPayment(json, paymentId, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource(name="completeTransaction")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Complete an existing transaction")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response completeTransactionByExternalKey(@MetricTag(tag="type", property="transactionType") PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.completeTransactionInternalWithoutPayment(json, null, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource(name="captureAuthorization")
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Capture an existing authorization", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment transaction created successfully"), @ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response captureAuthorization(@PathParam(value="paymentId") UUID paymentId, PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.captureAuthorizationInternal(json, paymentId, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    @TimedResource(name="captureAuthorization")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Capture an existing authorization", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment transaction created successfully"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response captureAuthorizationByExternalKey(PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.captureAuthorizationInternal(json, null, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    private Response captureAuthorizationInternal(PaymentTransactionJson json, @Nullable UUID paymentId, List<String> paymentControlPluginNames, List<String> pluginPropertiesString, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "PaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAmount(), "PaymentTransactionJson amount needs to be set");
        Iterable<PluginProperty> pluginPropertiesFromBody = this.extractPluginProperties(json.getProperties());
        Iterable<PluginProperty> pluginPropertiesFromQuery = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        Iterable pluginProperties = Iterables.concat(pluginPropertiesFromQuery, pluginPropertiesFromBody);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Payment initialPayment = this.getPaymentByIdOrKey(paymentId, json.getPaymentExternalKey(), pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(initialPayment.getAccountId(), (TenantContext)callContext);
        Currency currency = json.getCurrency() == null ? account.getCurrency() : json.getCurrency();
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        Payment payment = this.paymentApi.createCaptureWithPaymentControl(account, initialPayment.getId(), json.getAmount(), currency, json.getEffectiveDate(), json.getTransactionExternalKey(), pluginProperties, paymentOptions, callContext);
        return this.createPaymentResponse(uriInfo, payment, TransactionType.CAPTURE, json.getTransactionExternalKey(), request);
    }

    @TimedResource(name="refundPayment")
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/refunds")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Refund an existing payment", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment transaction created successfully"), @ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response refundPayment(@PathParam(value="paymentId") UUID paymentId, PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.refundPaymentInternal(json, paymentId, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    @TimedResource(name="refundPayment")
    @POST
    @Path(value="/refunds")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Refund an existing payment", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment transaction created successfully"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response refundPaymentByExternalKey(PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.refundPaymentInternal(json, null, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    private Response refundPaymentInternal(PaymentTransactionJson json, @Nullable UUID paymentId, List<String> paymentControlPluginNames, List<String> pluginPropertiesString, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "PaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAmount(), "PaymentTransactionJson amount needs to be set");
        Iterable<PluginProperty> pluginPropertiesFromBody = this.extractPluginProperties(json.getProperties());
        Iterable<PluginProperty> pluginPropertiesFromQuery = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        Iterable pluginProperties = Iterables.concat(pluginPropertiesFromQuery, pluginPropertiesFromBody);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Payment initialPayment = this.getPaymentByIdOrKey(paymentId, json.getPaymentExternalKey(), pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(initialPayment.getAccountId(), (TenantContext)callContext);
        Currency currency = json.getCurrency() == null ? account.getCurrency() : json.getCurrency();
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        Payment payment = this.paymentApi.createRefundWithPaymentControl(account, initialPayment.getId(), json.getAmount(), currency, json.getEffectiveDate(), json.getTransactionExternalKey(), pluginProperties, paymentOptions, callContext);
        return this.createPaymentResponse(uriInfo, payment, TransactionType.REFUND, json.getTransactionExternalKey(), request);
    }

    @TimedResource(name="voidPayment")
    @DELETE
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Void an existing payment")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response voidPayment(@PathParam(value="paymentId") UUID paymentId, PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.voidPaymentInternal(json, paymentId, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    @TimedResource(name="voidPayment")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Void an existing payment")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response voidPaymentByExternalKey(PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.voidPaymentInternal(json, null, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    private Response voidPaymentInternal(PaymentTransactionJson json, @Nullable UUID paymentId, List<String> paymentControlPluginNames, List<String> pluginPropertiesString, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Iterable<PluginProperty> pluginPropertiesFromBody = this.extractPluginProperties(json != null ? json.getProperties() : null);
        Iterable<PluginProperty> pluginPropertiesFromQuery = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        Iterable pluginProperties = Iterables.concat(pluginPropertiesFromQuery, pluginPropertiesFromBody);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Payment initialPayment = this.getPaymentByIdOrKey(paymentId, json.getPaymentExternalKey(), pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(initialPayment.getAccountId(), (TenantContext)callContext);
        String transactionExternalKey = json != null ? json.getTransactionExternalKey() : null;
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        this.paymentApi.createVoidWithPaymentControl(account, initialPayment.getId(), json.getEffectiveDate(), transactionExternalKey, pluginProperties, paymentOptions, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource(name="chargebackPayment")
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/chargebacks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Record a chargeback", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment transaction created successfully"), @ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response chargebackPayment(@PathParam(value="paymentId") UUID paymentId, PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.chargebackPaymentInternal(json, paymentId, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    @TimedResource(name="chargebackPayment")
    @POST
    @Path(value="/chargebacks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Record a chargeback", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment transaction created successfully"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response chargebackPaymentByExternalKey(PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.chargebackPaymentInternal(json, null, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    private Response chargebackPaymentInternal(PaymentTransactionJson json, @Nullable UUID paymentId, List<String> paymentControlPluginNames, List<String> pluginPropertiesString, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "PaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAmount(), "PaymentTransactionJson amount needs to be set");
        Iterable<PluginProperty> pluginPropertiesFromBody = this.extractPluginProperties(json.getProperties());
        Iterable<PluginProperty> pluginPropertiesFromQuery = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        Iterable pluginProperties = Iterables.concat(pluginPropertiesFromQuery, pluginPropertiesFromBody);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Payment initialPayment = this.getPaymentByIdOrKey(paymentId, json.getPaymentExternalKey(), pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(initialPayment.getAccountId(), (TenantContext)callContext);
        Currency currency = json.getCurrency() == null ? account.getCurrency() : json.getCurrency();
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        Payment payment = this.paymentApi.createChargebackWithPaymentControl(account, initialPayment.getId(), json.getAmount(), currency, json.getEffectiveDate(), json.getTransactionExternalKey(), paymentOptions, callContext);
        return this.createPaymentResponse(uriInfo, payment, TransactionType.CHARGEBACK, json.getTransactionExternalKey(), request);
    }

    @TimedResource(name="chargebackReversalPayment")
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/chargebackReversals")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Record a chargeback reversal", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment transaction created successfully"), @ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response chargebackReversalPayment(@PathParam(value="paymentId") UUID paymentId, PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.chargebackReversalPaymentInternal(json, paymentId, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    @TimedResource(name="chargebackReversalPayment")
    @POST
    @Path(value="/chargebackReversals")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Record a chargeback reversal", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment transaction created successfully"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response chargebackReversalPaymentByExternalKey(PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        return this.chargebackReversalPaymentInternal(json, null, paymentControlPluginNames, pluginPropertiesString, createdBy, reason, comment, uriInfo, request);
    }

    private Response chargebackReversalPaymentInternal(PaymentTransactionJson json, @Nullable UUID paymentId, List<String> paymentControlPluginNames, List<String> pluginPropertiesString, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "PaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getTransactionExternalKey(), "PaymentTransactionJson transactionExternalKey needs to be set");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Payment initialPayment = this.getPaymentByIdOrKey(paymentId, json.getPaymentExternalKey(), pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(initialPayment.getAccountId(), (TenantContext)callContext);
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        Payment payment = this.paymentApi.createChargebackReversalWithPaymentControl(account, initialPayment.getId(), json.getEffectiveDate(), json.getTransactionExternalKey(), paymentOptions, callContext);
        return this.createPaymentResponse(uriInfo, payment, TransactionType.CHARGEBACK, json.getTransactionExternalKey(), request);
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/combo")
    @ApiOperation(value="Combo api to create a new payment transaction on a existing (or not) account ", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment transaction created successfully"), @ApiResponse(code=400, message="Invalid data for Account or PaymentMethod"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response createComboPayment(@MetricTag(tag="type", property="transactionType") ComboPaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Payment result;
        this.verifyNonNullOrEmpty(json, "ComboPaymentTransactionJson body should be specified");
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.getOrCreateAccount(json.getAccount(), callContext);
        Iterable<PluginProperty> paymentMethodPluginProperties = this.extractPluginProperties(json.getPaymentMethodPluginProperties());
        UUID paymentMethodId = this.getOrCreatePaymentMethod(account, json.getPaymentMethod(), paymentMethodPluginProperties, callContext);
        PaymentTransactionJson paymentTransactionJson = json.getTransaction();
        TransactionType transactionType = paymentTransactionJson.getTransactionType();
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        Iterable<PluginProperty> transactionPluginProperties = this.extractPluginProperties(json.getTransactionPluginProperties());
        Currency currency = paymentTransactionJson.getCurrency() == null ? account.getCurrency() : paymentTransactionJson.getCurrency();
        UUID paymentId = null;
        switch (transactionType) {
            case AUTHORIZE: {
                result = this.paymentApi.createAuthorizationWithPaymentControl(account, paymentMethodId, paymentId, paymentTransactionJson.getAmount(), currency, paymentTransactionJson.getEffectiveDate(), paymentTransactionJson.getPaymentExternalKey(), paymentTransactionJson.getTransactionExternalKey(), transactionPluginProperties, paymentOptions, callContext);
                break;
            }
            case PURCHASE: {
                result = this.paymentApi.createPurchaseWithPaymentControl(account, paymentMethodId, paymentId, paymentTransactionJson.getAmount(), currency, paymentTransactionJson.getEffectiveDate(), paymentTransactionJson.getPaymentExternalKey(), paymentTransactionJson.getTransactionExternalKey(), transactionPluginProperties, paymentOptions, callContext);
                break;
            }
            case CREDIT: {
                result = this.paymentApi.createCreditWithPaymentControl(account, paymentMethodId, paymentId, paymentTransactionJson.getAmount(), currency, paymentTransactionJson.getEffectiveDate(), paymentTransactionJson.getPaymentExternalKey(), paymentTransactionJson.getTransactionExternalKey(), transactionPluginProperties, paymentOptions, callContext);
                break;
            }
            default: {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)("TransactionType " + transactionType + " is not allowed for an account")).build();
            }
        }
        return this.createPaymentResponse(uriInfo, result, transactionType, paymentTransactionJson.getTransactionExternalKey(), request);
    }

    @TimedResource(name="cancelScheduledPaymentTransaction")
    @DELETE
    @Path(value="/{paymentTransactionId:\\w+-\\w+-\\w+-\\w+-\\w+}/cancelScheduledPaymentTransaction")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Cancels a scheduled payment attempt retry")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid paymentTransactionId supplied")})
    public Response cancelScheduledPaymentTransactionById(@PathParam(value="paymentTransactionId") UUID paymentTransactionId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        this.paymentApi.cancelScheduledPaymentTransaction(paymentTransactionId, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource(name="cancelScheduledPaymentTransaction")
    @DELETE
    @Path(value="/cancelScheduledPaymentTransaction")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Cancels a scheduled payment attempt retry")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid paymentTransactionExternalKey supplied")})
    public Response cancelScheduledPaymentTransactionByExternalKey(@ApiParam(required=true) @QueryParam(value="transactionExternalKey") String paymentTransactionExternalKey, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        this.paymentApi.cancelScheduledPaymentTransaction(paymentTransactionExternalKey, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payment custom fields", response=CustomFieldJson.class, responseContainer="List", nickname="getPaymentCustomFields")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response getCustomFields(@PathParam(value="paymentId") UUID id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(id, auditMode, this.context.createTenantContextNoAccountId((ServletRequest)request));
    }

    @TimedResource
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to payment", response=CustomField.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Custom field created successfully"), @ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response createPaymentCustomFields(@PathParam(value="paymentId") UUID id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(id, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), uriInfo, request);
    }

    @TimedResource
    @PUT
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Modify custom fields to payment")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response modifyPaymentCustomFields(@PathParam(value="paymentId") UUID id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.modifyCustomFields(id, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @DELETE
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from payment payment")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response deletePaymentCustomFields(@PathParam(value="paymentId") UUID id, @QueryParam(value="customField") List<UUID> customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(id, customFieldList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payment payment tags", response=TagJson.class, responseContainer="List", nickname="getPaymentTags")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied"), @ApiResponse(code=404, message="Invoice not found")})
    public Response getTags(@PathParam(value="paymentId") UUID paymentId, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws TagDefinitionApiException, PaymentApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentId, false, false, (Iterable)ImmutableList.of(), tenantContext);
        return super.getTags(payment.getAccountId(), paymentId, auditMode, includedDeleted, tenantContext);
    }

    @TimedResource
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add tags to payment payment", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Tag created successfully"), @ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response createPaymentTags(@PathParam(value="paymentId") UUID paymentId, List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws TagApiException {
        return super.createTags(paymentId, tagList, uriInfo, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), request);
    }

    @TimedResource
    @DELETE
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove tags from payment payment")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response deletePaymentTags(@PathParam(value="paymentId") UUID paymentId, @QueryParam(value="tagDef") List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(paymentId, tagList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payment audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response getPaymentAuditLogsWithHistory(@PathParam(value="paymentId") UUID paymentId, @Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.paymentApi.getPaymentAuditLogsWithHistoryForId(paymentId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @TimedResource
    @GET
    @Path(value="/attempts/{paymentAttemptId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payment attempt audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response getPaymentAttemptAuditLogsWithHistory(@PathParam(value="paymentAttemptId") UUID paymentAttemptId, @Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.paymentApi.getPaymentAttemptAuditLogsWithHistoryForId(paymentAttemptId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.PAYMENT;
    }

    private void completeTransactionInternalWithoutPayment(PaymentTransactionJson json, @Nullable UUID paymentId, List<String> paymentControlPluginNames, Iterable<String> pluginPropertiesString, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Iterable<PluginProperty> pluginPropertiesFromBody = this.extractPluginProperties(json.getProperties());
        Iterable<PluginProperty> pluginPropertiesFromQuery = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        Iterable pluginProperties = Iterables.concat(pluginPropertiesFromQuery, pluginPropertiesFromBody);
        CallContext callContextNoAccountId = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Payment initialPayment = this.getPaymentByIdOrKey(paymentId, json == null ? null : json.getPaymentExternalKey(), pluginProperties, (TenantContext)callContextNoAccountId);
        this.completeTransactionInternal(json, initialPayment, paymentControlPluginNames, pluginProperties, (TenantContext)callContextNoAccountId, createdBy, reason, comment, uriInfo, request);
    }
}

