/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.PaymentMethodJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Singleton
@Path(value="/1.0/kb/paymentMethods")
@Api(value="/1.0/kb/paymentMethods", description="Operations on payment methods", tags={"PaymentMethod"})
public class PaymentMethodResource
extends JaxRsResourceBase {
    @Inject
    public PaymentMethodResource(AccountUserApi accountUserApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
    }

    @TimedResource(name="getPaymentMethod")
    @GET
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a payment method by id", response=PaymentMethodJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid paymentMethodId supplied"), @ApiResponse(code=404, message="Account or payment method not found")})
    public Response getPaymentMethod(@PathParam(value="paymentMethodId") UUID paymentMethodId, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        PaymentMethod paymentMethod = this.paymentApi.getPaymentMethodById(paymentMethodId, includedDeleted.booleanValue(), withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        Account account = this.accountUserApi.getAccountById(paymentMethod.getAccountId(), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(paymentMethod.getAccountId(), auditMode.getLevel(), tenantContext);
        PaymentMethodJson json = PaymentMethodJson.toPaymentMethodJson(account, paymentMethod, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource(name="getPaymentMethod")
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a payment method by external key", response=PaymentMethodJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Account or payment method not found")})
    public Response getPaymentMethodByKey(@ApiParam(required=true) @QueryParam(value="externalKey") String externalKey, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        PaymentMethod paymentMethod = this.paymentApi.getPaymentMethodByExternalKey(externalKey, includedDeleted.booleanValue(), withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        Account account = this.accountUserApi.getAccountById(paymentMethod.getAccountId(), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(paymentMethod.getAccountId(), auditMode.getLevel(), tenantContext);
        PaymentMethodJson json = PaymentMethodJson.toPaymentMethodJson(account, paymentMethod, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    @ApiOperation(value="List payment methods", response=PaymentMethodJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getPaymentMethods(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination paymentMethods = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.getPaymentMethods(offset, limit, withPluginInfo.booleanValue(), pluginProperties, tenantContext) : this.paymentApi.getPaymentMethods(offset, limit, pluginName, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentMethodResource.class, "getPaymentMethods", paymentMethods.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        final HashMap accounts = new HashMap();
        return this.buildStreamingPaginationResponse(paymentMethods, new Function<PaymentMethod, PaymentMethodJson>(){

            public PaymentMethodJson apply(PaymentMethod paymentMethod) {
                if (((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(paymentMethod.getAccountId(), PaymentMethodResource.this.auditUserApi.getAccountAuditLogs(paymentMethod.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                if (accounts.get(paymentMethod.getAccountId()) == null) {
                    try {
                        Account account = PaymentMethodResource.this.accountUserApi.getAccountById(paymentMethod.getAccountId(), tenantContext);
                        accounts.put(paymentMethod.getAccountId(), account);
                    }
                    catch (AccountApiException e) {
                        JaxRsResourceBase.log.warn("Error retrieving accountId='{}'", (Object)paymentMethod.getAccountId(), (Object)e);
                        return null;
                    }
                }
                return PaymentMethodJson.toPaymentMethodJson((Account)accounts.get(paymentMethod.getAccountId()), paymentMethod, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()));
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search payment methods", response=PaymentMethodJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchPaymentMethods(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination paymentMethods = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.searchPaymentMethods(searchKey, offset, limit, withPluginInfo.booleanValue(), pluginProperties, tenantContext) : this.paymentApi.searchPaymentMethods(searchKey, offset, limit, pluginName, withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentMethodResource.class, "searchPaymentMethods", paymentMethods.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        final HashMap accounts = new HashMap();
        return this.buildStreamingPaginationResponse(paymentMethods, new Function<PaymentMethod, PaymentMethodJson>(){

            public PaymentMethodJson apply(PaymentMethod paymentMethod) {
                if (((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(paymentMethod.getAccountId(), PaymentMethodResource.this.auditUserApi.getAccountAuditLogs(paymentMethod.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                if (accounts.get(paymentMethod.getAccountId()) == null) {
                    try {
                        Account account = PaymentMethodResource.this.accountUserApi.getAccountById(paymentMethod.getAccountId(), tenantContext);
                        accounts.put(paymentMethod.getAccountId(), account);
                    }
                    catch (AccountApiException e) {
                        JaxRsResourceBase.log.warn("Error retrieving accountId='{}'", (Object)paymentMethod.getAccountId(), (Object)e);
                        return null;
                    }
                }
                return PaymentMethodJson.toPaymentMethodJson((Account)accounts.get(paymentMethod.getAccountId()), paymentMethod, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()));
            }
        }, nextPageUri);
    }

    @TimedResource
    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @ApiOperation(value="Delete a payment method")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid paymentMethodId supplied"), @ApiResponse(code=404, message="Account or payment method not found")})
    public Response deletePaymentMethod(@PathParam(value="paymentMethodId") UUID paymentMethodId, @QueryParam(value="deleteDefaultPmWithAutoPayOff") @DefaultValue(value="false") Boolean deleteDefaultPaymentMethodWithAutoPayOff, @QueryParam(value="forceDefaultPmDeletion") @DefaultValue(value="false") Boolean forceDefaultPaymentMethodDeletion, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        PaymentMethod paymentMethod = this.paymentApi.getPaymentMethodById(paymentMethodId, false, false, pluginProperties, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(paymentMethod.getAccountId(), (TenantContext)callContext);
        this.paymentApi.deletePaymentMethod(account, paymentMethodId, deleteDefaultPaymentMethodWithAutoPayOff.booleanValue(), forceDefaultPaymentMethodDeletion.booleanValue(), pluginProperties, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @GET
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payment method custom fields", response=CustomFieldJson.class, responseContainer="List", nickname="getPaymentMethodCustomFields")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment method id supplied")})
    public Response getCustomFields(@PathParam(value="paymentMethodId") UUID paymentMethodId, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(paymentMethodId, auditMode, this.context.createTenantContextNoAccountId((ServletRequest)request));
    }

    @TimedResource
    @POST
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to payment method", response=CustomField.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Custom field created successfully"), @ApiResponse(code=400, message="Invalid payment method id supplied")})
    public Response createPaymentMethodCustomFields(@PathParam(value="paymentMethodId") UUID paymentMethodId, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(paymentMethodId, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), uriInfo, request);
    }

    @TimedResource
    @PUT
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Modify custom fields to payment method")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid payment method id supplied")})
    public Response modifyPaymentMethodCustomFields(@PathParam(value="paymentMethodId") UUID paymentMethodId, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.modifyCustomFields(paymentMethodId, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @DELETE
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from payment method")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid payment method id supplied")})
    public Response deletePaymentMethodCustomFields(@PathParam(value="paymentMethodId") UUID paymentMethodId, @QueryParam(value="customField") List<UUID> customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(paymentMethodId, customFieldList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payment method audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response getPaymentMethodAuditLogsWithHistory(@PathParam(value="paymentMethodId") UUID paymentMethodId, @Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.paymentApi.getPaymentMethodAuditLogsWithHistoryForId(paymentMethodId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.PAYMENT_METHOD;
    }
}

