/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Strings;
import com.google.inject.Singleton;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.ComboHostedPaymentPageJson;
import org.killbill.billing.jaxrs.json.GatewayNotificationJson;
import org.killbill.billing.jaxrs.json.HostedPaymentPageFieldsJson;
import org.killbill.billing.jaxrs.json.HostedPaymentPageFormDescriptorJson;
import org.killbill.billing.jaxrs.resources.ComboPaymentResource;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentGatewayApi;
import org.killbill.billing.payment.api.PaymentOptions;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.plugin.api.GatewayNotification;
import org.killbill.billing.payment.plugin.api.HostedPaymentPageFormDescriptor;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Singleton
@Path(value="/1.0/kb/paymentGateways")
@Api(value="/1.0/kb/paymentGateways", description="HPP endpoints", tags={"PaymentGateway"})
public class PaymentGatewayResource
extends ComboPaymentResource {
    private final PaymentGatewayApi paymentGatewayApi;

    @Inject
    public PaymentGatewayResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentGatewayApi paymentGatewayApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, clock, context);
        this.paymentGatewayApi = paymentGatewayApi;
    }

    @TimedResource
    @POST
    @Path(value="/hosted/form")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Combo API to generate form data to redirect the customer to the gateway", response=HostedPaymentPageFormDescriptorJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid data for Account or PaymentMethod")})
    public Response buildComboFormDescriptor(ComboHostedPaymentPageJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "ComboHostedPaymentPageJson body should be specified");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.getOrCreateAccount(json.getAccount(), callContext);
        Iterable<PluginProperty> paymentMethodPluginProperties = this.extractPluginProperties(json.getPaymentMethodPluginProperties());
        UUID paymentMethodId = this.getOrCreatePaymentMethod(account, json.getPaymentMethod(), paymentMethodPluginProperties, callContext);
        HostedPaymentPageFieldsJson hostedPaymentPageFields = json.getHostedPaymentPageFields();
        Iterable<PluginProperty> customFields = this.extractPluginProperties(hostedPaymentPageFields != null ? hostedPaymentPageFields.getFormFields() : null);
        HostedPaymentPageFormDescriptor descriptor = this.paymentGatewayApi.buildFormDescriptorWithPaymentControl(account, paymentMethodId, customFields, pluginProperties, paymentOptions, callContext);
        HostedPaymentPageFormDescriptorJson result = new HostedPaymentPageFormDescriptorJson(descriptor);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @POST
    @Path(value="/hosted/form/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Generate form data to redirect the customer to the gateway", response=HostedPaymentPageFormDescriptorJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response buildFormDescriptor(@PathParam(value="accountId") UUID accountId, HostedPaymentPageFieldsJson json, @QueryParam(value="paymentMethodId") UUID inputPaymentMethodId, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        UUID paymentMethodId = inputPaymentMethodId == null ? account.getPaymentMethodId() : inputPaymentMethodId;
        this.validatePaymentMethodForAccount(accountId, paymentMethodId, callContext);
        Iterable<PluginProperty> customFields = this.extractPluginProperties(json.getFormFields());
        HostedPaymentPageFormDescriptor descriptor = this.paymentGatewayApi.buildFormDescriptorWithPaymentControl(account, paymentMethodId, customFields, pluginProperties, paymentOptions, callContext);
        HostedPaymentPageFormDescriptorJson result = new HostedPaymentPageFormDescriptorJson(descriptor);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @POST
    @Path(value="/notification/{pluginName:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Process a gateway notification", notes="The response is built by the appropriate plugin")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful")})
    public Response processNotification(@PathParam(value="pluginName") String pluginName, String body, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        String notificationPayload = Strings.emptyToNull((String)body) == null && uriInfo.getRequestUri() != null ? uriInfo.getRequestUri().getRawQuery() : body;
        GatewayNotification notification = this.paymentGatewayApi.processNotificationWithPaymentControl(notificationPayload, pluginName, pluginProperties, paymentOptions, callContext);
        GatewayNotificationJson result = new GatewayNotificationJson(notification);
        return result.toResponse();
    }
}

