/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.OverdueJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.overdue.api.OverdueApi;
import org.killbill.billing.overdue.api.OverdueConfig;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;
import org.killbill.xmlloader.XMLLoader;
import org.killbill.xmlloader.XMLWriter;

@Singleton
@Path(value="/1.0/kb/overdue")
@Api(value="/1.0/kb/overdue", description="Overdue information", tags={"Overdue"})
public class OverdueResource
extends JaxRsResourceBase {
    private final OverdueApi overdueApi;

    @Inject
    public OverdueResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, OverdueApi overdueApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
        this.overdueApi = overdueApi;
    }

    @TimedResource
    @GET
    @Produces(value={"text/xml"})
    @ApiOperation(value="Retrieve the overdue config as XML", response=String.class, hidden=true)
    @ApiResponses(value={})
    public Response getOverdueConfigXmlOriginal(@Context HttpServletRequest request) throws Exception {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)XMLWriter.writeXML((Object)((DefaultOverdueConfig)this.overdueApi.getOverdueConfig(tenantContext)), DefaultOverdueConfig.class)).build();
    }

    @TimedResource
    @GET
    @Path(value="/xml")
    @Produces(value={"text/xml"})
    @ApiOperation(value="Retrieve the overdue config as XML", response=String.class)
    @ApiResponses(value={})
    public Response getOverdueConfigXml(@Context HttpServletRequest request) throws Exception {
        return this.getOverdueConfigXmlOriginal(request);
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the overdue config as JSON", response=OverdueJson.class)
    @ApiResponses(value={})
    public Response getOverdueConfigJson(@Context HttpServletRequest request) throws Exception {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        OverdueConfig overdueConfig = this.overdueApi.getOverdueConfig(tenantContext);
        OverdueJson result = new OverdueJson(overdueConfig);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @POST
    @Consumes(value={"text/xml"})
    @ApiOperation(value="Upload the full overdue config as XML", hidden=true)
    @ApiResponses(value={})
    public Response uploadOverdueConfigXmlOriginal(String overdueXML, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(overdueXML.getBytes());
        XMLLoader.getObjectFromStream((InputStream)stream, DefaultOverdueConfig.class);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        this.overdueApi.uploadOverdueConfig(overdueXML, callContext);
        return this.uriBuilder.buildResponse(uriInfo, OverdueResource.class, null, null, (ServletRequest)request);
    }

    @TimedResource
    @POST
    @Path(value="/xml")
    @Consumes(value={"text/xml"})
    @ApiOperation(value="Upload the full overdue config as XML", response=String.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Successfully uploaded overdue config"), @ApiResponse(code=400, message="Invalid node command supplied")})
    public Response uploadOverdueConfigXml(String overdueXML, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        return this.uploadOverdueConfigXmlOriginal(overdueXML, createdBy, reason, comment, request, uriInfo);
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Upload the full overdue config as JSON", response=OverdueJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Successfully uploaded overdue config"), @ApiResponse(code=400, message="Invalid node command supplied")})
    public Response uploadOverdueConfigJson(OverdueJson overdueJson, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        OverdueConfig overdueConfig = OverdueJson.toOverdueConfigWithValidation(overdueJson);
        this.overdueApi.uploadOverdueConfig(overdueConfig, callContext);
        return this.uriBuilder.buildResponse(uriInfo, OverdueResource.class, null, null, (ServletRequest)request);
    }
}

