/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.jaxrs.json.NodeCommandJson;
import org.killbill.billing.jaxrs.json.NodeCommandPropertyJson;
import org.killbill.billing.jaxrs.json.NodeInfoJson;
import org.killbill.billing.jaxrs.json.PluginInfoJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.osgi.api.PluginInfo;
import org.killbill.billing.osgi.api.PluginServiceInfo;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.nodes.KillbillNodesApi;
import org.killbill.billing.util.nodes.NodeCommand;
import org.killbill.billing.util.nodes.NodeCommandMetadata;
import org.killbill.billing.util.nodes.NodeCommandProperty;
import org.killbill.billing.util.nodes.NodeInfo;
import org.killbill.billing.util.nodes.PluginNodeCommandMetadata;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Path(value="/1.0/kb/nodesInfo")
@Api(value="/1.0/kb/nodesInfo", description="Operations to retrieve nodes info", tags={"NodesInfo"})
public class NodesInfoResource
extends JaxRsResourceBase {
    private final KillbillNodesApi killbillInfoApi;

    @Inject
    public NodesInfoResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, KillbillNodesApi killbillInfoApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
        this.killbillInfoApi = killbillInfoApi;
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve all the nodes infos", response=PluginInfoJson.class, responseContainer="List")
    public Response getNodesInfo(@Context HttpServletRequest request) throws SubscriptionApiException {
        Iterable nodeInfos = this.killbillInfoApi.getNodesInfo();
        ImmutableList nodeInfosJson = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)nodeInfos, (Function)new Function<NodeInfo, NodeInfoJson>(){

            public NodeInfoJson apply(NodeInfo input) {
                Iterable pluginsInfo = input.getPluginInfo();
                ImmutableList pluginsInfoJson = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)pluginsInfo, (Function)new Function<PluginInfo, PluginInfoJson>(){

                    public PluginInfoJson apply(PluginInfo input) {
                        Set services = input.getServices();
                        ImmutableSet servicesJson = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)services, (Function)new Function<PluginServiceInfo, PluginInfoJson.PluginServiceInfoJson>(){

                            public PluginInfoJson.PluginServiceInfoJson apply(PluginServiceInfo input) {
                                return new PluginInfoJson.PluginServiceInfoJson(input.getServiceTypeName(), input.getRegistrationName());
                            }
                        }));
                        return new PluginInfoJson(input.getBundleSymbolicName(), input.getPluginKey(), input.getPluginName(), input.getVersion(), input.getPluginState().name(), input.isSelectedForStart(), (Set<PluginInfoJson.PluginServiceInfoJson>)servicesJson);
                    }
                }));
                return new NodeInfoJson(input.getNodeName(), input.getBootTime(), input.getLastUpdatedDate(), input.getKillbillVersion(), input.getApiVersion(), input.getPluginApiVersion(), input.getCommonVersion(), input.getPlatformVersion(), (List<PluginInfoJson>)pluginsInfoJson);
            }
        }));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)nodeInfosJson).build();
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Trigger a node command")
    @ApiResponses(value={@ApiResponse(code=202, message="Successful operation"), @ApiResponse(code=400, message="Invalid node command supplied")})
    public Response triggerNodeCommand(final NodeCommandJson json, @QueryParam(value="localNodeOnly") @DefaultValue(value="false") Boolean localNodeOnly, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) {
        NodeInfo currentNodeInfo = this.killbillInfoApi.getCurrentNodeInfo();
        if (currentNodeInfo != null) {
            json.getNodeCommandProperties().add(new NodeCommandPropertyJson("kbVersion", currentNodeInfo.getKillbillVersion()));
        }
        final NodeCommandMetadata metadata = this.toNodeCommandMetadata(json);
        NodeCommand nodeCommand = new NodeCommand(){

            public boolean isSystemCommandType() {
                return json.isSystemCommandType();
            }

            public String getNodeCommandType() {
                return json.getNodeCommandType();
            }

            public NodeCommandMetadata getNodeCommandMetadata() {
                return metadata;
            }
        };
        this.killbillInfoApi.triggerNodeCommand(nodeCommand, localNodeOnly.booleanValue());
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    private NodeCommandMetadata toNodeCommandMetadata(final NodeCommandJson input) {
        if (input.getNodeCommandProperties() == null || input.getNodeCommandProperties().isEmpty()) {
            return new NodeCommandMetadata(){

                public List<NodeCommandProperty> getProperties() {
                    return ImmutableList.of();
                }
            };
        }
        String pluginKey = null;
        String pluginName = null;
        String pluginVersion = null;
        for (NodeCommandProperty nodeCommandProperty : input.getNodeCommandProperties()) {
            if ("pluginName".equals(nodeCommandProperty.getKey())) {
                pluginName = (String)nodeCommandProperty.getValue();
            } else if ("pluginVersion".equals(nodeCommandProperty.getKey())) {
                pluginVersion = (String)nodeCommandProperty.getValue();
            } else if ("pluginKey".equals(nodeCommandProperty.getKey())) {
                pluginKey = (String)nodeCommandProperty.getValue();
            }
            if (pluginName == null || pluginVersion == null || pluginKey == null) continue;
            break;
        }
        if (pluginName != null || pluginKey != null) {
            this.removeFirstClassProperties(input.getNodeCommandProperties(), "pluginName", "pluginVersion", "pluginKey");
            return new PluginNodeCommandMetadata(pluginKey, pluginName, pluginVersion, this.toNodeCommandProperties(input.getNodeCommandProperties()));
        }
        return new NodeCommandMetadata(){

            public List<NodeCommandProperty> getProperties() {
                return NodesInfoResource.this.toNodeCommandProperties(input.getNodeCommandProperties());
            }
        };
    }

    private void removeFirstClassProperties(List<NodeCommandPropertyJson> properties, String ... toBeRemoved) {
        Iterator<NodeCommandPropertyJson> it = properties.iterator();
        block0: while (it.hasNext()) {
            NodeCommandPropertyJson cur = it.next();
            for (String p : toBeRemoved) {
                if (!cur.getKey().equals(p)) continue;
                it.remove();
                continue block0;
            }
        }
    }

    private List<NodeCommandProperty> toNodeCommandProperties(List<NodeCommandPropertyJson> input) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(input, (Function)new Function<NodeCommandPropertyJson, NodeCommandProperty>(){

            public NodeCommandProperty apply(NodeCommandPropertyJson input) {
                return input;
            }
        }));
    }
}

