/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.ReaderListener;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import java.util.List;
import org.killbill.billing.util.api.AuditLevel;

@SwaggerDefinition
public class KillBillApiDefinition
implements ReaderListener {
    public static final String BASIC_AUTH_SCHEME = "basicAuth";
    public static final String API_KEY_SCHEME = "Killbill Api Key";
    public static final String API_SECRET_SCHEME = "Killbill Api Secret";

    public void beforeScan(Reader reader, Swagger swagger) {
        BasicAuthDefinition basicAuthDefinition = new BasicAuthDefinition();
        swagger.addSecurityDefinition(BASIC_AUTH_SCHEME, (SecuritySchemeDefinition)basicAuthDefinition);
        ApiKeyAuthDefinition xKillbillApiKey = new ApiKeyAuthDefinition("X-Killbill-ApiKey", In.HEADER);
        swagger.addSecurityDefinition(API_KEY_SCHEME, (SecuritySchemeDefinition)xKillbillApiKey);
        ApiKeyAuthDefinition xKillbillApiSecret = new ApiKeyAuthDefinition("X-Killbill-ApiSecret", In.HEADER);
        swagger.addSecurityDefinition(API_SECRET_SCHEME, (SecuritySchemeDefinition)xKillbillApiSecret);
    }

    public void afterScan(Reader reader, Swagger swagger) {
        for (String pathName : swagger.getPaths().keySet()) {
            Path path = (Path)swagger.getPaths().get(pathName);
            this.decorateOperation(path.getGet(), pathName, "GET");
            this.decorateOperation(path.getPost(), pathName, "POST");
            this.decorateOperation(path.getPut(), pathName, "PUT");
            this.decorateOperation(path.getDelete(), pathName, "DELETE");
            this.decorateOperation(path.getOptions(), pathName, "OPTIONS");
        }
        for (Model m : swagger.getDefinitions().values()) {
            if (m.getProperties() == null) continue;
            for (Property p : m.getProperties().values()) {
                p.setReadOnly(Boolean.valueOf(false));
            }
        }
    }

    private void decorateOperation(Operation op, String pathName, String httpMethod) {
        if (op != null) {
            if (httpMethod.equals("POST") && op.getResponses().containsKey("201") && op.getResponses().containsKey("200")) {
                Response resp200 = (Response)op.getResponses().remove("200");
                Response resp201 = (Response)op.getResponses().get("201");
                if (resp201.getSchema() == null) {
                    resp201.setSchema(resp200.getSchema());
                }
            }
            op.addSecurity(BASIC_AUTH_SCHEME, null);
            if (KillBillApiDefinition.requiresTenantInformation(pathName, httpMethod)) {
                op.addSecurity(API_KEY_SCHEME, null);
                op.addSecurity(API_SECRET_SCHEME, null);
            }
            for (Parameter p : op.getParameters()) {
                if (p instanceof BodyParameter) {
                    p.setRequired(true);
                    continue;
                }
                if (p instanceof PathParameter) {
                    p.setRequired(true);
                    continue;
                }
                if (p instanceof HeaderParameter) {
                    if (!p.getName().equals("X-Killbill-CreatedBy")) continue;
                    p.setRequired(true);
                    continue;
                }
                if (!(p instanceof QueryParameter)) continue;
                QueryParameter qp = (QueryParameter)p;
                if (qp.getName().equals("audit")) {
                    qp.setRequired(false);
                    qp.setType("string");
                    ImmutableList values = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)ImmutableList.copyOf((Object[])AuditLevel.values()), (Function)new Function<AuditLevel, String>(){

                        public String apply(AuditLevel input) {
                            return input.toString();
                        }
                    }));
                    qp.setEnum((List)values);
                    continue;
                }
                if (!qp.getName().equals("requestedDate") && !qp.getName().equals("entitlementDate") && !qp.getName().equals("billingDate") && !qp.getName().equals("effectiveFromDate") && !qp.getName().equals("startDate") && !qp.getName().equals("endDate") && !qp.getName().equals("targetDate")) continue;
                qp.setType("string");
                if (op.getOperationId().equals("getCatalogJson") || op.getOperationId().equals("getCatalogXml") || op.getOperationId().equals("setTestClockTime")) {
                    qp.setFormat("date-time");
                    continue;
                }
                qp.setFormat("date");
            }
        }
    }

    public static boolean requiresTenantInformation(String path, String httpMethod) {
        boolean shouldSkipTenantInfoForRequests = KillBillApiDefinition.isTenantCreationRequest(path, httpMethod) || KillBillApiDefinition.isPermissionRequest(path) || KillBillApiDefinition.isNodeInfoRequest(path) || KillBillApiDefinition.isOptionsRequest(httpMethod) || KillBillApiDefinition.isPluginRequest(path) || KillBillApiDefinition.isNotKbNorPluginResourceRequest(path, httpMethod);
        return !shouldSkipTenantInfoForRequests;
    }

    private static boolean isPermissionRequest(String path) {
        return path != null && path.startsWith("/1.0/kb/security");
    }

    private static boolean isTenantCreationRequest(String path, String httpMethod) {
        return "/1.0/kb/tenants".equals(path);
    }

    private static boolean isNodeInfoRequest(String path) {
        return "/1.0/kb/nodesInfo".equals(path);
    }

    private static boolean isOptionsRequest(String httpMethod) {
        return "OPTIONS".equalsIgnoreCase(httpMethod);
    }

    private static boolean isNotKbNorPluginResourceRequest(String path, String httpMethod) {
        return !KillBillApiDefinition.isPluginRequest(path) && !KillBillApiDefinition.isKbApiRequest(path) && "GET".equalsIgnoreCase(httpMethod);
    }

    private static boolean isKbApiRequest(String path) {
        return path != null && path.startsWith("/1.0/kb");
    }

    private static boolean isPluginRequest(String path) {
        return path != null && path.startsWith("/plugins");
    }
}

