/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentType;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.BillingExceptionJson;
import org.killbill.billing.jaxrs.json.BlockingStateJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.PaymentTransactionJson;
import org.killbill.billing.jaxrs.json.PluginPropertyJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AccountResource;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxrsResource;
import org.killbill.billing.jaxrs.resources.PaymentResource;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PaymentOptions;
import org.killbill.billing.payment.api.PaymentTransaction;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.api.TransactionStatus;
import org.killbill.billing.payment.api.TransactionType;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogsForObjectType;
import org.killbill.billing.util.audit.AuditLogWithHistory;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.customfield.StringCustomField;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JaxRsResourceBase
implements JaxrsResource {
    static final Logger log = LoggerFactory.getLogger(JaxRsResourceBase.class);
    protected static final String catalogName = "unused";
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected final JaxrsUriBuilder uriBuilder;
    protected final TagUserApi tagUserApi;
    protected final CustomFieldUserApi customFieldUserApi;
    protected final AuditUserApi auditUserApi;
    protected final AccountUserApi accountUserApi;
    protected final PaymentApi paymentApi;
    protected final InvoicePaymentApi invoicePaymentApi;
    protected final SubscriptionApi subscriptionApi;
    protected final Context context;
    protected final Clock clock;
    protected final DateTimeFormatter DATE_TIME_FORMATTER = ISODateTimeFormat.dateTimeParser();
    protected final DateTimeFormatter LOCAL_DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    public JaxRsResourceBase(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, SubscriptionApi subscriptionApi, Clock clock, Context context) {
        this.uriBuilder = uriBuilder;
        this.tagUserApi = tagUserApi;
        this.customFieldUserApi = customFieldUserApi;
        this.auditUserApi = auditUserApi;
        this.accountUserApi = accountUserApi;
        this.paymentApi = paymentApi;
        this.invoicePaymentApi = invoicePaymentApi;
        this.subscriptionApi = subscriptionApi;
        this.clock = clock;
        this.context = context;
    }

    protected ObjectType getObjectType() {
        return null;
    }

    protected Response addBlockingState(BlockingStateJson json, UUID accountId, UUID blockableId, BlockingStateType type, String requestedDate, List<String> pluginPropertiesString, String createdBy, String reason, String comment, HttpServletRequest request, @Nullable UriInfo uriInfo) throws SubscriptionApiException, EntitlementApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        boolean isBlockBilling = json.isBlockBilling() != null && json.isBlockBilling() != false;
        boolean isBlockEntitlement = json.isBlockEntitlement() != null && json.isBlockEntitlement() != false;
        boolean isBlockChange = json.isBlockChange() != null && json.isBlockChange() != false;
        LocalDate resolvedRequestedDate = this.toLocalDate(requestedDate);
        DefaultBlockingState input = new DefaultBlockingState(blockableId, type, json.getStateName(), json.getService(), isBlockChange, isBlockEntitlement, isBlockBilling, null);
        this.subscriptionApi.addBlockingState((BlockingState)input, resolvedRequestedDate, pluginProperties, callContext);
        return uriInfo != null ? this.uriBuilder.buildResponse(uriInfo, AccountResource.class, "getBlockingStates", accountId, (Map<String, String>)ImmutableMap.of((Object)"blockingStateTypes", (Object)type.name()), (ServletRequest)request) : null;
    }

    protected Response getTags(UUID accountId, UUID taggedObjectId, AuditMode auditMode, boolean includeDeleted, TenantContext context) throws TagDefinitionApiException {
        List tags = this.tagUserApi.getTagsForObject(taggedObjectId, this.getObjectType(), includeDeleted, context);
        return this.createTagResponse(accountId, tags, auditMode, context);
    }

    protected Response createTagResponse(UUID accountId, List<Tag> tags, AuditMode auditMode, TenantContext context) throws TagDefinitionApiException {
        AccountAuditLogsForObjectType tagsAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, ObjectType.TAG, auditMode.getLevel(), context);
        HashMap<UUID, TagDefinition> tagDefinitionsCache = new HashMap<UUID, TagDefinition>();
        LinkedList<TagJson> result = new LinkedList<TagJson>();
        for (Tag tag : tags) {
            if (tagDefinitionsCache.get(tag.getTagDefinitionId()) == null) {
                tagDefinitionsCache.put(tag.getTagDefinitionId(), this.tagUserApi.getTagDefinition(tag.getTagDefinitionId(), context));
            }
            TagDefinition tagDefinition = (TagDefinition)tagDefinitionsCache.get(tag.getTagDefinitionId());
            List auditLogs = tagsAuditLogs.getAuditLogs(tag.getId());
            result.add(new TagJson(tag, tagDefinition, auditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    protected Response createTags(UUID id, List<UUID> tagList, UriInfo uriInfo, CallContext context, HttpServletRequest request) throws TagApiException {
        this.tagUserApi.addTags(id, this.getObjectType(), tagList, context);
        return this.uriBuilder.buildResponse(uriInfo, this.getClass(), "getTags", id, (ServletRequest)request);
    }

    protected Collection<UUID> getTagDefinitionUUIDs(List<String> tagList) {
        return Collections2.transform(tagList, (Function)new Function<String, UUID>(){

            public UUID apply(String input) {
                return UUID.fromString(input);
            }
        });
    }

    protected Response deleteTags(UUID id, List<UUID> tagList, CallContext context) throws TagApiException {
        this.tagUserApi.removeTags(id, this.getObjectType(), tagList, context);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    protected Response getCustomFields(UUID id, AuditMode auditMode, TenantContext context) {
        List fields = this.customFieldUserApi.getCustomFieldsForObject(id, this.getObjectType(), context);
        return this.createCustomFieldResponse(fields, auditMode, context);
    }

    protected Response createCustomFieldResponse(Iterable<CustomField> fields, AuditMode auditMode, TenantContext context) {
        LinkedList<CustomFieldJson> result = new LinkedList<CustomFieldJson>();
        for (CustomField cur : fields) {
            List auditLogs = this.auditUserApi.getAuditLogs(cur.getId(), ObjectType.CUSTOM_FIELD, auditMode.getLevel(), context);
            result.add(new CustomFieldJson(cur, auditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    protected Response createCustomFields(UUID id, List<CustomFieldJson> customFields, CallContext context, UriInfo uriInfo, HttpServletRequest request) throws CustomFieldApiException {
        LinkedList<StringCustomField> input = new LinkedList<StringCustomField>();
        for (CustomFieldJson cur : customFields) {
            this.verifyNonNullOrEmpty(cur.getName(), "CustomFieldJson name needs to be set");
            this.verifyNonNullOrEmpty(cur.getValue(), "CustomFieldJson value needs to be set");
            input.add(new StringCustomField(cur.getName(), cur.getValue(), this.getObjectType(), id, context.getCreatedDate()));
        }
        this.customFieldUserApi.addCustomFields(input, context);
        return this.uriBuilder.buildResponse(uriInfo, this.getClass(), "getCustomFields", id, (ServletRequest)request);
    }

    protected Response modifyCustomFields(UUID id, List<CustomFieldJson> customFields, CallContext context) throws CustomFieldApiException {
        LinkedList<StringCustomField> input = new LinkedList<StringCustomField>();
        for (CustomFieldJson cur : customFields) {
            this.verifyNonNullOrEmpty(cur.getCustomFieldId(), "CustomFieldJson id needs to be set");
            this.verifyNonNullOrEmpty(cur.getValue(), "CustomFieldJson value needs to be set");
            input.add(new StringCustomField(cur.getCustomFieldId(), cur.getName(), cur.getValue(), this.getObjectType(), id, context.getCreatedDate()));
        }
        this.customFieldUserApi.updateCustomFields(input, context);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    protected Response deleteCustomFields(UUID id, final List<UUID> customFieldList, CallContext context) throws CustomFieldApiException {
        List fields = this.customFieldUserApi.getCustomFieldsForObject(id, this.getObjectType(), (TenantContext)context);
        Iterable inputIterable = Iterables.filter((Iterable)fields, (Predicate)new Predicate<CustomField>(){

            public boolean apply(CustomField input) {
                if (customFieldList.isEmpty()) {
                    return true;
                }
                for (UUID curId : customFieldList) {
                    if (!input.getId().equals(curId)) continue;
                    return true;
                }
                return false;
            }
        });
        if (inputIterable.iterator().hasNext()) {
            ImmutableList input = ImmutableList.copyOf((Iterable)inputIterable);
            this.customFieldUserApi.removeCustomFields((List)input, context);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    protected <E extends Entity, J extends JsonBase> Response buildStreamingPaginationResponse(final Pagination<E> entities, final Function<E, J> toJson, URI nextPageUri) {
        StreamingOutput json = new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(OutputStream output) throws IOException, WebApplicationException {
                Iterator iterator = entities.iterator();
                try {
                    JsonGenerator generator = mapper.getFactory().createGenerator(output);
                    generator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
                    generator.writeStartArray();
                    while (iterator.hasNext()) {
                        Entity entity = (Entity)iterator.next();
                        JsonBase asJson = (JsonBase)toJson.apply((Object)entity);
                        if (asJson == null) continue;
                        generator.writeObject((Object)asJson);
                    }
                    generator.writeEndArray();
                    generator.close();
                }
                finally {
                    entities.close();
                }
            }
        };
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).header("X-Killbill-Pagination-CurrentOffset", (Object)entities.getCurrentOffset()).header("X-Killbill-Pagination-NextOffset", (Object)entities.getNextOffset()).header("X-Killbill-Pagination-TotalNbRecords", (Object)entities.getTotalNbRecords()).header("X-Killbill-Pagination-MaxNbRecords", (Object)entities.getMaxNbRecords()).header("X-Killbill-Pagination-NextPageUri", (Object)nextPageUri).build();
    }

    protected void validatePaymentMethodForAccount(UUID accountId, UUID paymentMethodId, CallContext callContext) throws PaymentApiException {
        PaymentMethod paymentMethod;
        if (paymentMethodId != null && !(paymentMethod = this.paymentApi.getPaymentMethodById(paymentMethodId, false, false, (Iterable)ImmutableList.of(), (TenantContext)callContext)).getAccountId().equals(accountId)) {
            throw new PaymentApiException(ErrorCode.PAYMENT_NO_SUCH_PAYMENT_METHOD, new Object[]{paymentMethodId});
        }
    }

    protected Payment getPaymentByIdOrKey(@Nullable UUID paymentId, @Nullable String externalKey, Iterable<PluginProperty> pluginProperties, TenantContext tenantContext) throws PaymentApiException {
        Preconditions.checkArgument((paymentId != null || externalKey != null ? 1 : 0) != 0, (Object)"Need to set either paymentId or payment externalKey");
        if (paymentId != null) {
            return this.paymentApi.getPayment(paymentId, false, false, pluginProperties, tenantContext);
        }
        return this.paymentApi.getPaymentByExternalKey(externalKey, false, false, pluginProperties, tenantContext);
    }

    protected void completeTransactionInternal(PaymentTransactionJson json, Payment initialPayment, List<String> paymentControlPluginNames, Iterable<PluginProperty> pluginProperties, TenantContext contextNoAccountId, String createdBy, String reason, String comment, UriInfo uriInfo, HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Account account = this.accountUserApi.getAccountById(initialPayment.getAccountId(), contextNoAccountId);
        BigDecimal amount = json == null ? null : json.getAmount();
        Currency currency = json == null ? null : json.getCurrency();
        CallContext callContext = this.context.createCallContextWithAccountId(account.getId(), createdBy, reason, comment, (ServletRequest)request);
        PaymentTransaction pendingOrSuccessTransaction = this.lookupPendingOrSuccessTransaction(initialPayment, json != null ? json.getTransactionId() : null, json != null ? json.getTransactionExternalKey() : null, json != null ? json.getTransactionType() : null);
        if (pendingOrSuccessTransaction.getTransactionStatus() == TransactionStatus.SUCCESS) {
            return;
        }
        PaymentTransaction pendingTransaction = pendingOrSuccessTransaction;
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        switch (pendingTransaction.getTransactionType()) {
            case AUTHORIZE: {
                this.paymentApi.createAuthorizationWithPaymentControl(account, initialPayment.getPaymentMethodId(), initialPayment.getId(), amount, currency, null, initialPayment.getExternalKey(), pendingTransaction.getExternalKey(), pluginProperties, paymentOptions, callContext);
                break;
            }
            case CAPTURE: {
                this.paymentApi.createCaptureWithPaymentControl(account, initialPayment.getId(), amount, currency, null, pendingTransaction.getExternalKey(), pluginProperties, paymentOptions, callContext);
                break;
            }
            case PURCHASE: {
                this.paymentApi.createPurchaseWithPaymentControl(account, initialPayment.getPaymentMethodId(), initialPayment.getId(), amount, currency, null, initialPayment.getExternalKey(), pendingTransaction.getExternalKey(), pluginProperties, paymentOptions, callContext);
                break;
            }
            case CREDIT: {
                this.paymentApi.createCreditWithPaymentControl(account, initialPayment.getPaymentMethodId(), initialPayment.getId(), amount, currency, null, initialPayment.getExternalKey(), pendingTransaction.getExternalKey(), pluginProperties, paymentOptions, callContext);
                break;
            }
            case REFUND: {
                this.paymentApi.createRefundWithPaymentControl(account, initialPayment.getId(), amount, currency, null, pendingTransaction.getExternalKey(), pluginProperties, paymentOptions, callContext);
                break;
            }
            default: {
                throw new IllegalStateException("TransactionType " + pendingTransaction.getTransactionType() + " cannot be completed");
            }
        }
    }

    protected PaymentTransaction lookupPendingOrSuccessTransaction(Payment initialPayment, final @Nullable UUID transactionId, final @Nullable String transactionExternalKey, final @Nullable TransactionType transactionType) throws PaymentApiException {
        Collection pendingTransaction = Collections2.filter((Collection)initialPayment.getTransactions(), (Predicate)new Predicate<PaymentTransaction>(){

            public boolean apply(PaymentTransaction input) {
                if (input.getTransactionStatus() != TransactionStatus.PENDING && input.getTransactionStatus() != TransactionStatus.SUCCESS) {
                    return false;
                }
                if (transactionId != null && !transactionId.equals(input.getId())) {
                    return false;
                }
                if (transactionExternalKey != null && !transactionExternalKey.equals(input.getExternalKey())) {
                    return false;
                }
                return transactionType == null || transactionType.equals((Object)input.getTransactionType());
            }
        });
        switch (pendingTransaction.size()) {
            case 0: {
                String parameterValue;
                String parameterType;
                if (transactionId != null) {
                    parameterType = "transactionId";
                    parameterValue = transactionId.toString();
                } else if (transactionExternalKey != null) {
                    parameterType = "transactionExternalKey";
                    parameterValue = transactionExternalKey;
                } else if (transactionType != null) {
                    parameterType = "transactionType";
                    parameterValue = transactionType.name();
                } else {
                    parameterType = "paymentId";
                    parameterValue = initialPayment.getId().toString();
                }
                throw new PaymentApiException(ErrorCode.PAYMENT_INVALID_PARAMETER, new Object[]{parameterType, parameterValue});
            }
            case 1: {
                return (PaymentTransaction)pendingTransaction.iterator().next();
            }
        }
        throw new PaymentApiException(ErrorCode.PAYMENT_INTERNAL_ERROR, new Object[]{String.format("Illegal payment state: Found multiple PENDING payment transactions for paymentId='%s'", initialPayment.getId())});
    }

    protected LocalDate toLocalDateDefaultToday(UUID accountId, @Nullable String inputDate, TenantContext context) throws AccountApiException {
        Account account = accountId != null ? this.accountUserApi.getAccountById(accountId, context) : null;
        return this.toLocalDateDefaultToday(account, inputDate, context);
    }

    protected LocalDate toLocalDateDefaultToday(Account account, @Nullable String inputDate, TenantContext context) {
        return (LocalDate)MoreObjects.firstNonNull((Object)this.toLocalDate(inputDate), (Object)this.clock.getToday(account.getTimeZone()));
    }

    protected LocalDate toLocalDate(@Nullable String inputDate) {
        return inputDate == null || inputDate.isEmpty() ? null : LocalDate.parse((String)inputDate, (DateTimeFormatter)this.LOCAL_DATE_FORMATTER);
    }

    protected Iterable<PluginProperty> extractPluginProperties(@Nullable Iterable<PluginPropertyJson> pluginProperties) {
        return pluginProperties != null ? Iterables.transform(pluginProperties, (Function)new Function<PluginPropertyJson, PluginProperty>(){

            public PluginProperty apply(PluginPropertyJson pluginPropertyJson) {
                return pluginPropertyJson.toPluginProperty();
            }
        }) : ImmutableList.of();
    }

    protected Iterable<PluginProperty> extractPluginProperties(@Nullable Iterable<String> pluginProperties, PluginProperty ... additionalProperties) {
        LinkedList<PluginProperty> properties = new LinkedList<PluginProperty>();
        if (pluginProperties == null) {
            return properties;
        }
        for (String pluginProperty : pluginProperties) {
            ImmutableList property = ImmutableList.copyOf((Object[])pluginProperty.split("="));
            if (property.size() == 1) continue;
            String key = (String)property.get(0);
            String value = Joiner.on((String)"=").join(property.subList(1, property.size()));
            if (pluginProperty.endsWith("=")) {
                value = value + "=";
            }
            properties.add(new PluginProperty(key, (Object)value, Boolean.valueOf(false)));
        }
        for (PluginProperty cur : additionalProperties) {
            properties.add(cur);
        }
        return properties;
    }

    protected InvoicePayment createPurchaseForInvoice(Account account, UUID invoiceId, BigDecimal amountToPay, UUID paymentMethodId, Boolean externalPayment, String paymentExternalKey, String transactionExternalKey, Iterable<PluginProperty> pluginProperties, CallContext callContext) throws PaymentApiException {
        try {
            return this.invoicePaymentApi.createPurchaseForInvoicePayment(account, invoiceId, paymentMethodId, null, amountToPay, account.getCurrency(), null, paymentExternalKey, transactionExternalKey, pluginProperties, this.createInvoicePaymentControlPluginApiPaymentOptions(externalPayment), callContext);
        }
        catch (PaymentApiException e) {
            if (e.getCode() == ErrorCode.PAYMENT_PLUGIN_EXCEPTION.getCode()) {
                throw e;
            }
            if (e.getCode() == ErrorCode.PAYMENT_PLUGIN_API_ABORTED.getCode()) {
                return null;
            }
            throw e;
        }
    }

    protected PaymentOptions createInvoicePaymentControlPluginApiPaymentOptions(boolean isExternalPayment) {
        return this.createControlPluginApiPaymentOptions(isExternalPayment, (List<String>)ImmutableList.of());
    }

    protected PaymentOptions createControlPluginApiPaymentOptions(@Nullable List<String> paymentControlPluginNames) {
        return this.createControlPluginApiPaymentOptions(false, paymentControlPluginNames);
    }

    protected PaymentOptions createControlPluginApiPaymentOptions(final boolean isExternalPayment, final List<String> paymentControlPluginNames) {
        return new PaymentOptions(){

            public boolean isExternalPayment() {
                return isExternalPayment;
            }

            public List<String> getPaymentControlPluginNames() {
                return paymentControlPluginNames;
            }
        };
    }

    protected Iterable<InvoiceItem> validateSanitizeAndTranformInputItems(final Currency accountCurrency, Iterable<InvoiceItemJson> inputItems) throws InvoiceApiException {
        try {
            Iterable sanitized = Iterables.transform(inputItems, (Function)new Function<InvoiceItemJson, InvoiceItemJson>(){

                public InvoiceItemJson apply(InvoiceItemJson input) {
                    if (input.getCurrency() != null) {
                        if (!input.getCurrency().equals((Object)accountCurrency)) {
                            throw new IllegalArgumentException(input.getCurrency().toString());
                        }
                        return input;
                    }
                    return new InvoiceItemJson(null, input.getInvoiceId(), input.getLinkedInvoiceItemId(), input.getAccountId(), input.getChildAccountId(), input.getBundleId(), input.getSubscriptionId(), input.getProductName(), input.getPlanName(), input.getPhaseName(), input.getUsageName(), input.getPrettyProductName(), input.getPrettyPlanName(), input.getPrettyPhaseName(), input.getPrettyUsageName(), input.getItemType(), input.getDescription(), input.getStartDate(), input.getEndDate(), input.getAmount(), input.getRate(), accountCurrency, input.getQuantity(), input.getItemDetails(), input.getCatalogEffectiveDate(), null, null);
                }
            });
            return Iterables.transform((Iterable)sanitized, (Function)new Function<InvoiceItemJson, InvoiceItem>(){

                public InvoiceItem apply(InvoiceItemJson input) {
                    return input.toInvoiceItem();
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new InvoiceApiException(ErrorCode.CURRENCY_INVALID, new Object[]{accountCurrency, e.getMessage()});
        }
    }

    public static Iterable<PaymentTransaction> getPaymentTransactions(List<Payment> payments, final TransactionType transactionType) {
        return Iterables.concat((Iterable)Iterables.transform(payments, (Function)new Function<Payment, Iterable<PaymentTransaction>>(){

            public Iterable<PaymentTransaction> apply(Payment input) {
                return Iterables.filter((Iterable)input.getTransactions(), (Predicate)new Predicate<PaymentTransaction>(){

                    public boolean apply(PaymentTransaction input) {
                        return input.getTransactionType() == transactionType;
                    }
                });
            }
        }));
    }

    public static UUID getInvoiceId(List<InvoicePayment> invoicePayments, final Payment payment) {
        InvoicePayment invoicePayment = (InvoicePayment)Iterables.tryFind(invoicePayments, (Predicate)new Predicate<InvoicePayment>(){

            public boolean apply(InvoicePayment input) {
                return input.getPaymentId().equals(payment.getId()) && input.getType() == InvoicePaymentType.ATTEMPT;
            }
        }).orNull();
        return invoicePayment != null ? invoicePayment.getInvoiceId() : null;
    }

    protected void verifyNonNullOrEmpty(Object ... elements) {
        Preconditions.checkArgument((elements.length % 2 == 0 ? 1 : 0) != 0, (String)"%s should have an even number of elements", (Object)Arrays.toString(elements));
        for (int i = 0; i < elements.length; i += 2) {
            Object argument = elements[i];
            Object errorMessage = elements[i + 1];
            boolean expression = argument instanceof String ? Strings.emptyToNull((String)((String)argument)) != null : argument != null;
            Preconditions.checkArgument((boolean)expression, (Object)errorMessage);
        }
    }

    protected void verifyNonNull(Object ... elements) {
        Preconditions.checkArgument((elements.length % 2 == 0 ? 1 : 0) != 0, (String)"%s should have an even number of elements", (Object)Arrays.toString(elements));
        for (int i = 0; i < elements.length; i += 2) {
            Object argument = elements[i];
            Object errorMessage = elements[i + 1];
            boolean expression = argument != null;
            Preconditions.checkArgument((boolean)expression, (Object)errorMessage);
        }
    }

    protected Response createPaymentResponse(UriInfo uriInfo, Payment payment, TransactionType transactionType, @Nullable String transactionExternalKey, HttpServletRequest request) {
        BillingExceptionJson exception;
        Response.ResponseBuilder responseBuilder;
        PaymentTransaction createdTransaction = this.findCreatedTransaction(payment, transactionType, transactionExternalKey);
        Preconditions.checkNotNull((Object)createdTransaction, (String)"No transaction of type '%s' found", (Object)transactionType);
        switch (createdTransaction.getTransactionStatus()) {
            case PENDING: 
            case SUCCESS: {
                return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", payment.getId(), (ServletRequest)request);
            }
            case PAYMENT_FAILURE: {
                responseBuilder = Response.status((int)402);
                exception = this.createBillingException(String.format("Payment decline by gateway. Error message: %s", createdTransaction.getGatewayErrorMsg()));
                break;
            }
            case PAYMENT_SYSTEM_OFF: {
                responseBuilder = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE);
                exception = this.createBillingException("Payment system is off.");
                break;
            }
            case UNKNOWN: {
                responseBuilder = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE);
                exception = this.createBillingException("Payment in unknown status, failed to receive gateway response.");
                break;
            }
            case PLUGIN_FAILURE: {
                responseBuilder = Response.status((int)502);
                exception = this.createBillingException("Failed to submit payment transaction");
                break;
            }
            default: {
                responseBuilder = Response.serverError();
                exception = this.createBillingException("This should never have happened!!!");
            }
        }
        this.addExceptionToResponse(responseBuilder, exception);
        return this.uriBuilder.buildResponse(responseBuilder, uriInfo, PaymentResource.class, "getPayment", payment.getId(), (ServletRequest)request);
    }

    private void addExceptionToResponse(Response.ResponseBuilder responseBuilder, BillingExceptionJson exception) {
        try {
            responseBuilder.entity((Object)mapper.writeValueAsString((Object)exception)).type("application/json");
        }
        catch (JsonProcessingException e) {
            log.warn("Unable to serialize exception", (Object)exception);
            responseBuilder.entity((Object)e.toString()).type(MediaType.TEXT_PLAIN_TYPE);
        }
    }

    private BillingExceptionJson createBillingException(String message) {
        BillingExceptionJson exception = new BillingExceptionJson(PaymentApiException.class.getName(), null, message, null, null, Collections.emptyList());
        return exception;
    }

    private PaymentTransaction findCreatedTransaction(Payment payment, final TransactionType transactionType, @Nullable String transactionExternalKey) {
        List reversedTransactions = Lists.reverse((List)payment.getTransactions());
        Iterable matchingTransactions = Iterables.filter((Iterable)reversedTransactions, (Predicate)new Predicate<PaymentTransaction>(){

            public boolean apply(PaymentTransaction input) {
                return input.getTransactionType() == transactionType;
            }
        });
        if (transactionExternalKey != null) {
            for (PaymentTransaction transaction : matchingTransactions) {
                if (!transactionExternalKey.equals(transaction.getExternalKey())) continue;
                return transaction;
            }
        }
        return (PaymentTransaction)Iterables.getFirst((Iterable)matchingTransactions, null);
    }

    protected List<AuditLogJson> getAuditLogsWithHistory(List<AuditLogWithHistory> auditLogWithHistory) {
        return ImmutableList.copyOf((Collection)Collections2.transform(auditLogWithHistory, (Function)new Function<AuditLogWithHistory, AuditLogJson>(){

            public AuditLogJson apply(@Nullable AuditLogWithHistory input) {
                return new AuditLogJson(input);
            }
        }));
    }

    public static void filterCatalogVersions(VersionedCatalog fullCatalog, @Nullable DateTime requestedDate) {
        if (requestedDate == null) {
            return;
        }
        StaticCatalog target = fullCatalog.getVersion(requestedDate.toDate());
        fullCatalog.getVersions().clear();
        fullCatalog.getVersions().add(target);
    }
}

