/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.invoice.api.DryRunType;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.InvoiceDryRunJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.json.InvoiceJson;
import org.killbill.billing.jaxrs.json.InvoicePaymentJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.InvoicePaymentResource;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.resources.SubscriptionResourceHelpers;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.tenant.api.TenantApiException;
import org.killbill.billing.tenant.api.TenantKV;
import org.killbill.billing.tenant.api.TenantUserApi;
import org.killbill.billing.util.LocaleUtils;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/1.0/kb/invoices")
@Api(value="/1.0/kb/invoices", description="Operations on invoices", tags={"Invoice"})
public class InvoiceResource
extends JaxRsResourceBase {
    private static final Logger log = LoggerFactory.getLogger(InvoiceResource.class);
    private static final String ID_PARAM_NAME = "invoiceId";
    private static final String LOCALE_PARAM_NAME = "locale";
    private final InvoiceUserApi invoiceApi;
    private final TenantUserApi tenantApi;
    private final Locale defaultLocale;
    private static final Ordering<InvoicePaymentJson> INVOICE_PAYMENT_ORDERING = Ordering.from((Comparator)new Comparator<InvoicePaymentJson>(){

        @Override
        public int compare(InvoicePaymentJson o1, InvoicePaymentJson o2) {
            return o1.getTransactions().get(0).getEffectiveDate().compareTo((ReadableInstant)o2.getTransactions().get(0).getEffectiveDate());
        }
    });

    @Inject
    public InvoiceResource(AccountUserApi accountUserApi, InvoiceUserApi invoiceApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, Clock clock, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, TenantUserApi tenantApi, Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
        this.invoiceApi = invoiceApi;
        this.tenantApi = tenantApi;
        this.defaultLocale = Locale.getDefault();
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve an invoice by id", response=InvoiceJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied"), @ApiResponse(code=404, message="Invoice not found")})
    public Response getInvoice(@PathParam(value="invoiceId") UUID invoiceId, @QueryParam(value="withChildrenItems") @DefaultValue(value="false") boolean withChildrenItems, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoice(invoiceId, tenantContext);
        if (invoice == null) {
            throw new InvoiceApiException(ErrorCode.INVOICE_NOT_FOUND, new Object[]{invoiceId});
        }
        List childInvoiceItems = withChildrenItems ? this.invoiceApi.getInvoiceItemsByParentInvoice(invoice.getId(), tenantContext) : null;
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext);
        InvoiceJson json = new InvoiceJson(invoice, childInvoiceItems, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve invoice audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Invoice not found")})
    public Response getInvoiceAuditLogsWithHistory(@PathParam(value="invoiceId") UUID invoiceId, @javax.ws.rs.core.Context HttpServletRequest request) {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.invoiceApi.getInvoiceAuditLogsWithHistoryForId(invoiceId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @TimedResource
    @GET
    @Path(value="/byNumber/{invoiceNumber:[0-9]+}/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve an invoice by number", response=InvoiceJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Invoice not found")})
    public Response getInvoiceByNumber(@PathParam(value="invoiceNumber") Integer invoiceNumber, @QueryParam(value="withChildrenItems") @DefaultValue(value="false") boolean withChildrenItems, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoiceByNumber(invoiceNumber, tenantContext);
        List childInvoiceItems = withChildrenItems ? this.invoiceApi.getInvoiceItemsByParentInvoice(invoice.getId(), tenantContext) : null;
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext);
        InvoiceJson json = new InvoiceJson(invoice, childInvoiceItems, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Path(value="/byItemId/{itemId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve an invoice by invoice item id", response=InvoiceJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Invoice not found")})
    public Response getInvoiceByItemId(@PathParam(value="itemId") UUID invoiceItemId, @QueryParam(value="withChildrenItems") @DefaultValue(value="false") boolean withChildrenItems, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoiceByInvoiceItem(invoiceItemId, tenantContext);
        List childInvoiceItems = withChildrenItems ? this.invoiceApi.getInvoiceItemsByParentInvoice(invoice.getId(), tenantContext) : null;
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext);
        InvoiceJson json = new InvoiceJson(invoice, childInvoiceItems, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/html")
    @Produces(value={"text/html"})
    @ApiOperation(value="Render an invoice as HTML", response=String.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Invoice not found")})
    public Response getInvoiceAsHTML(@PathParam(value="invoiceId") UUID invoiceId, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException, IOException, AccountApiException {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.invoiceApi.getInvoiceAsHTML(invoiceId, this.context.createTenantContextNoAccountId((ServletRequest)request))).build();
    }

    @TimedResource
    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    @ApiOperation(value="List invoices", response=InvoiceJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getInvoices(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException {
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination invoices = this.invoiceApi.getInvoices(offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(InvoiceResource.class, "getInvoices", invoices.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(invoices, new Function<Invoice, InvoiceJson>(){

            public InvoiceJson apply(Invoice invoice) {
                if (((Map)accountsAuditLogs.get()).get(invoice.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(invoice.getAccountId(), InvoiceResource.this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                return new InvoiceJson(invoice, null, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(invoice.getAccountId()));
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search invoices", response=InvoiceJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchInvoices(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws SubscriptionApiException {
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination invoices = this.invoiceApi.searchInvoices(searchKey, offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(InvoiceResource.class, "searchInvoices", invoices.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(invoices, new Function<Invoice, InvoiceJson>(){

            public InvoiceJson apply(Invoice invoice) {
                if (((Map)accountsAuditLogs.get()).get(invoice.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(invoice.getAccountId(), InvoiceResource.this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                return new InvoiceJson(invoice, null, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(invoice.getAccountId()));
            }
        }, nextPageUri);
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Trigger an invoice generation", response=InvoiceJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Created invoice successfully"), @ApiResponse(code=400, message="Invalid account id or target datetime supplied")})
    public Response createFutureInvoice(@ApiParam(required=true) @QueryParam(value="accountId") UUID accountId, @QueryParam(value="targetDate") String targetDate, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        LocalDate inputDate = this.toLocalDate(targetDate);
        try {
            Invoice generatedInvoice = this.invoiceApi.triggerInvoiceGeneration(accountId, inputDate, callContext);
            return this.uriBuilder.buildResponse(uriInfo, InvoiceResource.class, "getInvoice", generatedInvoice.getId(), (ServletRequest)request);
        }
        catch (InvoiceApiException e) {
            if (e.getCode() == ErrorCode.INVOICE_NOTHING_TO_DO.getCode()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            throw e;
        }
    }

    @TimedResource
    @POST
    @Path(value="/migration/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a migration invoice", response=InvoiceJson.class, tags={"Invoice"})
    @ApiResponses(value={@ApiResponse(code=201, message="Created migration invoice successfully"), @ApiResponse(code=400, message="Invalid account id or target datetime supplied")})
    public Response createMigrationInvoice(@PathParam(value="accountId") UUID accountId, List<InvoiceItemJson> items, @Nullable @QueryParam(value="targetDate") String targetDate, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        Iterable<InvoiceItem> sanitizedInvoiceItems = this.validateSanitizeAndTranformInputItems(account.getCurrency(), items);
        LocalDate resolvedTargetDate = this.toLocalDateDefaultToday(account, targetDate, (TenantContext)callContext);
        UUID invoiceId = this.invoiceApi.createMigrationInvoice(accountId, resolvedTargetDate, sanitizedInvoiceItems, callContext);
        return this.uriBuilder.buildResponse(uriInfo, InvoiceResource.class, "getInvoice", invoiceId, (ServletRequest)request);
    }

    @TimedResource
    @POST
    @Path(value="/dryRun")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Generate a dryRun invoice", response=InvoiceJson.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Nothing to generate"), @ApiResponse(code=400, message="Invalid account id or target datetime supplied")})
    public Response generateDryRunInvoice(@Nullable InvoiceDryRunJson dryRunSubscriptionSpec, @ApiParam(required=true) @QueryParam(value="accountId") UUID accountId, @Nullable @QueryParam(value="targetDate") String targetDate, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        Object inputDate = dryRunSubscriptionSpec != null ? (DryRunType.UPCOMING_INVOICE.equals((Object)dryRunSubscriptionSpec.getDryRunType()) ? null : (DryRunType.SUBSCRIPTION_ACTION.equals((Object)dryRunSubscriptionSpec.getDryRunType()) && dryRunSubscriptionSpec.getEffectiveDate() != null ? dryRunSubscriptionSpec.getEffectiveDate() : this.toLocalDate(targetDate))) : this.toLocalDate(targetDate);
        if (dryRunSubscriptionSpec != null && dryRunSubscriptionSpec.getDryRunAction() != null) {
            if (SubscriptionEventType.START_BILLING.equals((Object)dryRunSubscriptionSpec.getDryRunAction())) {
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getProductName(), "DryRun subscription product category should be specified");
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getBillingPeriod(), "DryRun subscription billingPeriod should be specified");
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getProductCategory(), "DryRun subscription product category should be specified");
                if (dryRunSubscriptionSpec.getProductCategory().equals((Object)ProductCategory.ADD_ON)) {
                    this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getBundleId(), "DryRun bundle ID should be specified");
                }
            } else if (SubscriptionEventType.CHANGE.equals((Object)dryRunSubscriptionSpec.getDryRunAction())) {
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getProductName(), "DryRun subscription product category should be specified");
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getBillingPeriod(), "DryRun subscription billingPeriod should be specified");
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getSubscriptionId(), "DryRun subscriptionID should be specified");
            } else if (SubscriptionEventType.STOP_BILLING.equals((Object)dryRunSubscriptionSpec.getDryRunAction())) {
                this.verifyNonNullOrEmpty(dryRunSubscriptionSpec.getSubscriptionId(), "DryRun subscriptionID should be specified");
            }
        }
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        DefaultDryRunArguments dryRunArguments = new DefaultDryRunArguments(dryRunSubscriptionSpec, account);
        try {
            Invoice generatedInvoice = this.invoiceApi.triggerDryRunInvoiceGeneration(accountId, inputDate, (DryRunArguments)dryRunArguments, callContext);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new InvoiceJson(generatedInvoice, null, null)).build();
        }
        catch (InvoiceApiException e) {
            if (e.getCode() == ErrorCode.INVOICE_NOTHING_TO_DO.getCode()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            throw e;
        }
    }

    @TimedResource
    @DELETE
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/{invoiceItemId:\\w+-\\w+-\\w+-\\w+-\\w+}/cba")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a CBA item")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account id, invoice id or invoice item id supplied"), @ApiResponse(code=404, message="Account or invoice not found")})
    public Response deleteCBA(@PathParam(value="invoiceId") UUID invoiceId, @PathParam(value="invoiceItemId") UUID invoiceItemId, @ApiParam(required=true) @QueryParam(value="accountId") UUID accountId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, InvoiceApiException {
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        this.invoiceApi.deleteCBA(account.getId(), invoiceId, invoiceItemId, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @POST
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Adjust an invoice item", response=InvoiceJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Created adjustment Successfully"), @ApiResponse(code=400, message="Invalid account id, invoice id or invoice item id supplied"), @ApiResponse(code=404, message="Invoice not found")})
    public Response adjustInvoiceItem(@PathParam(value="invoiceId") UUID invoiceId, InvoiceItemJson json, @QueryParam(value="requestedDate") String requestedDateTimeString, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        this.verifyNonNullOrEmpty(json, "InvoiceItemJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAccountId(), "InvoiceItemJson accountId needs to be set", json.getInvoiceItemId(), "InvoiceItemJson invoiceItemId needs to be set");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        UUID accountId = json.getAccountId();
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        LocalDate requestedDate = this.toLocalDateDefaultToday(accountId, requestedDateTimeString, (TenantContext)callContext);
        InvoiceItem adjustmentItem = json.getAmount() == null ? this.invoiceApi.insertInvoiceItemAdjustment(accountId, invoiceId, json.getInvoiceItemId(), requestedDate, json.getDescription(), json.getItemDetails(), pluginProperties, callContext) : this.invoiceApi.insertInvoiceItemAdjustment(accountId, invoiceId, json.getInvoiceItemId(), requestedDate, json.getAmount(), json.getCurrency(), json.getDescription(), json.getItemDetails(), pluginProperties, callContext);
        if (adjustmentItem == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.uriBuilder.buildResponse(uriInfo, InvoiceResource.class, "getInvoice", adjustmentItem.getInvoiceId(), (ServletRequest)request);
    }

    @TimedResource
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/charges/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @ApiOperation(value="Create external charge(s)", response=InvoiceItemJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Created external charge Successfully"), @ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response createExternalCharges(@PathParam(value="accountId") UUID accountId, List<InvoiceItemJson> externalChargesJson, @QueryParam(value="requestedDate") String requestedDateTimeString, @QueryParam(value="autoCommit") @DefaultValue(value="false") Boolean autoCommit, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, InvoiceApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        Iterable<InvoiceItem> sanitizedExternalChargesJson = this.validateSanitizeAndTranformInputItems(account.getCurrency(), externalChargesJson);
        LocalDate requestedDate = this.toLocalDateDefaultToday(account, requestedDateTimeString, (TenantContext)callContext);
        List createdExternalCharges = this.invoiceApi.insertExternalCharges(account.getId(), requestedDate, sanitizedExternalChargesJson, autoCommit.booleanValue(), pluginProperties, callContext);
        List createdExternalChargesJson = Lists.transform((List)createdExternalCharges, (Function)new Function<InvoiceItem, InvoiceItemJson>(){

            public InvoiceItemJson apply(InvoiceItem input) {
                return new InvoiceItemJson(input);
            }
        });
        return Response.status((Response.Status)Response.Status.OK).entity((Object)createdExternalChargesJson).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/taxes/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @ApiOperation(value="Create tax items", response=InvoiceItemJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Create tax items successfully"), @ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response createTaxItems(@PathParam(value="accountId") UUID accountId, List<InvoiceItemJson> taxItemJson, @QueryParam(value="autoCommit") @DefaultValue(value="false") Boolean autoCommit, @QueryParam(value="requestedDate") String requestedDateTimeString, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        this.verifyNonNullOrEmpty(taxItemJson, "Body should be specified");
        this.verifyNonNullOrEmpty(accountId, "AccountId needs to be set");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        Iterable<InvoiceItem> sanitizedTaxItemsJson = this.validateSanitizeAndTranformInputItems(account.getCurrency(), taxItemJson);
        LocalDate requestedDate = this.toLocalDateDefaultToday(account, requestedDateTimeString, (TenantContext)callContext);
        List createdTaxItems = this.invoiceApi.insertTaxItems(account.getId(), requestedDate, sanitizedTaxItemsJson, autoCommit.booleanValue(), pluginProperties, callContext);
        List createdTaxItemJson = Lists.transform((List)createdTaxItems, (Function)new Function<InvoiceItem, InvoiceItemJson>(){

            public InvoiceItemJson apply(InvoiceItem input) {
                return new InvoiceItemJson(input);
            }
        });
        return Response.status((Response.Status)Response.Status.OK).entity((Object)createdTaxItemJson).build();
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payments associated with an invoice", response=InvoicePaymentJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied"), @ApiResponse(code=404, message="Invoice not found")})
    public Response getPaymentsForInvoice(@PathParam(value="invoiceId") UUID invoiceId, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="withAttempts") @DefaultValue(value="false") Boolean withAttempts, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws PaymentApiException, InvoiceApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        final Invoice invoice = this.invoiceApi.getInvoice(invoiceId, tenantContext);
        ImmutableSet invoicePaymentIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)invoice.getPayments(), (Function)new Function<InvoicePayment, UUID>(){

            public UUID apply(InvoicePayment input) {
                return input.getPaymentId();
            }
        }));
        if (invoicePaymentIds.isEmpty()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ImmutableList.of()).build();
        }
        ArrayList<Payment> payments = new ArrayList<Payment>();
        for (UUID paymentId : invoicePaymentIds) {
            Payment payment = this.paymentApi.getPayment(paymentId, withPluginInfo.booleanValue(), withAttempts.booleanValue(), (Iterable)ImmutableList.of(), tenantContext);
            payments.add(payment);
        }
        List result = INVOICE_PAYMENT_ORDERING.sortedCopy(Iterables.transform(payments, (Function)new Function<Payment, InvoicePaymentJson>(){

            public InvoicePaymentJson apply(Payment input) {
                return new InvoicePaymentJson(input, invoice.getId(), null);
            }
        }));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    @ApiOperation(value="Trigger a payment for invoice", response=InvoicePaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Created payment Successfully"), @ApiResponse(code=204, message="Nothing to pay for"), @ApiResponse(code=400, message="Invalid account id or invoice id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response createInstantPayment(@PathParam(value="invoiceId") UUID invoiceId, InvoicePaymentJson payment, @QueryParam(value="externalPayment") @DefaultValue(value="false") Boolean externalPayment, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException, PaymentApiException {
        this.verifyNonNullOrEmpty(payment, "InvoicePaymentJson body should be specified");
        this.verifyNonNullOrEmpty(payment.getAccountId(), "InvoicePaymentJson accountId needs to be set");
        Preconditions.checkArgument((externalPayment == false || payment.getPaymentMethodId() == null ? 1 : 0) != 0, (Object)"InvoicePaymentJson should not contain a paymentMethodId when this is an external payment");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(payment.getAccountId(), (TenantContext)callContext);
        UUID paymentMethodId = externalPayment != false ? null : (payment.getPaymentMethodId() != null ? payment.getPaymentMethodId() : account.getPaymentMethodId());
        InvoicePayment result = this.createPurchaseForInvoice(account, invoiceId, payment.getPurchasedAmount(), paymentMethodId, externalPayment, payment.getPaymentExternalKey(), null, pluginProperties, callContext);
        return result != null ? this.uriBuilder.buildResponse(uriInfo, InvoicePaymentResource.class, "getInvoicePayment", result.getPaymentId(), (ServletRequest)request) : Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @GET
    @Path(value="/translation/{locale:.*}/")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Retrieves the invoice translation for the tenant", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid locale supplied"), @ApiResponse(code=404, message="Translation not found")})
    public Response getInvoiceTranslation(@PathParam(value="locale") String localeStr, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException, TenantApiException {
        return this.getTemplateResource(localeStr, TenantKV.TenantKey.INVOICE_TRANSLATION_, request);
    }

    @TimedResource
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Path(value="/translation/{locale:.*}/")
    @ApiOperation(value="Upload the invoice translation for the tenant", response=String.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Uploaded invoice translation Successfully")})
    public Response uploadInvoiceTranslation(@PathParam(value="locale") String localeStr, String invoiceTranslation, @QueryParam(value="deleteIfExists") @DefaultValue(value="false") boolean deleteIfExists, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws Exception {
        return this.uploadTemplateResource(invoiceTranslation, localeStr, deleteIfExists, TenantKV.TenantKey.INVOICE_TRANSLATION_, "getInvoiceTranslation", createdBy, reason, comment, request, uriInfo);
    }

    @TimedResource
    @GET
    @Path(value="/catalogTranslation/{locale:.*}/")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Retrieves the catalog translation for the tenant", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid locale supplied"), @ApiResponse(code=404, message="Template not found")})
    public Response getCatalogTranslation(@PathParam(value="locale") String localeStr, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException, TenantApiException {
        return this.getTemplateResource(localeStr, TenantKV.TenantKey.CATALOG_TRANSLATION_, request);
    }

    @TimedResource
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Path(value="/catalogTranslation/{locale:.*}/")
    @ApiOperation(value="Upload the catalog translation for the tenant", response=String.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Uploaded catalog translation Successfully")})
    public Response uploadCatalogTranslation(@PathParam(value="locale") String localeStr, String catalogTranslation, @QueryParam(value="deleteIfExists") @DefaultValue(value="false") boolean deleteIfExists, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws Exception {
        return this.uploadTemplateResource(catalogTranslation, localeStr, deleteIfExists, TenantKV.TenantKey.CATALOG_TRANSLATION_, "getCatalogTranslation", createdBy, reason, comment, request, uriInfo);
    }

    @TimedResource
    @GET
    @Path(value="/template")
    @Produces(value={"text/html"})
    @ApiOperation(value="Retrieves the invoice template for the tenant", response=String.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Template not found")})
    public Response getInvoiceTemplate(@javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException, TenantApiException {
        return this.getTemplateResource(null, TenantKV.TenantKey.INVOICE_TEMPLATE, request);
    }

    @TimedResource
    @POST
    @Produces(value={"text/html"})
    @Consumes(value={"text/html"})
    @Path(value="/template")
    @ApiOperation(value="Upload the invoice template for the tenant", response=String.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Uploaded invoice template Successfully")})
    public Response uploadInvoiceTemplate(String catalogTranslation, @QueryParam(value="deleteIfExists") @DefaultValue(value="false") boolean deleteIfExists, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws Exception {
        return this.uploadTemplateResource(catalogTranslation, null, deleteIfExists, TenantKV.TenantKey.INVOICE_TEMPLATE, "getInvoiceTemplate", createdBy, reason, comment, request, uriInfo);
    }

    @TimedResource
    @GET
    @Path(value="/manualPayTemplate/{locale:.*}/")
    @Produces(value={"text/html"})
    @ApiOperation(value="Retrieves the manualPay invoice template for the tenant", response=String.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Template not found")})
    public Response getInvoiceMPTemplate(@PathParam(value="locale") String localeStr, @javax.ws.rs.core.Context HttpServletRequest request) throws InvoiceApiException, TenantApiException {
        return this.getTemplateResource(null, TenantKV.TenantKey.INVOICE_MP_TEMPLATE, request);
    }

    @TimedResource
    @POST
    @Produces(value={"text/html"})
    @Consumes(value={"text/html"})
    @Path(value="/manualPayTemplate")
    @ApiOperation(value="Upload the manualPay invoice template for the tenant", response=String.class)
    public Response uploadInvoiceMPTemplate(String catalogTranslation, @QueryParam(value="deleteIfExists") @DefaultValue(value="false") boolean deleteIfExists, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws Exception {
        return this.uploadTemplateResource(catalogTranslation, null, deleteIfExists, TenantKV.TenantKey.INVOICE_MP_TEMPLATE, "getInvoiceMPTemplate", createdBy, reason, comment, request, uriInfo);
    }

    private Response uploadTemplateResource(String templateResource, @Nullable String localeStr, boolean deleteIfExists, TenantKV.TenantKey tenantKey, String getMethodStr, String createdBy, String reason, String comment, HttpServletRequest request, UriInfo uriInfo) throws Exception {
        String tenantKeyStr;
        if (localeStr != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(templateResource.getBytes());
            new PropertyResourceBundle(stream);
            Locale locale = localeStr != null ? LocaleUtils.toLocale((String)localeStr) : this.defaultLocale;
            tenantKeyStr = LocaleUtils.localeString((Locale)locale, (String)tenantKey.toString());
        } else {
            tenantKeyStr = tenantKey.toString();
        }
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        if (!this.tenantApi.getTenantValuesForKey(tenantKeyStr, (TenantContext)callContext).isEmpty()) {
            if (deleteIfExists) {
                this.tenantApi.deleteTenantKey(tenantKeyStr, callContext);
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        this.tenantApi.addTenantKeyValue(tenantKeyStr, templateResource, callContext);
        return this.uriBuilder.buildResponse(uriInfo, InvoiceResource.class, getMethodStr, localeStr, (ServletRequest)request);
    }

    private Response getTemplateResource(@Nullable String localeStr, TenantKV.TenantKey tenantKey, HttpServletRequest request) throws InvoiceApiException, TenantApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        String tenantKeyStr = localeStr != null ? LocaleUtils.localeString((Locale)LocaleUtils.toLocale((String)localeStr), (String)tenantKey.toString()) : tenantKey.toString();
        List result = this.tenantApi.getTenantValuesForKey(tenantKeyStr, tenantContext);
        return result.isEmpty() ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.status((Response.Status)Response.Status.OK).entity(result.get(0)).build();
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve invoice custom fields", response=CustomFieldJson.class, responseContainer="List", nickname="getInvoiceCustomFields")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied")})
    public Response getCustomFields(@PathParam(value="invoiceId") UUID id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) {
        return super.getCustomFields(id, auditMode, this.context.createTenantContextNoAccountId((ServletRequest)request));
    }

    @TimedResource
    @POST
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to invoice", response=CustomField.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Custom field created successfully"), @ApiResponse(code=400, message="Invalid invoice id supplied")})
    public Response createInvoiceCustomFields(@PathParam(value="invoiceId") UUID id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(id, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), uriInfo, request);
    }

    @TimedResource
    @PUT
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Modify custom fields to invoice")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid invoice id supplied")})
    public Response modifyInvoiceCustomFields(@PathParam(value="invoiceId") UUID id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws CustomFieldApiException {
        return super.modifyCustomFields(id, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @DELETE
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from invoice")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid invoice id supplied")})
    public Response deleteInvoiceCustomFields(@PathParam(value="invoiceId") UUID id, @QueryParam(value="customField") List<UUID> customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(id, customFieldList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve invoice tags", response=TagJson.class, responseContainer="List", nickname="getInvoiceTags")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice id supplied"), @ApiResponse(code=404, message="Invoice not found")})
    public Response getTags(@PathParam(value="invoiceId") UUID invoiceId, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws TagDefinitionApiException, InvoiceApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoice(invoiceId, tenantContext);
        return super.getTags(invoice.getAccountId(), invoiceId, auditMode, includedDeleted, tenantContext);
    }

    @TimedResource
    @POST
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add tags to invoice", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Tag created successfully"), @ApiResponse(code=400, message="Invalid invoice id supplied")})
    public Response createInvoiceTags(@PathParam(value="invoiceId") UUID id, List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws TagApiException {
        return super.createTags(id, tagList, uriInfo, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), request);
    }

    @TimedResource
    @DELETE
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove tags from invoice")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid invoice id supplied")})
    public Response deleteInvoiceTags(@PathParam(value="invoiceId") UUID id, @QueryParam(value="tagDef") List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(id, tagList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @PUT
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/commitInvoice")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Perform the invoice status transition from DRAFT to COMMITTED")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=404, message="Invoice not found")})
    public Response commitInvoice(@PathParam(value="invoiceId") UUID invoiceId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws InvoiceApiException {
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        this.invoiceApi.commitInvoice(invoiceId, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @PUT
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/voidInvoice")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Perform the action of voiding an invoice")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid invoice id supplied"), @ApiResponse(code=404, message="Invoice not found")})
    public Response voidInvoice(@PathParam(value="invoiceId") UUID invoiceId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws InvoiceApiException {
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        this.invoiceApi.voidInvoice(invoiceId, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.INVOICE;
    }

    private static class DefaultDryRunArguments
    implements DryRunArguments {
        private final DryRunType dryRunType;
        private final SubscriptionEventType action;
        private final UUID subscriptionId;
        private final LocalDate effectiveDate;
        private final EntitlementSpecifier specifier;
        private final UUID bundleId;
        private final BillingActionPolicy billingPolicy;

        public DefaultDryRunArguments(InvoiceDryRunJson input, Account account) {
            if (input == null) {
                this.dryRunType = DryRunType.TARGET_DATE;
                this.action = null;
                this.subscriptionId = null;
                this.effectiveDate = null;
                this.specifier = null;
                this.bundleId = null;
                this.billingPolicy = null;
            } else {
                this.dryRunType = input.getDryRunType() != null ? input.getDryRunType() : DryRunType.TARGET_DATE;
                this.action = input.getDryRunAction() != null ? input.getDryRunAction() : null;
                this.subscriptionId = input.getSubscriptionId();
                this.bundleId = input.getBundleId();
                this.effectiveDate = input.getEffectiveDate();
                BillingActionPolicy billingActionPolicy = this.billingPolicy = input.getBillingPolicy() != null ? input.getBillingPolicy() : null;
                final PlanPhaseSpecifier planPhaseSpecifier = input.getProductName() != null && input.getProductCategory() != null && input.getBillingPeriod() != null ? new PlanPhaseSpecifier(input.getProductName(), input.getBillingPeriod(), input.getPriceListName(), input.getPhaseType() != null ? input.getPhaseType() : null) : null;
                final List<PlanPhasePriceOverride> overrides = SubscriptionResourceHelpers.buildPlanPhasePriceOverrides(input.getPriceOverrides(), account.getCurrency(), planPhaseSpecifier);
                this.specifier = new EntitlementSpecifier(){

                    public PlanPhaseSpecifier getPlanPhaseSpecifier() {
                        return planPhaseSpecifier;
                    }

                    public Integer getBillCycleDay() {
                        return null;
                    }

                    public String getExternalKey() {
                        return null;
                    }

                    public List<PlanPhasePriceOverride> getOverrides() {
                        return overrides;
                    }
                };
            }
        }

        public DryRunType getDryRunType() {
            return this.dryRunType;
        }

        public EntitlementSpecifier getEntitlementSpecifier() {
            return this.specifier;
        }

        public SubscriptionEventType getAction() {
            return this.action;
        }

        public UUID getSubscriptionId() {
            return this.subscriptionId;
        }

        public LocalDate getEffectiveDate() {
            return this.effectiveDate;
        }

        public UUID getBundleId() {
            return this.bundleId;
        }

        public BillingActionPolicy getBillingActionPolicy() {
            return this.billingPolicy;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("DefaultDryRunArguments{");
            sb.append("dryRunType=").append(this.dryRunType);
            sb.append(", action=").append(this.action);
            sb.append(", subscriptionId=").append(this.subscriptionId);
            sb.append(", effectiveDate=").append(this.effectiveDate);
            sb.append(", specifier=").append(this.specifier);
            sb.append(", bundleId=").append(this.bundleId);
            sb.append(", billingPolicy=").append(this.billingPolicy);
            sb.append('}');
            return sb.toString();
        }
    }
}

