/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentType;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.json.InvoicePaymentJson;
import org.killbill.billing.jaxrs.json.InvoicePaymentTransactionJson;
import org.killbill.billing.jaxrs.json.PaymentTransactionJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentOptions;
import org.killbill.billing.payment.api.PaymentTransaction;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.api.TransactionStatus;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Path(value="/1.0/kb/invoicePayments")
@Api(value="/1.0/kb/invoicePayments", description="Operations on invoice payments", tags={"InvoicePayment"})
public class InvoicePaymentResource
extends JaxRsResourceBase {
    private static final String ID_PARAM_NAME = "paymentId";
    private final InvoicePaymentApi invoicePaymentApi;
    private final InvoiceUserApi invoiceApi;

    @Inject
    public InvoicePaymentResource(AccountUserApi accountUserApi, PaymentApi paymentApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, InvoicePaymentApi invoicePaymentApi, InvoiceUserApi invoiceApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
        this.invoicePaymentApi = invoicePaymentApi;
        this.invoiceApi = invoiceApi;
    }

    @TimedResource
    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a payment by id", response=InvoicePaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied"), @ApiResponse(code=404, message="Payment not found")})
    public Response getInvoicePayment(@PathParam(value="paymentId") UUID paymentId, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="withAttempts") @DefaultValue(value="false") Boolean withAttempts, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentId, withPluginInfo.booleanValue(), withAttempts.booleanValue(), pluginProperties, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext);
        List invoicePayments = this.invoicePaymentApi.getInvoicePayments(paymentId, tenantContext);
        InvoicePayment invoicePayment = (InvoicePayment)Iterables.tryFind((Iterable)invoicePayments, (Predicate)new Predicate<InvoicePayment>(){

            public boolean apply(InvoicePayment input) {
                return input.getType() == InvoicePaymentType.ATTEMPT;
            }
        }).orNull();
        UUID invoiceId = invoicePayment != null ? invoicePayment.getInvoiceId() : null;
        InvoicePaymentJson result = new InvoicePaymentJson(payment, invoiceId, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @GET
    @Path(value="/{invoicePaymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve invoice payment audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Invoice payment not found")})
    public Response getInvoicePaymentAuditLogsWithHistory(@PathParam(value="invoicePaymentId") UUID invoicePaymentId, @Context HttpServletRequest request) {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.invoiceApi.getInvoicePaymentAuditLogsWithHistoryForId(invoicePaymentId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @TimedResource
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/refunds")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Refund a payment, and adjust the invoice if needed", response=InvoicePaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Created refund successfully"), @ApiResponse(code=400, message="Invalid payment id supplied"), @ApiResponse(code=404, message="Account or payment not found")})
    public Response createRefundWithAdjustments(@PathParam(value="paymentId") UUID paymentId, InvoicePaymentTransactionJson json, @QueryParam(value="externalPayment") @DefaultValue(value="false") Boolean externalPayment, @QueryParam(value="paymentMethodId") UUID paymentMethodId, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        UUID paymentIdToRedirectTo;
        Iterable<PluginProperty> pluginProperties;
        this.verifyNonNullOrEmpty(json, "InvoicePaymentTransactionJson body should be specified");
        CallContext callContextNoAccountId = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentId, false, false, (Iterable)ImmutableList.of(), (TenantContext)callContextNoAccountId);
        Account account = this.accountUserApi.getAccountById(payment.getAccountId(), (TenantContext)callContextNoAccountId);
        CallContext callContext = this.context.createCallContextWithAccountId(account.getId(), createdBy, reason, comment, (ServletRequest)request);
        String transactionExternalKey = json.getTransactionExternalKey() != null ? json.getTransactionExternalKey() : UUIDs.randomUUID().toString();
        String paymentExternalKey = json.getPaymentExternalKey() != null ? json.getPaymentExternalKey() : UUIDs.randomUUID().toString();
        boolean isAdjusted = json.isAdjusted() != null && json.isAdjusted() != false;
        HashMap<UUID, BigDecimal> adjustments = new HashMap<UUID, BigDecimal>();
        if (isAdjusted) {
            if (json.getAdjustments() != null && !json.getAdjustments().isEmpty()) {
                for (InvoiceItemJson item : json.getAdjustments()) {
                    adjustments.put(item.getInvoiceItemId(), item.getAmount());
                }
                pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
            } else {
                pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
            }
        } else {
            pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        }
        if (externalPayment.booleanValue()) {
            this.invoicePaymentApi.createCreditForInvoicePayment(isAdjusted, adjustments, account, paymentId, paymentMethodId, null, json.getAmount(), account.getCurrency(), json.getEffectiveDate(), paymentExternalKey, transactionExternalKey, pluginProperties, this.createInvoicePaymentControlPluginApiPaymentOptions(true), callContext);
            paymentIdToRedirectTo = this.paymentApi.getPaymentByTransactionExternalKey(transactionExternalKey, false, false, (Iterable)ImmutableList.of(), (TenantContext)callContext).getId();
        } else {
            this.invoicePaymentApi.createRefundForInvoicePayment(isAdjusted, adjustments, account, payment.getId(), json.getAmount(), account.getCurrency(), json.getEffectiveDate(), transactionExternalKey, pluginProperties, this.createInvoicePaymentControlPluginApiPaymentOptions(false), callContext);
            paymentIdToRedirectTo = payment.getId();
        }
        return this.uriBuilder.buildResponse(uriInfo, InvoicePaymentResource.class, "getInvoicePayment", paymentIdToRedirectTo, (ServletRequest)request);
    }

    @TimedResource
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/chargebacks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Record a chargeback", response=InvoicePaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Created chargeback successfully"), @ApiResponse(code=400, message="Invalid payment id supplied"), @ApiResponse(code=404, message="Account or payment not found")})
    public Response createChargeback(@PathParam(value="paymentId") UUID paymentId, InvoicePaymentTransactionJson json, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "InvoicePaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAmount(), "InvoicePaymentTransactionJson amount needs to be set");
        CallContext callContextNoAccountId = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentId, false, false, (Iterable)ImmutableList.of(), (TenantContext)callContextNoAccountId);
        Account account = this.accountUserApi.getAccountById(payment.getAccountId(), (TenantContext)callContextNoAccountId);
        CallContext callContext = this.context.createCallContextWithAccountId(account.getId(), createdBy, reason, comment, (ServletRequest)request);
        String transactionExternalKey = json.getTransactionExternalKey() != null ? json.getTransactionExternalKey() : UUIDs.randomUUID().toString();
        this.invoicePaymentApi.createChargebackForInvoicePayment(account, payment.getId(), json.getAmount(), account.getCurrency(), json.getEffectiveDate(), transactionExternalKey, this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]), this.createInvoicePaymentControlPluginApiPaymentOptions(false), callContext);
        return this.uriBuilder.buildResponse(uriInfo, InvoicePaymentResource.class, "getInvoicePayment", payment.getId(), (ServletRequest)request);
    }

    @TimedResource
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/chargebackReversals")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Record a chargebackReversal", response=InvoicePaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Created chargeback reversal successfully"), @ApiResponse(code=400, message="Invalid payment id supplied"), @ApiResponse(code=404, message="Account or payment not found")})
    public Response createChargebackReversal(@PathParam(value="paymentId") UUID paymentId, InvoicePaymentTransactionJson json, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "InvoicePaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getTransactionExternalKey(), "InvoicePaymentTransactionJson transactionExternalKey needs to be set");
        CallContext callContextNoAccountId = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentId, false, false, (Iterable)ImmutableList.of(), (TenantContext)callContextNoAccountId);
        Account account = this.accountUserApi.getAccountById(payment.getAccountId(), (TenantContext)callContextNoAccountId);
        CallContext callContext = this.context.createCallContextWithAccountId(account.getId(), createdBy, reason, comment, (ServletRequest)request);
        this.invoicePaymentApi.createChargebackReversalForInvoicePayment(account, payment.getId(), json.getEffectiveDate(), json.getTransactionExternalKey(), this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]), this.createInvoicePaymentControlPluginApiPaymentOptions(false), callContext);
        return this.uriBuilder.buildResponse(uriInfo, InvoicePaymentResource.class, "getInvoicePayment", paymentId, (ServletRequest)request);
    }

    @TimedResource(name="completeInvoicePaymentTransaction")
    @PUT
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Complete an existing transaction")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid paymentId supplied"), @ApiResponse(code=404, message="Account or payment not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response completeInvoicePaymentTransaction(@PathParam(value="paymentId") UUID paymentId, PaymentTransactionJson json, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        UUID invoiceId;
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentId, false, false, (Iterable)ImmutableList.of(), tenantContext);
        List invoicePayments = this.invoicePaymentApi.getInvoicePayments(paymentId, tenantContext);
        InvoicePayment originalInvoicePaymentAttempt = (InvoicePayment)Iterables.tryFind((Iterable)invoicePayments, (Predicate)new Predicate<InvoicePayment>(){

            public boolean apply(InvoicePayment input) {
                return input.getType() == InvoicePaymentType.ATTEMPT && input.isSuccess() == false;
            }
        }).orNull();
        UUID uUID = invoiceId = originalInvoicePaymentAttempt != null ? originalInvoicePaymentAttempt.getInvoiceId() : null;
        if (invoiceId == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        ArrayList<String> controlPluginNames = new ArrayList<String>();
        controlPluginNames.addAll(paymentControlPluginNames);
        Account account = this.accountUserApi.getAccountById(payment.getAccountId(), tenantContext);
        BigDecimal amount = json == null ? null : json.getAmount();
        Currency currency = json == null ? null : json.getCurrency();
        CallContext callContext = this.context.createCallContextWithAccountId(account.getId(), createdBy, reason, comment, (ServletRequest)request);
        PaymentTransaction pendingOrSuccessTransaction = this.lookupPendingOrSuccessTransaction(payment, json != null ? json.getTransactionId() : null, json != null ? json.getTransactionExternalKey() : null, json != null ? json.getTransactionType() : null);
        if (pendingOrSuccessTransaction.getTransactionStatus() == TransactionStatus.SUCCESS) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        this.invoicePaymentApi.createPurchaseForInvoicePayment(account, invoiceId, payment.getPaymentMethodId(), payment.getId(), amount, currency, null, payment.getExternalKey(), pendingOrSuccessTransaction.getExternalKey(), pluginProperties, paymentOptions, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payment custom fields", response=CustomFieldJson.class, responseContainer="List", nickname="getInvoicePaymentCustomFields")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response getCustomFields(@PathParam(value="paymentId") UUID id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(id, auditMode, this.context.createTenantContextNoAccountId((ServletRequest)request));
    }

    @TimedResource
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to payment", response=CustomField.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Custom field created successfully"), @ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response createInvoicePaymentCustomFields(@PathParam(value="paymentId") UUID id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(id, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), uriInfo, request);
    }

    @TimedResource
    @PUT
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Modify custom fields to payment")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response modifyInvoicePaymentCustomFields(@PathParam(value="paymentId") UUID id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.modifyCustomFields(id, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @DELETE
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from payment")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response deleteInvoicePaymentCustomFields(@PathParam(value="paymentId") UUID id, @QueryParam(value="customField") List<UUID> customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(id, customFieldList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve payment tags", response=TagJson.class, responseContainer="List", nickname="getInvoicePaymentTags")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid payment id supplied"), @ApiResponse(code=404, message="Payment not found")})
    public Response getTags(@PathParam(value="paymentId") UUID paymentId, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws TagDefinitionApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentId, false, false, pluginProperties, tenantContext);
        return super.getTags(payment.getAccountId(), paymentId, auditMode, includedDeleted, tenantContext);
    }

    @TimedResource
    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add tags to payment", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Tag created successfully"), @ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response createInvoicePaymentTags(@PathParam(value="paymentId") UUID id, List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws TagApiException {
        return super.createTags(id, tagList, uriInfo, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), request);
    }

    @TimedResource
    @DELETE
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove tags from payment")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid payment id supplied")})
    public Response deleteInvoicePaymentTags(@PathParam(value="paymentId") UUID id, @QueryParam(value="tagDef") List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(id, tagList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.PAYMENT;
    }
}

