/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Path(value="/1.0/kb/invoiceItems")
@Api(value="/1.0/kb/invoiceItems", description="Operations on invoice items", tags={"InvoiceItem"})
public class InvoiceItemResource
extends JaxRsResourceBase {
    private static final String ID_PARAM_NAME = "invoiceItemId";
    private final InvoiceUserApi invoiceApi;

    @Inject
    public InvoiceItemResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, InvoiceUserApi invoiceApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, SubscriptionApi subscriptionApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, subscriptionApi, clock, context);
        this.invoiceApi = invoiceApi;
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceItemId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve invoice item audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Invoice item not found")})
    public Response getInvoiceItemAuditLogsWithHistory(@PathParam(value="invoiceItemId") UUID invoiceItemId, @Context HttpServletRequest request) {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.invoiceApi.getInvoiceItemAuditLogsWithHistoryForId(invoiceItemId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceItemId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve invoice item custom fields", response=CustomFieldJson.class, responseContainer="List", nickname="getInvoiceItemCustomFields")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice item id supplied")})
    public Response getCustomFields(@PathParam(value="invoiceItemId") UUID id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(id, auditMode, this.context.createTenantContextNoAccountId((ServletRequest)request));
    }

    @TimedResource
    @POST
    @Path(value="/{invoiceItemId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to invoice item", response=CustomField.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Custom field created successfully"), @ApiResponse(code=400, message="Invalid invoice item id supplied")})
    public Response createInvoiceItemCustomFields(@PathParam(value="invoiceItemId") UUID id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(id, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), uriInfo, request);
    }

    @TimedResource
    @PUT
    @Path(value="/{invoiceItemId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Modify custom fields to invoice item")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid invoice item id supplied")})
    public Response modifyInvoiceItemCustomFields(@PathParam(value="invoiceItemId") UUID id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.modifyCustomFields(id, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @DELETE
    @Path(value="/{invoiceItemId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from invoice item")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid invoice item id supplied")})
    public Response deleteInvoiceItemCustomFields(@PathParam(value="invoiceItemId") UUID id, @QueryParam(value="customField") List<UUID> customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(id, customFieldList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{invoiceItemId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve invoice item tags", response=TagJson.class, responseContainer="List", nickname="getInvoiceItemTags")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid invoice item id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getTags(@PathParam(value="invoiceItemId") UUID id, @ApiParam(required=true) @QueryParam(value="accountId") UUID accountId, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws TagDefinitionApiException, AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, tenantContext);
        return super.getTags(account.getId(), id, auditMode, includedDeleted, tenantContext);
    }

    @TimedResource
    @POST
    @Path(value="/{invoiceItemId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add tags to invoice item", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Tag created successfully"), @ApiResponse(code=400, message="Invalid invoice item id supplied")})
    public Response createInvoiceItemTags(@PathParam(value="invoiceItemId") UUID id, List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws TagApiException {
        return super.createTags(id, tagList, uriInfo, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), request);
    }

    @TimedResource
    @DELETE
    @Path(value="/{invoiceItemId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove tags from invoice item")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid invoice item id supplied")})
    public Response deleteInvoiceItemTags(@PathParam(value="invoiceItemId") UUID id, @QueryParam(value="tagDef") List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(id, tagList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.INVOICE_ITEM;
    }
}

