/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Singleton
@Path(value="/1.0/kb/customFields")
@Api(value="/1.0/kb/customFields", description="Operations on custom fields", tags={"CustomField"})
public class CustomFieldResource
extends JaxRsResourceBase {
    @Inject
    public CustomFieldResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
    }

    @TimedResource
    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    @ApiOperation(value="List custom fields", response=CustomFieldJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getCustomFields(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws CustomFieldApiException {
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination customFields = this.customFieldUserApi.getCustomFields(offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(CustomFieldResource.class, "getCustomFields", customFields.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"audit", (Object)auditMode.getLevel().toString()));
        return this.buildStreamingPaginationResponse(customFields, new Function<CustomField, CustomFieldJson>(){

            public CustomFieldJson apply(CustomField customField) {
                List auditLogs = CustomFieldResource.this.auditUserApi.getAuditLogs(customField.getId(), ObjectType.CUSTOM_FIELD, auditMode.getLevel(), tenantContext);
                return new CustomFieldJson(customField, auditLogs);
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search custom fields by type, name and optional value", response=CustomFieldJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchCustomFieldsByTypeName(@QueryParam(value="objectType") String objectType, @QueryParam(value="fieldName") String fieldName, @Nullable @QueryParam(value="fieldValue") String fieldValue, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        Preconditions.checkNotNull((Object)objectType);
        Preconditions.checkNotNull((Object)fieldName);
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination customFields = fieldValue != null ? this.customFieldUserApi.searchCustomFields(fieldName, fieldValue, ObjectType.valueOf((String)objectType), offset, limit, tenantContext) : this.customFieldUserApi.searchCustomFields(fieldName, ObjectType.valueOf((String)objectType), offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(CustomFieldResource.class, "searchCustomFields", customFields.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"objectType", (Object)objectType, (Object)"fieldName", (Object)fieldName, (Object)"fieldValue", (Object)MoreObjects.firstNonNull((Object)fieldValue, (Object)""), (Object)"audit", (Object)auditMode.getLevel().toString()));
        return this.buildStreamingPaginationResponse(customFields, new Function<CustomField, CustomFieldJson>(){

            public CustomFieldJson apply(CustomField customField) {
                List auditLogs = CustomFieldResource.this.auditUserApi.getAuditLogs(customField.getId(), ObjectType.CUSTOM_FIELD, auditMode.getLevel(), tenantContext);
                return new CustomFieldJson(customField, auditLogs);
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search custom fields", response=CustomFieldJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchCustomFields(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws CustomFieldApiException {
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination customFields = this.customFieldUserApi.searchCustomFields(searchKey, offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(CustomFieldResource.class, "searchCustomFields", customFields.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"audit", (Object)auditMode.getLevel().toString()));
        return this.buildStreamingPaginationResponse(customFields, new Function<CustomField, CustomFieldJson>(){

            public CustomFieldJson apply(CustomField customField) {
                List auditLogs = CustomFieldResource.this.auditUserApi.getAuditLogs(customField.getId(), ObjectType.CUSTOM_FIELD, auditMode.getLevel(), tenantContext);
                return new CustomFieldJson(customField, auditLogs);
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/{customFieldId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve custom field audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response getCustomFieldAuditLogsWithHistory(@PathParam(value="customFieldId") UUID customFieldId, @Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.customFieldUserApi.getCustomFieldAuditLogsWithHistoryForId(customFieldId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }
}

