/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.LocalDate;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/credits")
@Api(value="/1.0/kb/credits", description="Operations on credits", tags={"Credit"})
public class CreditResource
extends JaxRsResourceBase {
    private final InvoiceUserApi invoiceUserApi;
    private final AccountUserApi accountUserApi;

    @Inject
    public CreditResource(InvoiceUserApi invoiceUserApi, AccountUserApi accountUserApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
        this.invoiceUserApi = invoiceUserApi;
        this.accountUserApi = accountUserApi;
    }

    @GET
    @Path(value="/{creditId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a credit by id", response=InvoiceItemJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid credit id supplied"), @ApiResponse(code=404, message="Credit not found")})
    public Response getCredit(@PathParam(value="creditId") UUID creditId, @Context HttpServletRequest request) throws InvoiceApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        InvoiceItem credit = this.invoiceUserApi.getCreditById(creditId, tenantContext);
        InvoiceItemJson creditJson = new InvoiceItemJson(credit, (List<InvoiceItem>)ImmutableList.of(), null);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)creditJson).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a credit", response=InvoiceItemJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Created credit successfully"), @ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response createCredits(List<InvoiceItemJson> json, @QueryParam(value="autoCommit") @DefaultValue(value="false") Boolean autoCommit, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        this.verifyNonNullOrEmpty(json, "CreditJson body should be specified");
        this.verifyNonNullOrEmpty(json.get(0).getAccountId(), "CreditJson accountId needs to be set", json.get(0).getAmount(), "CreditJson creditAmount needs to be set");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextWithAccountId(json.get(0).getAccountId(), createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(json.get(0).getAccountId(), (TenantContext)callContext);
        LocalDate effectiveDate = new LocalDate((Object)callContext.getCreatedDate(), account.getTimeZone());
        Iterable<InvoiceItem> inputItems = this.validateSanitizeAndTranformInputItems(account.getCurrency(), json);
        List createdCredits = this.invoiceUserApi.insertCredits(account.getId(), effectiveDate, inputItems, autoCommit.booleanValue(), pluginProperties, callContext);
        List createdCreditsJson = Lists.transform((List)createdCredits, (Function)new Function<InvoiceItem, InvoiceItemJson>(){

            public InvoiceItemJson apply(InvoiceItem input) {
                return new InvoiceItemJson(input);
            }
        });
        return Response.status((Response.Status)Response.Status.OK).entity((Object)createdCreditsJson).build();
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.INVOICE_ITEM;
    }
}

