/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogUserApi;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.Listing;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.SimplePlanDescriptor;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entitlement.api.SubscriptionEvent;
import org.killbill.billing.jaxrs.json.CatalogJson;
import org.killbill.billing.jaxrs.json.PlanDetailJson;
import org.killbill.billing.jaxrs.json.SimplePlanJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.tenant.api.TenantApiException;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;
import org.killbill.xmlloader.XMLWriter;

@Singleton
@Path(value="/1.0/kb/catalog")
@Api(value="/1.0/kb/catalog", description="Catalog information", tags={"Catalog"})
public class CatalogResource
extends JaxRsResourceBase {
    private final CatalogUserApi catalogUserApi;
    private final SubscriptionApi subscriptionApi;

    @Inject
    public CatalogResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, CatalogUserApi catalogUserApi, SubscriptionApi subscriptionApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
        this.catalogUserApi = catalogUserApi;
        this.subscriptionApi = subscriptionApi;
    }

    @TimedResource
    @GET
    @Produces(value={"text/xml"})
    @ApiOperation(value="Retrieve the full catalog as XML", response=String.class, hidden=true)
    @ApiResponses(value={})
    public Response getCatalogXmlOriginal(@QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="accountId") UUID accountId, @Context HttpServletRequest request) throws Exception {
        TenantContext tenantContext = accountId != null ? this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request) : this.context.createTenantContextNoAccountId((ServletRequest)request);
        DateTime catalogDateVersion = requestedDate != null ? this.DATE_TIME_FORMATTER.parseDateTime(requestedDate).toDateTime(DateTimeZone.UTC) : null;
        VersionedCatalog catalog = this.catalogUserApi.getCatalog("unused", tenantContext);
        JaxRsResourceBase.filterCatalogVersions(catalog, catalogDateVersion);
        Class<?> serializableClass = catalog.getClass();
        String result = XMLWriter.writeXML((Object)catalog, serializableClass);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @Path(value="/xml")
    @GET
    @Produces(value={"text/xml"})
    @ApiOperation(value="Retrieve the full catalog as XML", response=String.class)
    @ApiResponses(value={})
    public Response getCatalogXml(@QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="accountId") UUID accountId, @Context HttpServletRequest request) throws Exception {
        return this.getCatalogXmlOriginal(requestedDate, accountId, request);
    }

    @TimedResource
    @POST
    @Consumes(value={"text/xml"})
    @ApiOperation(value="Upload the full catalog as XML", hidden=true)
    @ApiResponses(value={})
    public Response uploadCatalogXmlOriginal(String catalogXML, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        this.catalogUserApi.uploadCatalog(catalogXML, callContext);
        return this.uriBuilder.buildResponse(uriInfo, CatalogResource.class, null, null, (ServletRequest)request);
    }

    @TimedResource
    @POST
    @Path(value="/xml")
    @Consumes(value={"text/xml"})
    @ApiOperation(value="Upload the full catalog as XML", response=String.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Catalog XML created successfully")})
    public Response uploadCatalogXml(String catalogXML, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        return this.uploadCatalogXmlOriginal(catalogXML, createdBy, reason, comment, request, uriInfo);
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the catalog as JSON", responseContainer="List", response=CatalogJson.class)
    @ApiResponses(value={})
    public Response getCatalogJson(@QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="accountId") UUID accountId, @Context HttpServletRequest request) throws Exception {
        TenantContext tenantContext = accountId != null ? this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request) : this.context.createTenantContextNoAccountId((ServletRequest)request);
        DateTime catalogDateVersion = requestedDate != null ? this.DATE_TIME_FORMATTER.parseDateTime(requestedDate).toDateTime(DateTimeZone.UTC) : null;
        VersionedCatalog catalog = this.catalogUserApi.getCatalog("unused", tenantContext);
        JaxRsResourceBase.filterCatalogVersions(catalog, catalogDateVersion);
        ArrayList<CatalogJson> result = new ArrayList<CatalogJson>();
        for (StaticCatalog v : catalog.getVersions()) {
            result.add(new CatalogJson(v));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @TimedResource
    @GET
    @Path(value="/versions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a list of catalog versions", response=DateTime.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getCatalogVersions(@QueryParam(value="accountId") UUID accountId, @Context HttpServletRequest request) throws Exception {
        TenantContext tenantContext = accountId != null ? this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request) : this.context.createTenantContextNoAccountId((ServletRequest)request);
        VersionedCatalog catalog = this.catalogUserApi.getCatalog("unused", tenantContext);
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        for (StaticCatalog v : catalog.getVersions()) {
            result.add(new DateTime((Object)v.getEffectiveDate()));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @TimedResource
    @GET
    @Path(value="/availableAddons")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve available add-ons for a given product", response=PlanDetailJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getAvailableAddons(@QueryParam(value="baseProductName") String baseProductName, @Nullable @QueryParam(value="priceListName") String priceListName, @QueryParam(value="accountId") UUID accountId, @Context HttpServletRequest request) throws CatalogApiException {
        TenantContext tenantContext = accountId != null ? this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request) : this.context.createTenantContextNoAccountId((ServletRequest)request);
        StaticCatalog catalog = this.catalogUserApi.getCurrentCatalog("unused", tenantContext);
        List listings = catalog.getAvailableAddOnListings(baseProductName, priceListName);
        ArrayList<PlanDetailJson> details = new ArrayList<PlanDetailJson>();
        for (Listing listing : listings) {
            details.add(new PlanDetailJson(listing));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(details).build();
    }

    @TimedResource
    @GET
    @Path(value="/availableBasePlans")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve available base plans", response=PlanDetailJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getAvailableBasePlans(@QueryParam(value="accountId") UUID accountId, @Context HttpServletRequest request) throws CatalogApiException {
        TenantContext tenantContext = accountId != null ? this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request) : this.context.createTenantContextNoAccountId((ServletRequest)request);
        StaticCatalog catalog = this.catalogUserApi.getCurrentCatalog("unused", tenantContext);
        List listings = catalog.getAvailableBasePlanListings();
        ArrayList<PlanDetailJson> details = new ArrayList<PlanDetailJson>();
        for (Listing listing : listings) {
            details.add(new PlanDetailJson(listing));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(details).build();
    }

    @TimedResource
    @GET
    @Path(value="/plan")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve plan for a given subscription and date", response=CatalogJson.PlanJson.class)
    @ApiResponses(value={})
    public Response getPlanForSubscriptionAndDate(@QueryParam(value="subscriptionId") UUID subscriptionId, @QueryParam(value="requestedDate") String requestedDateString, @Context HttpServletRequest request) throws SubscriptionApiException, CurrencyValueNull {
        this.verifyNonNullOrEmpty(subscriptionId, "Subscription id needs to be specified");
        SubscriptionEvent lastEventBeforeRequestedDate = this.getLastEventBeforeDate(subscriptionId, requestedDateString, request);
        if (lastEventBeforeRequestedDate == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("%s is before the subscription start date", requestedDateString)).type("text/plain").build();
        }
        Plan plan = lastEventBeforeRequestedDate.getNextPlan();
        if (plan == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("%s is after the subscription cancel date", requestedDateString)).type("text/plain").build();
        }
        CatalogJson.PlanJson planJson = new CatalogJson.PlanJson(plan);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)planJson).build();
    }

    @TimedResource
    @GET
    @Path(value="/phase")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve phase for a given subscription and date", response=CatalogJson.PhaseJson.class)
    @ApiResponses(value={})
    public Response getPhaseForSubscriptionAndDate(@QueryParam(value="subscriptionId") UUID subscriptionId, @QueryParam(value="requestedDate") String requestedDateString, @Context HttpServletRequest request) throws SubscriptionApiException, CurrencyValueNull {
        this.verifyNonNullOrEmpty(subscriptionId, "Subscription id needs to be specified");
        SubscriptionEvent lastEventBeforeRequestedDate = this.getLastEventBeforeDate(subscriptionId, requestedDateString, request);
        if (lastEventBeforeRequestedDate == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("%s is before the subscription start date", requestedDateString)).type("text/plain").build();
        }
        PlanPhase phase = lastEventBeforeRequestedDate.getNextPhase();
        if (phase == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("%s is after the subscription cancel date", requestedDateString)).type("text/plain").build();
        }
        CatalogJson.PhaseJson phaseJson = new CatalogJson.PhaseJson(phase);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)phaseJson).build();
    }

    @TimedResource
    @GET
    @Path(value="/product")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve product for a given subscription and date", response=CatalogJson.ProductJson.class)
    @ApiResponses(value={})
    public Response getProductForSubscriptionAndDate(@QueryParam(value="subscriptionId") UUID subscriptionId, @QueryParam(value="requestedDate") String requestedDateString, @Context HttpServletRequest request) throws SubscriptionApiException {
        this.verifyNonNullOrEmpty(subscriptionId, "Subscription id needs to be specified");
        SubscriptionEvent lastEventBeforeRequestedDate = this.getLastEventBeforeDate(subscriptionId, requestedDateString, request);
        if (lastEventBeforeRequestedDate == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("%s is before the subscription start date", requestedDateString)).type("text/plain").build();
        }
        Product product = lastEventBeforeRequestedDate.getNextProduct();
        if (product == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("%s is after the subscription cancel date", requestedDateString)).type("text/plain").build();
        }
        CatalogJson.ProductJson productJson = new CatalogJson.ProductJson(product);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)productJson).build();
    }

    @TimedResource
    @GET
    @Path(value="/priceList")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve priceList for a given subscription and date", response=CatalogJson.PriceListJson.class)
    @ApiResponses(value={})
    public Response getPriceListForSubscriptionAndDate(@QueryParam(value="subscriptionId") UUID subscriptionId, @QueryParam(value="requestedDate") String requestedDateString, @Context HttpServletRequest request) throws SubscriptionApiException {
        this.verifyNonNullOrEmpty(subscriptionId, "Subscription id needs to be specified");
        SubscriptionEvent lastEventBeforeRequestedDate = this.getLastEventBeforeDate(subscriptionId, requestedDateString, request);
        if (lastEventBeforeRequestedDate == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("%s is before the subscription start date", requestedDateString)).type("text/plain").build();
        }
        PriceList priceList = lastEventBeforeRequestedDate.getNextPriceList();
        if (priceList == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("%s is after the subscription cancel date", requestedDateString)).type("text/plain").build();
        }
        CatalogJson.PriceListJson priceListJson = new CatalogJson.PriceListJson(priceList);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)priceListJson).build();
    }

    private SubscriptionEvent getLastEventBeforeDate(UUID subscriptionId, String requestedDateString, HttpServletRequest request) throws SubscriptionApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        DateTime requestedDateTime = requestedDateString != null ? this.DATE_TIME_FORMATTER.parseDateTime(requestedDateString).toDateTime(DateTimeZone.UTC) : this.clock.getUTCNow();
        LocalDate requestedDate = requestedDateTime.toLocalDate();
        Subscription subscription = this.subscriptionApi.getSubscriptionForEntitlementId(subscriptionId, tenantContext);
        SubscriptionEvent lastEventBeforeRequestedDate = null;
        for (SubscriptionEvent subscriptionEvent : subscription.getSubscriptionEvents()) {
            if (lastEventBeforeRequestedDate == null) {
                if (subscriptionEvent.getEffectiveDate().compareTo((ReadablePartial)requestedDate) > 0) {
                    return null;
                }
                lastEventBeforeRequestedDate = subscriptionEvent;
            }
            if (subscriptionEvent.getEffectiveDate().compareTo((ReadablePartial)requestedDate) > 0) break;
            lastEventBeforeRequestedDate = subscriptionEvent;
        }
        return lastEventBeforeRequestedDate;
    }

    @TimedResource
    @POST
    @Path(value="/simplePlan")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add a simple plan entry in the current version of the catalog", response=String.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Created new plan successfully")})
    public Response addSimplePlan(final SimplePlanJson simplePlan, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        SimplePlanDescriptor desc = new SimplePlanDescriptor(){

            public String getPlanId() {
                return simplePlan.getPlanId();
            }

            public String getProductName() {
                return simplePlan.getProductName();
            }

            public ProductCategory getProductCategory() {
                return simplePlan.getProductCategory();
            }

            public List<String> getAvailableBaseProducts() {
                return simplePlan.getAvailableBaseProducts();
            }

            public Currency getCurrency() {
                return simplePlan.getCurrency();
            }

            public BigDecimal getAmount() {
                return simplePlan.getAmount();
            }

            public BillingPeriod getBillingPeriod() {
                return simplePlan.getBillingPeriod();
            }

            public Integer getTrialLength() {
                return simplePlan.getTrialLength();
            }

            public TimeUnit getTrialTimeUnit() {
                return simplePlan.getTrialTimeUnit();
            }

            public String toString() {
                return simplePlan.toString();
            }
        };
        this.catalogUserApi.addSimplePlan(desc, null, callContext);
        return this.uriBuilder.buildResponse(uriInfo, CatalogResource.class, null, null, (ServletRequest)request);
    }

    @DELETE
    @ApiOperation(value="Delete all versions for a per tenant catalog")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation")})
    public Response deleteCatalog(@HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws TenantApiException, CatalogApiException {
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        this.catalogUserApi.deleteCatalog(callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

