/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.LocalDate;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.EntitlementApi;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.BlockingStateJson;
import org.killbill.billing.jaxrs.json.BundleJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.TimedResource;

@Path(value="/1.0/kb/bundles")
@Api(value="/1.0/kb/bundles", description="Operations on bundles", tags={"Bundle"})
public class BundleResource
extends JaxRsResourceBase {
    private static final String ID_PARAM_NAME = "bundleId";
    private final SubscriptionApi subscriptionApi;
    private final EntitlementApi entitlementApi;

    @Inject
    public BundleResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, SubscriptionApi subscriptionApi, EntitlementApi entitlementApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, subscriptionApi, clock, context);
        this.entitlementApi = entitlementApi;
        this.subscriptionApi = subscriptionApi;
    }

    @TimedResource
    @GET
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a bundle by id", response=BundleJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response getBundle(@PathParam(value="bundleId") UUID bundleId, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws SubscriptionApiException, AccountApiException, CatalogApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        SubscriptionBundle bundle = this.subscriptionApi.getSubscriptionBundle(bundleId, tenantContext);
        Account account = this.accountUserApi.getAccountById(bundle.getAccountId(), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(bundle.getAccountId(), auditMode.getLevel(), tenantContext);
        BundleJson json = new BundleJson(bundle, account.getCurrency(), accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a bundle by external key", response=BundleJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Bundle not found")})
    public Response getBundleByKey(@ApiParam(required=true) @QueryParam(value="externalKey") String externalKey, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws SubscriptionApiException, AccountApiException, CatalogApiException {
        List bundles;
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        if (includedDeleted.booleanValue()) {
            bundles = this.subscriptionApi.getSubscriptionBundlesForExternalKey(externalKey, tenantContext);
        } else {
            SubscriptionBundle activeBundle = this.subscriptionApi.getActiveSubscriptionBundleForExternalKey(externalKey, tenantContext);
            bundles = ImmutableList.of((Object)activeBundle);
        }
        ArrayList<BundleJson> result = new ArrayList<BundleJson>(bundles.size());
        for (SubscriptionBundle bundle : bundles) {
            Account account = this.accountUserApi.getAccountById(bundle.getAccountId(), tenantContext);
            AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(bundle.getAccountId(), auditMode.getLevel(), tenantContext);
            BundleJson json = new BundleJson(bundle, account.getCurrency(), accountAuditLogs);
            result.add(json);
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @TimedResource
    @GET
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve bundle audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Subscription bundle not found")})
    public Response getBundleAuditLogsWithHistory(@PathParam(value="bundleId") UUID bundleId, @Context HttpServletRequest request) {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.subscriptionApi.getSubscriptionBundleAuditLogsWithHistoryForId(bundleId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @TimedResource
    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    @ApiOperation(value="List bundles", response=BundleJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getBundles(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws SubscriptionApiException {
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination bundles = this.subscriptionApi.getSubscriptionBundles(offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(BundleResource.class, "getBundles", bundles.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(bundles, new Function<SubscriptionBundle, BundleJson>(){

            public BundleJson apply(SubscriptionBundle bundle) {
                if (((Map)accountsAuditLogs.get()).get(bundle.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(bundle.getAccountId(), BundleResource.this.auditUserApi.getAccountAuditLogs(bundle.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                try {
                    return new BundleJson(bundle, null, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(bundle.getAccountId()));
                }
                catch (CatalogApiException unused) {
                    throw new RuntimeException(unused);
                }
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search bundles", response=BundleJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchBundles(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws SubscriptionApiException {
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination bundles = this.subscriptionApi.searchSubscriptionBundles(searchKey, offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(BundleResource.class, "searchBundles", bundles.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(bundles, new Function<SubscriptionBundle, BundleJson>(){

            public BundleJson apply(SubscriptionBundle bundle) {
                if (((Map)accountsAuditLogs.get()).get(bundle.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(bundle.getAccountId(), BundleResource.this.auditUserApi.getAccountAuditLogs(bundle.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                try {
                    return new BundleJson(bundle, null, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(bundle.getAccountId()));
                }
                catch (CatalogApiException unused) {
                    throw new RuntimeException(unused);
                }
            }
        }, nextPageUri);
    }

    @TimedResource
    @PUT
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/pause")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Pause a bundle")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid bundle id supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response pauseBundle(@PathParam(value="bundleId") UUID bundleId, @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws SubscriptionApiException, EntitlementApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        LocalDate inputLocalDate = this.toLocalDate(requestedDate);
        this.entitlementApi.pause(bundleId, inputLocalDate, pluginProperties, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @PUT
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/resume")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Resume a bundle")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid bundle id supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response resumeBundle(@PathParam(value="bundleId") UUID bundleId, @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws SubscriptionApiException, EntitlementApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        LocalDate inputLocalDate = this.toLocalDate(requestedDate);
        this.entitlementApi.resume(bundleId, inputLocalDate, pluginProperties, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @POST
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/block")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Block a bundle", response=BlockingStateJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Blocking state created successfully"), @ApiResponse(code=400, message="Invalid bundle id supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response addBundleBlockingState(@PathParam(value="bundleId") UUID id, BlockingStateJson json, @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws SubscriptionApiException, EntitlementApiException, AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        SubscriptionBundle bundle = this.subscriptionApi.getSubscriptionBundle(id, tenantContext);
        return this.addBlockingState(json, bundle.getAccountId(), id, BlockingStateType.SUBSCRIPTION_BUNDLE, requestedDate, pluginPropertiesString, createdBy, reason, comment, request, uriInfo);
    }

    @TimedResource
    @GET
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve bundle custom fields", response=CustomFieldJson.class, responseContainer="List", nickname="getBundleCustomFields")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied")})
    public Response getCustomFields(@PathParam(value="bundleId") UUID bundleId, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(bundleId, auditMode, this.context.createTenantContextNoAccountId((ServletRequest)request));
    }

    @TimedResource
    @POST
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to bundle", response=CustomField.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Custom field created successfully"), @ApiResponse(code=400, message="Invalid bundle id supplied")})
    public Response createBundleCustomFields(@PathParam(value="bundleId") UUID bundleId, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(bundleId, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), uriInfo, request);
    }

    @TimedResource
    @PUT
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Modify custom fields to bundle")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid bundle id supplied")})
    public Response modifyBundleCustomFields(@PathParam(value="bundleId") UUID bundleId, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.modifyCustomFields(bundleId, customFields, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @DELETE
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from bundle")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid bundle id supplied")})
    public Response deleteBundleCustomFields(@PathParam(value="bundleId") UUID bundleId, @QueryParam(value="customField") List<UUID> customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(bundleId, customFieldList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve bundle tags", response=TagJson.class, responseContainer="List", nickname="getBundleTags")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid bundle id supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response getTags(@PathParam(value="bundleId") UUID bundleId, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws TagDefinitionApiException, SubscriptionApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        SubscriptionBundle bundle = this.subscriptionApi.getSubscriptionBundle(bundleId, tenantContext);
        return super.getTags(bundle.getAccountId(), bundleId, auditMode, includedDeleted, tenantContext);
    }

    @TimedResource
    @POST
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Transfer a bundle to another account", response=BundleJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Bundle transferred successfully"), @ApiResponse(code=400, message="Invalid bundle id, requested date or policy supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response transferBundle(@PathParam(value="bundleId") UUID bundleId, BundleJson json, @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="billingPolicy") @DefaultValue(value="END_OF_TERM") BillingActionPolicy billingPolicy, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws EntitlementApiException, SubscriptionApiException, AccountApiException {
        this.verifyNonNullOrEmpty(json, "BundleJson body should be specified");
        this.verifyNonNullOrEmpty(json.getAccountId(), "BundleJson accountId needs to be set");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        SubscriptionBundle bundle = this.subscriptionApi.getSubscriptionBundle(bundleId, (TenantContext)callContext);
        LocalDate inputLocalDate = this.toLocalDate(requestedDate);
        UUID newBundleId = this.entitlementApi.transferEntitlementsOverrideBillingPolicy(bundle.getAccountId(), json.getAccountId(), bundle.getExternalKey(), inputLocalDate, billingPolicy, pluginProperties, callContext);
        return this.uriBuilder.buildResponse(uriInfo, BundleResource.class, "getBundle", newBundleId, (ServletRequest)request);
    }

    @TimedResource
    @PUT
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/renameKey")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update a bundle externalKey")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid argumnent supplied"), @ApiResponse(code=404, message="Bundle not found")})
    public Response renameExternalKey(@PathParam(value="bundleId") UUID bundleId, BundleJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws EntitlementApiException {
        this.verifyNonNullOrEmpty(json, "BundleJson body should be specified");
        this.verifyNonNullOrEmpty(json.getExternalKey(), "BundleJson externalKey needs to be set");
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        this.subscriptionApi.updateExternalKey(bundleId, json.getExternalKey(), callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @POST
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add tags to bundle", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Tag created successfully"), @ApiResponse(code=400, message="Invalid bundle id supplied")})
    public Response createBundleTags(@PathParam(value="bundleId") UUID bundleId, List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws TagApiException {
        return super.createTags(bundleId, tagList, uriInfo, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request), request);
    }

    @TimedResource
    @DELETE
    @Path(value="/{bundleId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove tags from bundle")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid bundle id supplied")})
    public Response deleteBundleTags(@PathParam(value="bundleId") UUID bundleId, @QueryParam(value="tagDef") List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(bundleId, tagList, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.BUNDLE;
    }
}

