/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.json.AdminPaymentJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.AdminPaymentApi;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentTransaction;
import org.killbill.billing.payment.api.TransactionStatus;
import org.killbill.billing.server.healthchecks.KillbillHealthcheck;
import org.killbill.billing.tenant.api.Tenant;
import org.killbill.billing.tenant.api.TenantApiException;
import org.killbill.billing.tenant.api.TenantUserApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.RecordIdApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.tag.Tag;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.BusEventWithMetadata;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationEventWithMetadata;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueService;

@Singleton
@Path(value="/1.0/kb/admin")
@Api(value="/1.0/kb/admin", description="Admin operations (will require special privileges)", tags={"Admin"})
public class AdminResource
extends JaxRsResourceBase {
    private static final String OK = "OK";
    private final AdminPaymentApi adminPaymentApi;
    private final InvoiceUserApi invoiceUserApi;
    private final TenantUserApi tenantApi;
    private final CacheControllerDispatcher cacheControllerDispatcher;
    private final RecordIdApi recordIdApi;
    private final PersistentBus persistentBus;
    private final NotificationQueueService notificationQueueService;
    private final KillbillHealthcheck killbillHealthcheck;

    @Inject
    public AdminResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, AdminPaymentApi adminPaymentApi, InvoiceUserApi invoiceUserApi, CacheControllerDispatcher cacheControllerDispatcher, TenantUserApi tenantApi, RecordIdApi recordIdApi, PersistentBus persistentBus, NotificationQueueService notificationQueueService, KillbillHealthcheck killbillHealthcheck, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, paymentApi, invoicePaymentApi, null, clock, context);
        this.adminPaymentApi = adminPaymentApi;
        this.invoiceUserApi = invoiceUserApi;
        this.tenantApi = tenantApi;
        this.recordIdApi = recordIdApi;
        this.cacheControllerDispatcher = cacheControllerDispatcher;
        this.persistentBus = persistentBus;
        this.notificationQueueService = notificationQueueService;
        this.killbillHealthcheck = killbillHealthcheck;
    }

    @GET
    @Path(value="/queues")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Get queues entries", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getQueueEntries(@QueryParam(value="accountId") UUID accountId, final @QueryParam(value="queueName") String queueName, final @QueryParam(value="serviceName") String serviceName, final @QueryParam(value="withHistory") @DefaultValue(value="true") Boolean withHistory, @QueryParam(value="minDate") String minDateOrNull, @QueryParam(value="maxDate") String maxDateOrNull, final @QueryParam(value="withInProcessing") @DefaultValue(value="true") Boolean withInProcessing, final @QueryParam(value="withBusEvents") @DefaultValue(value="true") Boolean withBusEvents, final @QueryParam(value="withNotifications") @DefaultValue(value="true") Boolean withNotifications, @Context HttpServletRequest request) {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        final Long tenantRecordId = this.recordIdApi.getRecordId(tenantContext.getTenantId(), ObjectType.TENANT, tenantContext);
        final Long accountRecordId = accountId == null ? null : this.recordIdApi.getRecordId(accountId, ObjectType.ACCOUNT, tenantContext);
        final DateTime minDate = Strings.isNullOrEmpty((String)minDateOrNull) ? this.clock.getUTCNow().minusDays(2) : this.DATE_TIME_FORMATTER.parseDateTime(minDateOrNull).toDateTime(DateTimeZone.UTC);
        final DateTime maxDate = Strings.isNullOrEmpty((String)maxDateOrNull) ? this.clock.getUTCNow().plusDays(2) : this.DATE_TIME_FORMATTER.parseDateTime(maxDateOrNull).toDateTime(DateTimeZone.UTC);
        StreamingOutput json = new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(OutputStream output) throws IOException, WebApplicationException {
                Iterator busEventsIterator = null;
                Iterator notificationsIterator = null;
                try {
                    JsonGenerator generator = JaxRsResourceBase.mapper.getFactory().createGenerator(output);
                    generator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
                    generator.writeStartObject();
                    if (withBusEvents.booleanValue()) {
                        generator.writeFieldName("busEvents");
                        generator.writeStartArray();
                        for (BusEventWithMetadata busEvent : AdminResource.this.getBusEvents(withInProcessing, withHistory, minDate, maxDate, accountRecordId, tenantRecordId)) {
                            generator.writeObject((Object)new BusEventWithRichMetadata((BusEventWithMetadata<BusEvent>)busEvent));
                        }
                        generator.writeEndArray();
                    }
                    if (withNotifications.booleanValue()) {
                        generator.writeFieldName("notifications");
                        generator.writeStartArray();
                        for (NotificationEventWithMetadata notification : AdminResource.this.getNotifications(queueName, serviceName, withInProcessing, withHistory, minDate, maxDate, accountRecordId, tenantRecordId)) {
                            generator.writeObject((Object)notification);
                        }
                        generator.writeEndArray();
                    }
                    generator.writeEndObject();
                    generator.close();
                }
                finally {
                    if (busEventsIterator != null) {
                        while (busEventsIterator.hasNext()) {
                            busEventsIterator.next();
                        }
                    }
                    if (notificationsIterator != null) {
                        while (notificationsIterator.hasNext()) {
                            notificationsIterator.next();
                        }
                    }
                }
            }
        };
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/payments/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/transactions/{paymentTransactionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @ApiOperation(value="Update existing paymentTransaction and associated payment state")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account data supplied")})
    public Response updatePaymentTransactionState(@PathParam(value="paymentId") UUID paymentId, final @PathParam(value="paymentTransactionId") UUID paymentTransactionId, AdminPaymentJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws PaymentApiException {
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentId, false, false, (Iterable)ImmutableList.of(), (TenantContext)callContext);
        PaymentTransaction paymentTransaction = (PaymentTransaction)Iterables.tryFind((Iterable)payment.getTransactions(), (Predicate)new Predicate<PaymentTransaction>(){

            public boolean apply(PaymentTransaction input) {
                return input.getId().equals(paymentTransactionId);
            }
        }).orNull();
        this.adminPaymentApi.fixPaymentTransactionState(payment, paymentTransaction, TransactionStatus.valueOf((String)json.getTransactionStatus()), json.getLastSuccessPaymentState(), json.getCurrentPaymentStateName(), (Iterable)ImmutableList.of(), callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/invoices")
    @ApiOperation(value="Trigger an invoice generation for all parked accounts")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation")})
    public Response triggerInvoiceGenerationForParkedAccounts(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) {
        final CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        final Pagination tags = this.tagUserApi.searchTags("__PARK__", offset, limit, (TenantContext)callContext);
        final Iterator iterator = tags.iterator();
        StreamingOutput json = new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(OutputStream output) throws IOException, WebApplicationException {
                try {
                    JsonGenerator generator = JaxRsResourceBase.mapper.getFactory().createGenerator(output);
                    generator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
                    generator.writeStartObject();
                    while (iterator.hasNext()) {
                        Tag tag = (Tag)iterator.next();
                        UUID accountId = tag.getObjectId();
                        try {
                            AdminResource.this.invoiceUserApi.triggerInvoiceGeneration(accountId, AdminResource.this.clock.getUTCToday(), callContext);
                            generator.writeStringField(accountId.toString(), AdminResource.OK);
                        }
                        catch (InvoiceApiException e) {
                            if (e.getCode() != ErrorCode.INVOICE_NOTHING_TO_DO.getCode()) {
                                JaxRsResourceBase.log.warn("Unable to trigger invoice generation for accountId='{}'", (Object)accountId);
                            }
                            generator.writeStringField(accountId.toString(), ErrorCode.fromCode((int)e.getCode()).toString());
                        }
                    }
                    generator.writeEndObject();
                    generator.close();
                }
                finally {
                    tags.close();
                }
            }
        };
        URI nextPageUri = this.uriBuilder.nextPage(AdminResource.class, "triggerInvoiceGenerationForParkedAccounts", tags.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).header("X-Killbill-Pagination-CurrentOffset", (Object)tags.getCurrentOffset()).header("X-Killbill-Pagination-NextOffset", (Object)tags.getNextOffset()).header("X-Killbill-Pagination-TotalNbRecords", (Object)tags.getTotalNbRecords()).header("X-Killbill-Pagination-MaxNbRecords", (Object)tags.getMaxNbRecords()).header("X-Killbill-Pagination-NextPageUri", (Object)nextPageUri).build();
    }

    /*
     * Enabled aggressive block sorting
     */
    @DELETE
    @Path(value="/cache")
    @Produces(value={"application/json"})
    @ApiOperation(value="Invalidates the given Cache if specified, otherwise invalidates all caches")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Cache name does not exist or is not alive")})
    public Response invalidatesCache(@QueryParam(value="cacheName") String cacheName, @Context HttpServletRequest request) {
        if (null != cacheName && !cacheName.isEmpty()) {
            Cachable.CacheType cacheType = Cachable.CacheType.findByName((String)cacheName);
            if (cacheType != null) {
                this.cacheControllerDispatcher.getCacheController(cacheType).removeAll();
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            log.warn("Cache for specified cacheName='{}' does not exist or is not alive", (Object)cacheName);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.cacheControllerDispatcher.clearAll();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    @Path(value="/cache/accounts/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Invalidates Caches per account level")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account id supplied")})
    public Response invalidatesCacheByAccount(@PathParam(value="accountId") UUID accountId, @Context HttpServletRequest request) {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        Long accountRecordId = this.recordIdApi.getRecordId(accountId, ObjectType.ACCOUNT, tenantContext);
        CacheController accountRecordIdCacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.ACCOUNT_RECORD_ID);
        accountRecordIdCacheController.remove((Object)accountId.toString());
        CacheController accountImmutableCacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.ACCOUNT_IMMUTABLE);
        accountImmutableCacheController.remove((Object)accountRecordId);
        CacheController accountBCDCacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.ACCOUNT_BCD);
        accountBCDCacheController.remove((Object)accountId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    @Path(value="/cache/tenants")
    @Produces(value={"application/json"})
    @ApiOperation(value="Invalidates Caches per tenant level")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation")})
    public Response invalidatesCacheByTenant(@Context HttpServletRequest request) throws TenantApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Tenant currentTenant = this.tenantApi.getTenantById(tenantContext.getTenantId());
        final Long tenantRecordId = this.recordIdApi.getRecordId(tenantContext.getTenantId(), ObjectType.TENANT, tenantContext);
        Function<String, Boolean> tenantKeysMatcher = new Function<String, Boolean>(){

            public Boolean apply(@Nullable String key) {
                return key != null && key.endsWith("::" + tenantRecordId);
            }
        };
        CacheController tenantRecordIdCacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_RECORD_ID);
        tenantRecordIdCacheController.remove((Object)currentTenant.getId().toString());
        CacheController tenantPaymentStateMachineConfigCacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_PAYMENT_STATE_MACHINE_CONFIG);
        tenantPaymentStateMachineConfigCacheController.remove((Function)tenantKeysMatcher);
        CacheController tenantCacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT);
        tenantCacheController.remove((Object)currentTenant.getApiKey());
        CacheController tenantKVCacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_KV);
        tenantKVCacheController.remove((Function)tenantKeysMatcher);
        CacheController tenantConfigCacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_CONFIG);
        tenantConfigCacheController.remove((Object)tenantRecordId);
        CacheController tenantOverdueConfigCacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_OVERDUE_CONFIG);
        tenantOverdueConfigCacheController.remove((Object)tenantRecordId);
        CacheController tenantCatalogCacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_CATALOG);
        tenantCatalogCacheController.remove((Object)tenantRecordId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @PUT
    @Path(value="/healthcheck")
    @Produces(value={"application/json"})
    @ApiOperation(value="Put the host back into rotation")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation")})
    public Response putInRotation(@Context HttpServletRequest request) {
        this.killbillHealthcheck.putInRotation();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    @Path(value="/healthcheck")
    @Produces(value={"application/json"})
    @ApiOperation(value="Put the host out of rotation")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation")})
    public Response putOutOfRotation(@Context HttpServletRequest request) {
        this.killbillHealthcheck.putOutOfRotation();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private Iterable<NotificationEventWithMetadata<NotificationEvent>> getNotifications(@Nullable String queueName, @Nullable String serviceName, boolean includeInProcessing, boolean includeHistory, @Nullable DateTime minEffectiveDate, @Nullable DateTime maxEffectiveDate, @Nullable Long accountRecordId, Long tenantRecordId) {
        Object notifications = ImmutableList.of();
        for (NotificationQueue notificationQueue : this.notificationQueueService.getNotificationQueues()) {
            if (queueName != null && !queueName.equals(notificationQueue.getQueueName()) || serviceName != null && !serviceName.equals(notificationQueue.getServiceName())) continue;
            notifications = includeInProcessing ? (accountRecordId != null ? Iterables.concat((Iterable)notifications, (Iterable)notificationQueue.getFutureOrInProcessingNotificationForSearchKeys(accountRecordId, tenantRecordId)) : Iterables.concat((Iterable)notifications, (Iterable)notificationQueue.getFutureOrInProcessingNotificationForSearchKey2(maxEffectiveDate, tenantRecordId))) : (accountRecordId != null ? Iterables.concat((Iterable)notifications, (Iterable)notificationQueue.getFutureNotificationForSearchKeys(accountRecordId, tenantRecordId)) : Iterables.concat((Iterable)notifications, (Iterable)notificationQueue.getFutureNotificationForSearchKey2(maxEffectiveDate, tenantRecordId)));
            if (!includeHistory) continue;
            if (accountRecordId != null) {
                notifications = Iterables.concat((Iterable)notificationQueue.getHistoricalNotificationForSearchKeys(accountRecordId, tenantRecordId), (Iterable)notifications);
                continue;
            }
            notifications = Iterables.concat((Iterable)notificationQueue.getHistoricalNotificationForSearchKey2(minEffectiveDate, tenantRecordId), (Iterable)notifications);
        }
        return notifications;
    }

    private Iterable<BusEventWithMetadata<BusEvent>> getBusEvents(boolean includeInProcessing, boolean includeHistory, @Nullable DateTime minCreatedDate, @Nullable DateTime maxCreatedDate, @Nullable Long accountRecordId, Long tenantRecordId) {
        Object busEvents = ImmutableList.of();
        busEvents = includeInProcessing ? (accountRecordId != null ? Iterables.concat((Iterable)busEvents, (Iterable)this.persistentBus.getAvailableOrInProcessingBusEventsForSearchKeys(accountRecordId, tenantRecordId)) : Iterables.concat((Iterable)busEvents, (Iterable)this.persistentBus.getAvailableOrInProcessingBusEventsForSearchKey2(maxCreatedDate, tenantRecordId))) : (accountRecordId != null ? Iterables.concat((Iterable)busEvents, (Iterable)this.persistentBus.getAvailableBusEventsForSearchKeys(accountRecordId, tenantRecordId)) : Iterables.concat((Iterable)busEvents, (Iterable)this.persistentBus.getAvailableBusEventsForSearchKey2(maxCreatedDate, tenantRecordId)));
        if (includeHistory) {
            busEvents = accountRecordId != null ? Iterables.concat((Iterable)this.persistentBus.getHistoricalBusEventsForSearchKeys(accountRecordId, tenantRecordId), (Iterable)busEvents) : Iterables.concat((Iterable)this.persistentBus.getHistoricalBusEventsForSearchKey2(minCreatedDate, tenantRecordId), (Iterable)busEvents);
        }
        return busEvents;
    }

    private class BusEventWithRichMetadata
    extends BusEventWithMetadata<BusEvent> {
        private final String className;

        public BusEventWithRichMetadata(BusEventWithMetadata<BusEvent> event) {
            super(event.getRecordId(), event.getUserToken(), event.getCreatedDate(), event.getSearchKey1(), event.getSearchKey2(), event.getEvent());
            this.className = ((BusEvent)event.getEvent()).getClass().getName();
        }

        public String getClassName() {
            return this.className;
        }
    }
}

