/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.OrderingType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.JaxrsExecutors;
import org.killbill.billing.jaxrs.json.AccountEmailJson;
import org.killbill.billing.jaxrs.json.AccountJson;
import org.killbill.billing.jaxrs.json.AccountTimelineJson;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.BlockingStateJson;
import org.killbill.billing.jaxrs.json.BundleJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.InvoiceJson;
import org.killbill.billing.jaxrs.json.InvoicePaymentJson;
import org.killbill.billing.jaxrs.json.OverdueStateJson;
import org.killbill.billing.jaxrs.json.PaymentJson;
import org.killbill.billing.jaxrs.json.PaymentMethodJson;
import org.killbill.billing.jaxrs.json.PaymentTransactionJson;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.resources.PaymentMethodResource;
import org.killbill.billing.jaxrs.resources.PaymentResource;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.overdue.api.OverdueApi;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.config.api.OverdueException;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PaymentOptions;
import org.killbill.billing.payment.api.PaymentTransaction;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.api.TransactionStatus;
import org.killbill.billing.payment.api.TransactionType;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.RecordIdApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.config.definition.JaxrsConfig;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.clock.Clock;
import org.killbill.commons.metrics.MetricTag;
import org.killbill.commons.metrics.TimedResource;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueService;

@Singleton
@Path(value="/1.0/kb/accounts")
@Api(value="/1.0/kb/accounts", description="Operations on accounts", tags={"Account"})
public class AccountResource
extends JaxRsResourceBase {
    private static final String ID_PARAM_NAME = "accountId";
    private final SubscriptionApi subscriptionApi;
    private final InvoiceUserApi invoiceApi;
    private final InvoicePaymentApi invoicePaymentApi;
    private final OverdueApi overdueApi;
    private final JaxrsExecutors jaxrsExecutors;
    private final JaxrsConfig jaxrsConfig;
    private final RecordIdApi recordIdApi;
    private final NotificationQueueService notificationQueueService;

    @Inject
    public AccountResource(JaxrsUriBuilder uriBuilder, AccountUserApi accountApi, InvoiceUserApi invoiceApi, InvoicePaymentApi invoicePaymentApi, PaymentApi paymentApi, TagUserApi tagUserApi, AuditUserApi auditUserApi, CustomFieldUserApi customFieldUserApi, SubscriptionApi subscriptionApi, OverdueApi overdueApi, Clock clock, JaxrsExecutors jaxrsExecutors, JaxrsConfig jaxrsConfig, Context context, RecordIdApi recordIdApi, NotificationQueueService notificationQueueService) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountApi, paymentApi, invoicePaymentApi, subscriptionApi, clock, context);
        this.subscriptionApi = subscriptionApi;
        this.invoiceApi = invoiceApi;
        this.invoicePaymentApi = invoicePaymentApi;
        this.overdueApi = overdueApi;
        this.jaxrsExecutors = jaxrsExecutors;
        this.jaxrsConfig = jaxrsConfig;
        this.recordIdApi = recordIdApi;
        this.notificationQueueService = notificationQueueService;
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve an account by id", response=AccountJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getAccount(@PathParam(value="accountId") UUID accountId, @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
        AccountJson accountJson = this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)accountJson).build();
    }

    @TimedResource
    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    @ApiOperation(value="List accounts", response=AccountJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response getAccounts(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, final @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination accounts = this.accountUserApi.getAccounts(offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(AccountResource.class, "getAccounts", accounts.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"accountWithBalance", (Object)accountWithBalance.toString(), (Object)"accountWithBalanceAndCBA", (Object)accountWithBalanceAndCBA.toString(), (Object)"audit", (Object)auditMode.getLevel().toString()));
        return this.buildStreamingPaginationResponse(accounts, new Function<Account, AccountJson>(){

            public AccountJson apply(Account account) {
                AccountAuditLogs accountAuditLogs = AccountResource.this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
                return AccountResource.this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Search accounts", response=AccountJson.class, responseContainer="List")
    @ApiResponses(value={})
    public Response searchAccounts(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, final @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        final TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Pagination accounts = this.accountUserApi.searchAccounts(searchKey, offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(AccountResource.class, "searchAccounts", accounts.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"accountWithBalance", (Object)accountWithBalance.toString(), (Object)"accountWithBalanceAndCBA", (Object)accountWithBalanceAndCBA.toString(), (Object)"audit", (Object)auditMode.getLevel().toString()));
        return this.buildStreamingPaginationResponse(accounts, new Function<Account, AccountJson>(){

            public AccountJson apply(Account account) {
                AccountAuditLogs accountAuditLogs = AccountResource.this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
                return AccountResource.this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
            }
        }, nextPageUri);
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/bundles")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve bundles for account", response=BundleJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getAccountBundles(@PathParam(value="accountId") UUID accountId, @QueryParam(value="externalKey") String externalKey, @QueryParam(value="bundlesFilter") String bundlesFilter, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, SubscriptionApiException {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        final Account account = this.accountUserApi.getAccountById(accountId, tenantContext);
        List<SubscriptionBundle> bundles = externalKey != null ? this.subscriptionApi.getSubscriptionBundlesForAccountIdAndExternalKey(accountId, externalKey, tenantContext) : this.subscriptionApi.getSubscriptionBundlesForAccountId(accountId, tenantContext);
        final AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
        boolean filter = null != bundlesFilter && !bundlesFilter.isEmpty();
        Collection result = Collections2.transform(filter ? this.filterBundles(bundles, Arrays.asList(bundlesFilter.split(","))) : bundles, (Function)new Function<SubscriptionBundle, BundleJson>(){

            public BundleJson apply(SubscriptionBundle input) {
                try {
                    return new BundleJson(input, account.getCurrency(), accountAuditLogs);
                }
                catch (CatalogApiException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    private List<SubscriptionBundle> filterBundles(List<SubscriptionBundle> subscriptionBundlesForAccountId, List<String> bundlesFilter) {
        ArrayList<SubscriptionBundle> result = new ArrayList<SubscriptionBundle>();
        for (SubscriptionBundle subscriptionBundle : subscriptionBundlesForAccountId) {
            if (!bundlesFilter.contains(subscriptionBundle.getId().toString())) continue;
            result.add(subscriptionBundle);
        }
        return result;
    }

    @TimedResource
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve an account by external key", response=AccountJson.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response getAccountByKey(@ApiParam(required=true) @QueryParam(value="externalKey") String externalKey, @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        Account account = this.accountUserApi.getAccountByKey(externalKey, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
        AccountJson accountJson = this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)accountJson).build();
    }

    private AccountJson getAccount(Account account, Boolean accountWithBalance, Boolean accountWithBalanceAndCBA, AccountAuditLogs auditLogs, TenantContext tenantContext) {
        if (accountWithBalanceAndCBA.booleanValue()) {
            BigDecimal accountBalance = this.invoiceApi.getAccountBalance(account.getId(), tenantContext);
            BigDecimal accountCBA = this.invoiceApi.getAccountCBA(account.getId(), tenantContext);
            return new AccountJson(account, accountBalance, accountCBA, auditLogs);
        }
        if (accountWithBalance.booleanValue()) {
            BigDecimal accountBalance = this.invoiceApi.getAccountBalance(account.getId(), tenantContext);
            return new AccountJson(account, accountBalance, null, auditLogs);
        }
        return new AccountJson(account, null, null, auditLogs);
    }

    @TimedResource
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create account", response=AccountJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Account created successfully"), @ApiResponse(code=400, message="Invalid account data supplied")})
    public Response createAccount(AccountJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException {
        this.verifyNonNullOrEmpty(json, "AccountJson body should be specified");
        Account data = json.toAccount(null);
        Account account = this.accountUserApi.createAccount((AccountData)data, this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request));
        return this.uriBuilder.buildResponse(uriInfo, AccountResource.class, "getAccount", account.getId(), (ServletRequest)request);
    }

    @TimedResource
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @ApiOperation(value="Update account")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account data supplied")})
    public Response updateAccount(@PathParam(value="accountId") UUID accountId, AccountJson json, @QueryParam(value="treatNullAsReset") @DefaultValue(value="false") Boolean treatNullValueAsReset, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        this.verifyNonNullOrEmpty(json, "AccountJson body should be specified");
        Account data = json.toAccount(accountId);
        if (treatNullValueAsReset.booleanValue()) {
            this.accountUserApi.updateAccount(data, this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request));
        } else {
            this.accountUserApi.updateAccount(accountId, (AccountData)data, this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request));
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Close account")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account id supplied")})
    public Response closeAccount(@PathParam(value="accountId") UUID accountId, @QueryParam(value="cancelAllSubscriptions") @DefaultValue(value="false") Boolean cancelAllSubscriptions, @QueryParam(value="writeOffUnpaidInvoices") @DefaultValue(value="false") Boolean writeOffUnpaidInvoices, @QueryParam(value="itemAdjustUnpaidInvoices") @DefaultValue(value="false") Boolean itemAdjustUnpaidInvoices, @QueryParam(value="removeFutureNotifications") @DefaultValue(value="true") Boolean removeFutureNotifications, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws SubscriptionApiException, AccountApiException, EntitlementApiException, InvoiceApiException, TagApiException {
        ImmutableList unpaidInvoices;
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        this.tagUserApi.addTag(accountId, ObjectType.ACCOUNT, ControlTagType.AUTO_INVOICING_OFF.getId(), callContext);
        if (cancelAllSubscriptions.booleanValue()) {
            List bundles = this.subscriptionApi.getSubscriptionBundlesForAccountId(accountId, (TenantContext)callContext);
            Iterable subscriptions = Iterables.concat((Iterable)Iterables.transform((Iterable)bundles, (Function)new Function<SubscriptionBundle, List<Subscription>>(){

                public List<Subscription> apply(SubscriptionBundle input) {
                    return input.getSubscriptions();
                }
            }));
            Iterable toBeCancelled = Iterables.filter((Iterable)subscriptions, (Predicate)new Predicate<Subscription>(){

                public boolean apply(Subscription input) {
                    return input.getLastActiveProductCategory() != ProductCategory.ADD_ON && input.getBillingEndDate() == null;
                }
            });
            for (Subscription cur : toBeCancelled) {
                cur.cancelEntitlementWithPolicyOverrideBillingPolicy(Entitlement.EntitlementActionPolicy.IMMEDIATE, BillingActionPolicy.END_OF_TERM, (Iterable)ImmutableList.of(), callContext);
            }
        }
        Object object = unpaidInvoices = writeOffUnpaidInvoices != false || itemAdjustUnpaidInvoices != false ? this.invoiceApi.getUnpaidInvoicesByAccountId(accountId, null, null, (TenantContext)callContext) : ImmutableList.of();
        if (writeOffUnpaidInvoices.booleanValue()) {
            for (Invoice cur : unpaidInvoices) {
                this.invoiceApi.tagInvoiceAsWrittenOff(cur.getId(), callContext);
            }
        } else if (itemAdjustUnpaidInvoices.booleanValue()) {
            ImmutableList ADJUSTABLE_TYPES = ImmutableList.of((Object)InvoiceItemType.EXTERNAL_CHARGE, (Object)InvoiceItemType.FIXED, (Object)InvoiceItemType.RECURRING, (Object)InvoiceItemType.TAX, (Object)InvoiceItemType.USAGE, (Object)InvoiceItemType.PARENT_SUMMARY);
            String description = comment != null ? comment : "Close Account";
            for (Invoice invoice : unpaidInvoices) {
                for (InvoiceItem item : invoice.getInvoiceItems()) {
                    if (!ADJUSTABLE_TYPES.contains(item.getInvoiceItemType())) continue;
                    this.invoiceApi.insertInvoiceItemAdjustment(accountId, invoice.getId(), item.getId(), this.clock.getUTCToday(), description, null, null, callContext);
                }
            }
        }
        BlockingStateJson blockingState = new BlockingStateJson(accountId, "CLOSE_ACCOUNT", "account-service", true, false, false, null, BlockingStateType.ACCOUNT, null);
        this.addBlockingState(blockingState, accountId, accountId, BlockingStateType.ACCOUNT, null, (List<String>)ImmutableList.of(), createdBy, reason, comment, request, null);
        if (removeFutureNotifications.booleanValue()) {
            Long tenantRecordId = this.recordIdApi.getRecordId(callContext.getTenantId(), ObjectType.TENANT, (TenantContext)callContext);
            Long accountRecordId = accountId == null ? null : this.recordIdApi.getRecordId(accountId, ObjectType.ACCOUNT, (TenantContext)callContext);
            for (NotificationQueue notificationQueue : this.notificationQueueService.getNotificationQueues()) {
                log.debug("Removing future notifications for queueName={}", (Object)notificationQueue.getFullQName());
                notificationQueue.removeFutureNotificationsForSearchKeys(accountRecordId, tenantRecordId);
            }
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/timeline")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account timeline", response=AccountTimelineJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getAccountTimeline(final @PathParam(value="accountId") UUID accountId, @QueryParam(value="parallel") @DefaultValue(value="false") Boolean parallel, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, PaymentApiException, SubscriptionApiException, InvoiceApiException, CatalogApiException {
        final TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, tenantContext);
        Callable<List<SubscriptionBundle>> bundlesCallable = new Callable<List<SubscriptionBundle>>(){

            @Override
            public List<SubscriptionBundle> call() throws Exception {
                return AccountResource.this.subscriptionApi.getSubscriptionBundlesForAccountId(accountId, tenantContext);
            }
        };
        Callable<List<Invoice>> invoicesCallable = new Callable<List<Invoice>>(){

            @Override
            public List<Invoice> call() throws Exception {
                return AccountResource.this.invoiceApi.getInvoicesByAccount(accountId, false, false, tenantContext);
            }
        };
        Callable<List<InvoicePayment>> invoicePaymentsCallable = new Callable<List<InvoicePayment>>(){

            @Override
            public List<InvoicePayment> call() throws Exception {
                return AccountResource.this.invoicePaymentApi.getInvoicePaymentsByAccount(accountId, tenantContext);
            }
        };
        Callable<List<Payment>> paymentsCallable = new Callable<List<Payment>>(){

            @Override
            public List<Payment> call() throws Exception {
                return AccountResource.this.paymentApi.getAccountPayments(accountId, false, false, (Iterable)ImmutableList.of(), tenantContext);
            }
        };
        Callable<AccountAuditLogs> auditsCallable = new Callable<AccountAuditLogs>(){

            @Override
            public AccountAuditLogs call() throws Exception {
                return AccountResource.this.auditUserApi.getAccountAuditLogs(accountId, auditMode.getLevel(), tenantContext);
            }
        };
        List<Invoice> invoices = null;
        List<SubscriptionBundle> bundles = null;
        List<InvoicePayment> invoicePayments = null;
        List<Payment> payments = null;
        AccountAuditLogs accountAuditLogs = null;
        if (parallel.booleanValue()) {
            ExecutorService executor = this.jaxrsExecutors.getJaxrsExecutorService();
            Future<List<SubscriptionBundle>> futureBundlesCallable = executor.submit(bundlesCallable);
            Future<List<Invoice>> futureInvoicesCallable = executor.submit(invoicesCallable);
            Future<List<InvoicePayment>> futureInvoicePaymentsCallable = executor.submit(invoicePaymentsCallable);
            Future<List<Payment>> futurePaymentsCallable = executor.submit(paymentsCallable);
            Future<AccountAuditLogs> futureAuditsCallable = executor.submit(auditsCallable);
            ImmutableList toBeCancelled = ImmutableList.of(futureBundlesCallable, futureInvoicesCallable, futureInvoicePaymentsCallable, futurePaymentsCallable, futureAuditsCallable);
            int timeoutMsec = 100;
            long ini = System.currentTimeMillis();
            do {
                bundles = bundles == null ? this.waitOnFutureAndHandleTimeout("bundles", futureBundlesCallable, 100L, (Iterable<Future>)toBeCancelled) : bundles;
                invoices = invoices == null ? this.waitOnFutureAndHandleTimeout("invoices", futureInvoicesCallable, 100L, (Iterable<Future>)toBeCancelled) : invoices;
                invoicePayments = invoicePayments == null ? this.waitOnFutureAndHandleTimeout("invoicePayments", futureInvoicePaymentsCallable, 100L, (Iterable<Future>)toBeCancelled) : invoicePayments;
                payments = payments == null ? this.waitOnFutureAndHandleTimeout("payments", futurePaymentsCallable, 100L, (Iterable<Future>)toBeCancelled) : payments;
                AccountAuditLogs accountAuditLogs2 = accountAuditLogs = accountAuditLogs == null ? this.waitOnFutureAndHandleTimeout("accountAuditLogs", futureAuditsCallable, 100L, (Iterable<Future>)toBeCancelled) : accountAuditLogs;
            } while (System.currentTimeMillis() - ini < this.jaxrsConfig.getJaxrsTimeout().getMillis() && (bundles == null || invoices == null || invoicePayments == null || payments == null || accountAuditLogs == null));
            if (bundles == null || invoices == null || invoicePayments == null || payments == null || accountAuditLogs == null) {
                Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
        } else {
            invoices = this.runCallable("invoices", invoicesCallable);
            payments = this.runCallable("payments", paymentsCallable);
            bundles = this.runCallable("bundles", bundlesCallable);
            accountAuditLogs = this.runCallable("accountAuditLogs", auditsCallable);
            invoicePayments = this.runCallable("invoicePayments", invoicePaymentsCallable);
        }
        AccountTimelineJson json = new AccountTimelineJson(account, invoices, payments, invoicePayments, bundles, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    private <T> T waitOnFutureAndHandleTimeout(String logSuffix, Future<T> future, long timeoutMsec, Iterable<Future> toBeCancelled) throws PaymentApiException, AccountApiException, InvoiceApiException, SubscriptionApiException {
        try {
            return this.waitOnFutureAndHandleTimeout(future, timeoutMsec);
        }
        catch (InterruptedException e) {
            log.warn("InterruptedException while retrieving {}", (Object)logSuffix, (Object)e);
            this.handleCallableException(e, toBeCancelled);
        }
        catch (ExecutionException e) {
            log.warn("ExecutionException while retrieving {}", (Object)logSuffix, (Object)e);
            this.handleCallableException(e.getCause(), toBeCancelled);
        }
        return null;
    }

    private <T> T waitOnFutureAndHandleTimeout(Future<T> future, long timeoutMsec) throws ExecutionException, InterruptedException {
        try {
            return future.get(timeoutMsec, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    private <T> T runCallable(String logSuffix, Callable<T> callable) throws PaymentApiException, AccountApiException, InvoiceApiException, SubscriptionApiException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            log.warn("InterruptedException while retrieving {}", (Object)logSuffix, (Object)e);
            this.handleCallableException(e);
            return null;
        }
    }

    private void handleCallableException(Throwable causeOrException, Iterable<Future> toBeCancelled) throws AccountApiException, SubscriptionApiException, PaymentApiException, InvoiceApiException {
        for (Future f : toBeCancelled) {
            f.cancel(true);
        }
        this.handleCallableException(causeOrException);
    }

    private void handleCallableException(Throwable causeOrException) throws AccountApiException, SubscriptionApiException, PaymentApiException, InvoiceApiException {
        if (causeOrException instanceof AccountApiException) {
            throw (AccountApiException)causeOrException;
        }
        if (causeOrException instanceof SubscriptionApiException) {
            throw (SubscriptionApiException)causeOrException;
        }
        if (causeOrException instanceof InvoiceApiException) {
            throw (InvoiceApiException)causeOrException;
        }
        if (causeOrException instanceof PaymentApiException) {
            throw (PaymentApiException)causeOrException;
        }
        if (causeOrException instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        throw new RuntimeException(causeOrException.getMessage(), causeOrException);
    }

    @TimedResource
    @PUT
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/cbaRebalancing")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Rebalance account CBA")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account id supplied")})
    public Response rebalanceExistingCBAOnAccount(@PathParam(value="accountId") UUID accountId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        this.invoiceApi.consumeExistingCBAOnAccountWithUnpaidInvoices(accountId, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/invoices")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account invoices", response=InvoiceJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getInvoicesForAccount(@PathParam(value="accountId") UUID accountId, @QueryParam(value="startDate") String startDateStr, @QueryParam(value="endDate") String endDateStr, @QueryParam(value="withMigrationInvoices") @DefaultValue(value="false") boolean withMigrationInvoices, @QueryParam(value="unpaidInvoicesOnly") @DefaultValue(value="false") boolean unpaidInvoicesOnly, @QueryParam(value="includeVoidedInvoices") @DefaultValue(value="false") boolean includeVoidedInvoices, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        Preconditions.checkState((!unpaidInvoicesOnly || !withMigrationInvoices ? 1 : 0) != 0, (Object)"We don't support fetching unpaid invoices incl. migration");
        Preconditions.checkState((startDateStr == null || !withMigrationInvoices ? 1 : 0) != 0, (Object)"We don't support fetching migration invoices and specifying a start date");
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        LocalDate startDate = startDateStr != null ? this.LOCAL_DATE_FORMATTER.parseLocalDate(startDateStr) : null;
        LocalDate endDate = endDateStr != null ? this.LOCAL_DATE_FORMATTER.parseLocalDate(endDateStr) : null;
        this.accountUserApi.getAccountById(accountId, tenantContext);
        List invoices = unpaidInvoicesOnly ? new ArrayList(this.invoiceApi.getUnpaidInvoicesByAccountId(accountId, startDate, endDate, tenantContext)) : (startDate != null || endDate != null ? this.invoiceApi.getInvoicesByAccount(accountId, startDate, endDate, includeVoidedInvoices, tenantContext) : this.invoiceApi.getInvoicesByAccount(accountId, withMigrationInvoices, includeVoidedInvoices, tenantContext));
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, auditMode.getLevel(), tenantContext);
        LinkedList<InvoiceJson> result = new LinkedList<InvoiceJson>();
        for (Invoice invoice : invoices) {
            result.add(new InvoiceJson(invoice, null, accountAuditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/invoicePayments")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account invoice payments", response=InvoicePaymentJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getInvoicePayments(@PathParam(value="accountId") UUID accountId, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="withAttempts") @DefaultValue(value="false") Boolean withAttempts, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, tenantContext);
        List payments = this.paymentApi.getAccountPayments(account.getId(), withPluginInfo.booleanValue(), withAttempts.booleanValue(), pluginProperties, tenantContext);
        List invoicePayments = this.invoicePaymentApi.getInvoicePaymentsByAccount(accountId, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, auditMode.getLevel(), tenantContext);
        ArrayList<InvoicePaymentJson> result = new ArrayList<InvoicePaymentJson>(payments.size());
        for (Payment payment : payments) {
            UUID invoiceId = AccountResource.getInvoiceId(invoicePayments, payment);
            result.add(new InvoicePaymentJson(payment, invoiceId, accountAuditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @TimedResource
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/invoicePayments")
    @ApiOperation(value="Trigger a payment for all unpaid invoices")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=404, message="Invalid account id supplied")})
    public Response payAllInvoices(@PathParam(value="accountId") UUID accountId, @QueryParam(value="paymentMethodId") UUID inputPaymentMethodId, @QueryParam(value="externalPayment") @DefaultValue(value="false") Boolean externalPayment, @QueryParam(value="paymentAmount") BigDecimal paymentAmount, @QueryParam(value="targetDate") String targetDate, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, PaymentApiException, InvoiceApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        LocalDate inputDate = targetDate == null ? this.clock.getUTCToday() : this.toLocalDate(targetDate);
        Collection unpaidInvoices = this.invoiceApi.getUnpaidInvoicesByAccountId(account.getId(), null, inputDate, (TenantContext)callContext);
        BigDecimal remainingRequestPayment = paymentAmount;
        if (remainingRequestPayment == null) {
            remainingRequestPayment = BigDecimal.ZERO;
            for (Invoice invoice : unpaidInvoices) {
                remainingRequestPayment = remainingRequestPayment.add(invoice.getBalance());
            }
        }
        for (Invoice invoice : unpaidInvoices) {
            BigDecimal amountToPay;
            BigDecimal bigDecimal = amountToPay = remainingRequestPayment.compareTo(invoice.getBalance()) >= 0 ? invoice.getBalance() : remainingRequestPayment;
            if (amountToPay.compareTo(BigDecimal.ZERO) > 0) {
                UUID paymentMethodId = externalPayment != false ? null : (inputPaymentMethodId != null ? inputPaymentMethodId : account.getPaymentMethodId());
                this.createPurchaseForInvoice(account, invoice.getId(), amountToPay, paymentMethodId, externalPayment, null, null, pluginProperties, callContext);
            }
            if ((remainingRequestPayment = remainingRequestPayment.subtract(amountToPay)).compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        BigDecimal creditAmount = remainingRequestPayment;
        if (externalPayment.booleanValue() && remainingRequestPayment.compareTo(BigDecimal.ZERO) > 0) {
            this.invoiceApi.insertCredits(account.getId(), this.clock.getUTCToday(), (Iterable)ImmutableList.of((Object)this.createCreditItem(account.getId(), creditAmount, account.getCurrency())), true, pluginProperties, callContext);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/paymentMethods")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add a payment method", response=PaymentMethodJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment method created"), @ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response createPaymentMethod(@PathParam(value="accountId") UUID accountId, PaymentMethodJson json, @QueryParam(value="isDefault") @DefaultValue(value="false") Boolean isDefault, @QueryParam(value="payAllUnpaidInvoices") @DefaultValue(value="false") Boolean payAllUnpaidInvoices, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        List<Invoice> unpaidInvoices;
        this.verifyNonNullOrEmpty(json, "PaymentMethodJson body should be specified");
        this.verifyNonNullOrEmpty(json.getPluginName(), "PaymentMethodJson pluginName should be specified");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        PaymentMethod data = json.toPaymentMethod(accountId);
        Account account = this.accountUserApi.getAccountById(data.getAccountId(), (TenantContext)callContext);
        boolean hasDefaultPaymentMethod = account.getPaymentMethodId() != null || isDefault != false;
        Collection<Object> collection = unpaidInvoices = payAllUnpaidInvoices != false ? this.invoiceApi.getUnpaidInvoicesByAccountId(account.getId(), null, this.clock.getUTCToday(), (TenantContext)callContext) : Collections.emptyList();
        if (payAllUnpaidInvoices.booleanValue() && unpaidInvoices.size() > 0 && !hasDefaultPaymentMethod) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        UUID paymentMethodId = this.paymentApi.addPaymentMethodWithPaymentControl(account, data.getExternalKey(), data.getPluginName(), isDefault.booleanValue(), data.getPluginDetail(), pluginProperties, paymentOptions, callContext);
        if (payAllUnpaidInvoices.booleanValue() && unpaidInvoices.size() > 0) {
            for (Invoice invoice : unpaidInvoices) {
                this.createPurchaseForInvoice(account, invoice.getId(), invoice.getBalance(), paymentMethodId, false, null, null, pluginProperties, callContext);
            }
        }
        return this.uriBuilder.buildResponse(uriInfo, PaymentMethodResource.class, "getPaymentMethod", paymentMethodId, (ServletRequest)request);
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/paymentMethods")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account payment methods", response=PaymentMethodJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getPaymentMethodsForAccount(@PathParam(value="accountId") UUID accountId, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        final Account account = this.accountUserApi.getAccountById(accountId, tenantContext);
        List methods = this.paymentApi.getAccountPaymentMethods(account.getId(), includedDeleted.booleanValue(), withPluginInfo.booleanValue(), pluginProperties, tenantContext);
        final AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
        ArrayList json = new ArrayList(Collections2.transform((Collection)methods, (Function)new Function<PaymentMethod, PaymentMethodJson>(){

            public PaymentMethodJson apply(PaymentMethod input) {
                return PaymentMethodJson.toPaymentMethodJson(account, input, accountAuditLogs);
            }
        }));
        return Response.status((Response.Status)Response.Status.OK).entity(json).build();
    }

    @TimedResource
    @PUT
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/paymentMethods/refresh")
    @Produces(value={"application/json"})
    @ApiOperation(value="Refresh account payment methods")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response refreshPaymentMethods(@PathParam(value="accountId") UUID accountId, @QueryParam(value="pluginName") String pluginName, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        if (pluginName != null && !pluginName.isEmpty()) {
            this.paymentApi.refreshPaymentMethods(account, pluginName, pluginProperties, callContext);
        } else {
            this.paymentApi.refreshPaymentMethods(account, pluginProperties, callContext);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/paymentMethods/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}/setDefault")
    @ApiOperation(value="Set the default payment method")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account id or payment method id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response setDefaultPaymentMethod(@PathParam(value="accountId") UUID accountId, @PathParam(value="paymentMethodId") UUID paymentMethodId, @QueryParam(value="payAllUnpaidInvoices") @DefaultValue(value="false") Boolean payAllUnpaidInvoices, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        this.paymentApi.setDefaultPaymentMethod(account, paymentMethodId, pluginProperties, callContext);
        if (payAllUnpaidInvoices.booleanValue()) {
            Collection unpaidInvoices = this.invoiceApi.getUnpaidInvoicesByAccountId(account.getId(), null, this.clock.getUTCToday(), (TenantContext)callContext);
            for (Invoice invoice : unpaidInvoices) {
                this.createPurchaseForInvoice(account, invoice.getId(), invoice.getBalance(), paymentMethodId, false, null, null, pluginProperties, callContext);
            }
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account payments", response=PaymentJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response getPaymentsForAccount(@PathParam(value="accountId") UUID accountId, @QueryParam(value="withAttempts") @DefaultValue(value="false") Boolean withAttempts, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws PaymentApiException {
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        List payments = this.paymentApi.getAccountPayments(accountId, withPluginInfo.booleanValue(), withAttempts.booleanValue(), pluginProperties, tenantContext);
        final AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, auditMode.getLevel(), tenantContext);
        ImmutableList result = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)payments, (Function)new Function<Payment, PaymentJson>(){

            public PaymentJson apply(Payment payment) {
                return new PaymentJson(payment, accountAuditLogs);
            }
        }));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource(name="processPayment")
    @POST
    @Path(value="/payments")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Trigger a payment using the account external key (authorization, purchase or credit)", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment transaction created successfully"), @ApiResponse(code=400, message="Invalid account external key supplied"), @ApiResponse(code=404, message="Account not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response processPaymentByExternalKey(@MetricTag(tag="type", property="transactionType") PaymentTransactionJson json, @ApiParam(required=true) @QueryParam(value="externalKey") String externalKey, @QueryParam(value="paymentMethodId") UUID paymentMethodId, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        CallContext callContext = this.context.createCallContextNoAccountId(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountByKey(externalKey, (TenantContext)callContext);
        return this.processPayment(json, account, paymentMethodId, paymentControlPluginNames, pluginPropertiesString, uriInfo, callContext, request);
    }

    @TimedResource(name="processPayment")
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Trigger a payment (authorization, purchase or credit)", response=PaymentJson.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Payment transaction created successfully"), @ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found"), @ApiResponse(code=402, message="Transaction declined by gateway"), @ApiResponse(code=422, message="Payment is aborted by a control plugin"), @ApiResponse(code=502, message="Failed to submit payment transaction"), @ApiResponse(code=503, message="Payment in unknown status, failed to receive gateway response"), @ApiResponse(code=504, message="Payment operation timeout")})
    public Response processPayment(@PathParam(value="accountId") UUID accountId, @MetricTag(tag="type", property="transactionType") PaymentTransactionJson json, @QueryParam(value="paymentMethodId") UUID inputPaymentMethodId, @QueryParam(value="controlPluginName") List<String> paymentControlPluginNames, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        return this.processPayment(json, account, inputPaymentMethodId, paymentControlPluginNames, pluginPropertiesString, uriInfo, callContext, request);
    }

    private Response processPayment(PaymentTransactionJson json, Account account, UUID inputPaymentMethodId, List<String> paymentControlPluginNames, List<String> pluginPropertiesString, UriInfo uriInfo, CallContext callContext, HttpServletRequest request) throws PaymentApiException {
        Payment result;
        UUID paymentMethodId;
        this.verifyNonNullOrEmpty(json, "PaymentTransactionJson body should be specified");
        this.verifyNonNullOrEmpty(json.getTransactionType(), "PaymentTransactionJson transactionType needs to be set", json.getAmount(), "PaymentTransactionJson amount needs to be set");
        Iterable<PluginProperty> pluginProperties = this.extractPluginProperties(pluginPropertiesString, new PluginProperty[0]);
        Currency currency = json.getCurrency() == null ? account.getCurrency() : json.getCurrency();
        UUID paymentId = json.getPaymentId();
        if (paymentId != null) {
            Payment initialPayment = this.paymentApi.getPayment(paymentId, false, false, pluginProperties, (TenantContext)callContext);
            PaymentTransaction pendingOrSuccessTransaction = this.lookupPendingOrSuccessTransaction(initialPayment, json != null ? json.getTransactionId() : null, json != null ? json.getTransactionExternalKey() : null, json != null ? json.getTransactionType() : null);
            if (pendingOrSuccessTransaction.getTransactionStatus() == TransactionStatus.SUCCESS) {
                return this.uriBuilder.buildResponse(uriInfo, PaymentResource.class, "getPayment", pendingOrSuccessTransaction.getPaymentId(), (ServletRequest)request);
            }
            paymentMethodId = initialPayment.getPaymentMethodId();
        } else {
            paymentMethodId = inputPaymentMethodId == null ? account.getPaymentMethodId() : inputPaymentMethodId;
        }
        this.validatePaymentMethodForAccount(account.getId(), paymentMethodId, callContext);
        TransactionType transactionType = json.getTransactionType();
        PaymentOptions paymentOptions = this.createControlPluginApiPaymentOptions(paymentControlPluginNames);
        switch (transactionType) {
            case AUTHORIZE: {
                result = this.paymentApi.createAuthorizationWithPaymentControl(account, paymentMethodId, paymentId, json.getAmount(), currency, json.getEffectiveDate(), json.getPaymentExternalKey(), json.getTransactionExternalKey(), pluginProperties, paymentOptions, callContext);
                break;
            }
            case PURCHASE: {
                result = this.paymentApi.createPurchaseWithPaymentControl(account, paymentMethodId, paymentId, json.getAmount(), currency, json.getEffectiveDate(), json.getPaymentExternalKey(), json.getTransactionExternalKey(), pluginProperties, paymentOptions, callContext);
                break;
            }
            case CREDIT: {
                result = this.paymentApi.createCreditWithPaymentControl(account, paymentMethodId, paymentId, json.getAmount(), currency, json.getEffectiveDate(), json.getPaymentExternalKey(), json.getTransactionExternalKey(), pluginProperties, paymentOptions, callContext);
                break;
            }
            default: {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)("TransactionType " + transactionType + " is not allowed for an account")).build();
            }
        }
        return this.createPaymentResponse(uriInfo, result, transactionType, json.getTransactionExternalKey(), request);
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/overdue")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve overdue state for account", response=OverdueStateJson.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getOverdueAccount(@PathParam(value="accountId") UUID accountId, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException, OverdueException, OverdueApiException {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(accountId, tenantContext);
        OverdueState overdueState = this.overdueApi.getOverdueStateFor(account.getId(), tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new OverdueStateJson(overdueState)).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/block")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve blocking states for account", response=BlockingStateJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response getBlockingStates(@PathParam(value="accountId") UUID accountId, @QueryParam(value="blockingStateTypes") List<BlockingStateType> typeFilter, @QueryParam(value="blockingStateSvcs") List<String> svcsFilter, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws EntitlementApiException {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        Iterable blockingStates = this.subscriptionApi.getBlockingStates(accountId, typeFilter, svcsFilter, OrderingType.ASCENDING, 7, tenantContext);
        final AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, auditMode.getLevel(), tenantContext);
        ImmutableList result = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)blockingStates, (Function)new Function<BlockingState, BlockingStateJson>(){

            public BlockingStateJson apply(BlockingState input) {
                return new BlockingStateJson(input, accountAuditLogs);
            }
        }));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @TimedResource
    @GET
    @Path(value="/block/{blockingId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve blocking state audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Blocking state  not found")})
    public Response getBlockingStateAuditLogsWithHistory(@PathParam(value="blockingId") UUID blockingId, @javax.ws.rs.core.Context HttpServletRequest request) {
        TenantContext tenantContext = this.context.createTenantContextNoAccountId((ServletRequest)request);
        List auditLogWithHistory = this.subscriptionApi.getBlockingStateAuditLogsWithHistoryForId(blockingId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @TimedResource
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/block")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Block an account", response=BlockingStateJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Blocking state created successfully"), @ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response addAccountBlockingState(@PathParam(value="accountId") UUID id, BlockingStateJson json, @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="pluginProperty") List<String> pluginPropertiesString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws SubscriptionApiException, EntitlementApiException, AccountApiException {
        return this.addBlockingState(json, id, id, BlockingStateType.ACCOUNT, requestedDate, pluginPropertiesString, createdBy, reason, comment, request, uriInfo);
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account custom fields", response=CustomFieldJson.class, responseContainer="List", nickname="getAccountCustomFields")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response getCustomFields(@PathParam(value="accountId") UUID accountId, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) {
        return super.getCustomFields(accountId, auditMode, this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/allCustomFields")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account customFields", response=CustomFieldJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getAllCustomFields(@PathParam(value="accountId") UUID accountId, @QueryParam(value="objectType") ObjectType objectType, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        List customFields = objectType != null ? this.customFieldUserApi.getCustomFieldsForAccountType(accountId, objectType, tenantContext) : this.customFieldUserApi.getCustomFieldsForAccount(accountId, tenantContext);
        return this.createCustomFieldResponse(customFields, auditMode, tenantContext);
    }

    @TimedResource
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add custom fields to account", response=CustomField.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Custom field created successfully"), @ApiResponse(code=400, message="Invalid account id supplied")})
    public Response createAccountCustomFields(@PathParam(value="accountId") UUID accountId, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(accountId, customFields, this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request), uriInfo, request);
    }

    @TimedResource
    @PUT
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Modify custom fields to account")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account id supplied")})
    public Response modifyAccountCustomFields(@PathParam(value="accountId") UUID accountId, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws CustomFieldApiException {
        return super.modifyCustomFields(accountId, customFields, this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove custom fields from account")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account id supplied")})
    public Response deleteAccountCustomFields(@PathParam(value="accountId") UUID accountId, @QueryParam(value="customField") List<UUID> customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(accountId, customFieldList, this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account tags", response=TagJson.class, responseContainer="List", nickname="getAccountTags")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getTags(@PathParam(value="accountId") UUID accountId, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws TagDefinitionApiException {
        return super.getTags(accountId, accountId, auditMode, includedDeleted, this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request));
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/allTags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account tags", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response getAllTags(@PathParam(value="accountId") UUID accountId, @QueryParam(value="objectType") ObjectType objectType, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws TagDefinitionApiException {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        List tags = objectType != null ? this.tagUserApi.getTagsForAccountType(accountId, objectType, includedDeleted.booleanValue(), tenantContext) : this.tagUserApi.getTagsForAccount(accountId, includedDeleted.booleanValue(), tenantContext);
        return this.createTagResponse(accountId, tags, auditMode, tenantContext);
    }

    @TimedResource
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add tags to account", response=TagJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Tag created successfully"), @ApiResponse(code=400, message="Invalid account id supplied")})
    public Response createAccountTags(@PathParam(value="accountId") UUID accountId, List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context UriInfo uriInfo, @javax.ws.rs.core.Context HttpServletRequest request) throws TagApiException {
        return super.createTags(accountId, tagList, uriInfo, this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request), request);
    }

    @TimedResource
    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove tags from account")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account id supplied or account does not have a default payment method (AUTO_PAY_OFF tag only)")})
    public Response deleteAccountTags(@PathParam(value="accountId") UUID accountId, @QueryParam(value="tagDef") List<UUID> tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) throws TagApiException, AccountApiException {
        Account account;
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        boolean isTagAutoPayOff = false;
        for (UUID cur : tagList) {
            if (!cur.equals(ControlTagType.AUTO_PAY_OFF.getId())) continue;
            isTagAutoPayOff = true;
            break;
        }
        if (isTagAutoPayOff && (account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext)).getPaymentMethodId() == null) {
            throw new TagApiException(ErrorCode.TAG_CANNOT_BE_REMOVED, new Object[]{ControlTagType.AUTO_PAY_OFF, " the account does not have a default payment method"});
        }
        return super.deleteTags(accountId, tagList, callContext);
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emails")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve an account emails", response=AccountEmailJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid account id supplied")})
    public Response getEmails(@PathParam(value="accountId") UUID accountId, @javax.ws.rs.core.Context HttpServletRequest request) {
        List emails = this.accountUserApi.getEmails(accountId, this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request));
        ArrayList<AccountEmailJson> emailsJson = new ArrayList<AccountEmailJson>();
        for (AccountEmail email : emails) {
            emailsJson.add(new AccountEmailJson(email.getAccountId(), email.getEmail()));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(emailsJson).build();
    }

    @TimedResource
    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emails")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add account email", response=AccountEmailJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=201, message="Email created successfully"), @ApiResponse(code=400, message="Invalid account id supplied"), @ApiResponse(code=404, message="Account not found")})
    public Response addEmail(@PathParam(value="accountId") UUID accountId, final AccountEmailJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws AccountApiException {
        this.verifyNonNullOrEmpty(json, "AccountEmailJson body should be specified");
        this.verifyNonNullOrEmpty(json.getEmail(), "AccountEmailJson email needs to be set");
        CallContext callContext = this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request);
        this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        AccountEmail existingEmail = (AccountEmail)Iterables.tryFind((Iterable)this.accountUserApi.getEmails(accountId, (TenantContext)callContext), (Predicate)new Predicate<AccountEmail>(){

            public boolean apply(AccountEmail input) {
                return input.getEmail().equals(json.getEmail());
            }
        }).orNull();
        if (existingEmail == null) {
            this.accountUserApi.addEmail(accountId, json.toAccountEmail(UUIDs.randomUUID()), callContext);
        }
        return this.uriBuilder.buildResponse(uriInfo, AccountResource.class, "getEmails", json.getAccountId(), (ServletRequest)request);
    }

    @TimedResource
    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emails/{email}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete email from account")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Invalid account id supplied")})
    public Response removeEmail(@PathParam(value="accountId") UUID accountId, @PathParam(value="email") String email, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request) {
        List emails = this.accountUserApi.getEmails(accountId, this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request));
        for (AccountEmail cur : emails) {
            if (!cur.getEmail().equals(email)) continue;
            AccountEmailJson accountEmailJson = new AccountEmailJson(accountId, email);
            AccountEmail accountEmail = accountEmailJson.toAccountEmail(cur.getId());
            this.accountUserApi.removeEmail(accountId, accountEmail, this.context.createCallContextWithAccountId(accountId, createdBy, reason, comment, (ServletRequest)request));
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emails/{accountEmailId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account email audit logs with history by id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response getAccountEmailAuditLogsWithHistory(@PathParam(value="accountId") UUID accountId, @PathParam(value="accountEmailId") UUID accountEmailId, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        List auditLogWithHistory = this.accountUserApi.getEmailAuditLogsWithHistoryForId(accountEmailId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.ACCOUNT;
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/children")
    @Produces(value={"application/json"})
    @ApiOperation(value="List children accounts", response=AccountJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid parent account id supplied"), @ApiResponse(code=404, message="Parent Account not found")})
    public Response getChildrenAccounts(@PathParam(value="accountId") UUID parentAccountId, @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(parentAccountId, (ServletRequest)request);
        List accounts = this.accountUserApi.getChildrenAccounts(parentAccountId, tenantContext);
        ArrayList<AccountJson> accountJson = new ArrayList<AccountJson>();
        for (Account account : accounts) {
            AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
            accountJson.add(this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(accountJson).build();
    }

    @TimedResource
    @PUT
    @Path(value="/{childAccountId:\\w+-\\w+-\\w+-\\w+-\\w+}/transferCredit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Move a given child credit to the parent level")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="Account does not have credit"), @ApiResponse(code=404, message="Account not found")})
    public Response transferChildCreditToParent(@PathParam(value="childAccountId") UUID childAccountId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @javax.ws.rs.core.Context HttpServletRequest request, @javax.ws.rs.core.Context UriInfo uriInfo) throws InvoiceApiException {
        CallContext callContext = this.context.createCallContextWithAccountId(childAccountId, createdBy, reason, comment, (ServletRequest)request);
        this.invoiceApi.transferChildCreditToParent(childAccountId, callContext);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogs")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve audit logs by account id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response getAccountAuditLogs(@PathParam(value="accountId") UUID accountId, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogs(accountAuditLogs)).build();
    }

    @TimedResource
    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/auditLogsWithHistory")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve account audit logs with history by account id", response=AuditLogJson.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=404, message="Account not found")})
    public Response getAccountAuditLogsWithHistory(@PathParam(value="accountId") UUID accountId, @javax.ws.rs.core.Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createTenantContextWithAccountId(accountId, (ServletRequest)request);
        List auditLogWithHistory = this.accountUserApi.getAuditLogsWithHistoryForId(accountId, AuditLevel.FULL, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity(this.getAuditLogsWithHistory(auditLogWithHistory)).build();
    }

    private List<AuditLogJson> getAuditLogs(AccountAuditLogs accountAuditLogs) {
        if (accountAuditLogs.getAuditLogs() == null) {
            return null;
        }
        return ImmutableList.copyOf((Collection)Collections2.transform((Collection)accountAuditLogs.getAuditLogs(), (Function)new Function<AuditLog, AuditLogJson>(){

            public AuditLogJson apply(@Nullable AuditLog input) {
                return new AuditLogJson(input);
            }
        }));
    }

    private InvoiceItem createCreditItem(final UUID accountId, final BigDecimal creditAmount, final Currency currency) {
        return new InvoiceItem(){

            public InvoiceItemType getInvoiceItemType() {
                return InvoiceItemType.CREDIT_ADJ;
            }

            public UUID getInvoiceId() {
                return null;
            }

            public UUID getAccountId() {
                return accountId;
            }

            public UUID getChildAccountId() {
                return null;
            }

            public LocalDate getStartDate() {
                return null;
            }

            public LocalDate getEndDate() {
                return null;
            }

            public BigDecimal getAmount() {
                return creditAmount;
            }

            public Currency getCurrency() {
                return currency;
            }

            public String getDescription() {
                return "pay all invoices";
            }

            public UUID getBundleId() {
                return null;
            }

            public UUID getSubscriptionId() {
                return null;
            }

            public String getProductName() {
                return null;
            }

            public String getPrettyProductName() {
                return null;
            }

            public String getPlanName() {
                return null;
            }

            public String getPrettyPlanName() {
                return null;
            }

            public String getPhaseName() {
                return null;
            }

            public String getPrettyPhaseName() {
                return null;
            }

            public String getUsageName() {
                return null;
            }

            public String getPrettyUsageName() {
                return null;
            }

            public BigDecimal getRate() {
                return null;
            }

            public UUID getLinkedItemId() {
                return null;
            }

            public Integer getQuantity() {
                return null;
            }

            public String getItemDetails() {
                return null;
            }

            public DateTime getCatalogEffectiveDate() {
                return null;
            }

            public boolean matches(Object o) {
                return false;
            }

            public UUID getId() {
                return null;
            }

            public DateTime getCreatedDate() {
                return null;
            }

            public DateTime getUpdatedDate() {
                return null;
            }
        };
    }
}

