/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.mappers;

import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.jaxrs.mappers.ExceptionMapperBase;
import org.killbill.billing.util.api.TagDefinitionApiException;

@Singleton
@Provider
public class TagDefinitionApiExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<TagDefinitionApiException> {
    private final UriInfo uriInfo;

    public TagDefinitionApiExceptionMapper(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public Response toResponse(TagDefinitionApiException exception) {
        if (exception.getCode() == ErrorCode.TAG_DEFINITION_ALREADY_EXISTS.getCode()) {
            return this.buildConflictingRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.TAG_DEFINITION_CONFLICTS_WITH_CONTROL_TAG.getCode()) {
            return this.buildConflictingRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.TAG_DEFINITION_DOES_NOT_EXIST.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.TAG_DEFINITION_IN_USE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
    }
}

