/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.mappers;

import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.jaxrs.mappers.ExceptionMapperBase;
import org.killbill.billing.jaxrs.mappers.LoggingResponse;
import org.killbill.billing.payment.api.PaymentApiException;

@Singleton
@Provider
public class PaymentApiExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<PaymentApiException> {
    private final UriInfo uriInfo;

    public PaymentApiExceptionMapper(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public Response toResponse(PaymentApiException exception) {
        if (exception.getCode() == ErrorCode.PAYMENT_ADD_PAYMENT_METHOD.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_CREATE_PAYMENT.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_REFUND_AMOUNT_NEGATIVE_OR_NULL.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_DEL_DEFAULT_PAYMENT_METHOD.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_DEL_PAYMENT_METHOD.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_GET_PAYMENT_METHODS.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_INTERNAL_ERROR.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_NO_DEFAULT_PAYMENT_METHOD.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_NO_SUCH_PAYMENT.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_NO_SUCH_PAYMENT_METHOD.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_NO_SUCH_SUCCESS_PAYMENT.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_NULL_INVOICE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_PLUGIN_TIMEOUT.getCode()) {
            return this.buildPluginTimeoutResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_PLUGIN_GET_PAYMENT_INFO.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_REFRESH_PAYMENT_METHOD.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_UPD_PAYMENT_METHOD.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_INVALID_PARAMETER.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.PAYMENT_PLUGIN_API_ABORTED.getCode()) {
            return this.buildPaymentAbortedResponse(exception, this.uriInfo);
        }
        return this.fallback((Exception)exception, this.uriInfo);
    }

    private Response buildPaymentAbortedResponse(PaymentApiException exception, UriInfo uriInfo) {
        Response.ResponseBuilder responseBuilder = Response.status((int)422);
        this.serializeException((Exception)exception, uriInfo, responseBuilder);
        return new LoggingResponse((Exception)exception, responseBuilder.build());
    }
}

