/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.mappers;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingResponse
extends Response {
    private static final Logger log = LoggerFactory.getLogger(LoggingResponse.class);
    private final Exception e;
    private final Response response;

    public LoggingResponse(Exception e, Response response) {
        this.e = e;
        this.response = response;
    }

    public Object getEntity() {
        if (this.response.getStatus() == Response.Status.CONFLICT.getStatusCode()) {
            log.warn("Conflicting request", (Throwable)this.e);
        } else if (this.response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            log.debug("Not found", (Throwable)this.e);
        } else if (this.response.getStatus() == Response.Status.BAD_REQUEST.getStatusCode()) {
            log.warn("Bad request", (Throwable)this.e);
        } else if (this.response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            log.debug("Authorization error", (Throwable)this.e);
        } else if (this.response.getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            log.warn("Internal error", (Throwable)this.e);
        }
        return this.response.getEntity();
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.response.getMetadata();
    }
}

