/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.mappers;

import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.jaxrs.mappers.ExceptionMapperBase;

@Singleton
@Provider
public class InvoiceApiExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<InvoiceApiException> {
    private final UriInfo uriInfo;

    public InvoiceApiExceptionMapper(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public Response toResponse(InvoiceApiException exception) {
        if (exception.getCode() == ErrorCode.INVOICE_ACCOUNT_ID_INVALID.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_INVALID_DATE_SEQUENCE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_INVALID_TRANSITION.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_NO_ACCOUNT_ID_FOR_SUBSCRIPTION_ID.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_NO_SUCH_CREDIT.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_NOT_FOUND.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_NOTHING_TO_DO.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_PAYMENT_BY_ATTEMPT_NOT_FOUND.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_PAYMENT_NOT_FOUND.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_TARGET_DATE_TOO_FAR_IN_THE_FUTURE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.CREDIT_AMOUNT_INVALID.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_ITEM_ADJUSTMENT_AMOUNT_SHOULD_BE_POSITIVE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_ITEM_NOT_FOUND.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_NO_SUCH_EXTERNAL_CHARGE.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.EXTERNAL_CHARGE_AMOUNT_INVALID.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.CURRENCY_INVALID.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_ITEM_ADJUSTMENT_ITEM_INVALID.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.INVOICE_ITEM_TYPE_INVALID.getCode()) {
            return this.buildBadRequestResponse((Exception)exception, this.uriInfo);
        }
        return this.fallback((Exception)exception, this.uriInfo);
    }
}

