/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.mappers;

import com.fasterxml.jackson.core.JsonProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.entitlement.api.BlockingApiException;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entity.EntityPersistenceException;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.jaxrs.json.BillingExceptionJson;
import org.killbill.billing.jaxrs.mappers.AccountApiExceptionMapper;
import org.killbill.billing.jaxrs.mappers.BlockingApiExceptionMapper;
import org.killbill.billing.jaxrs.mappers.CatalogApiExceptionMapper;
import org.killbill.billing.jaxrs.mappers.EntitlementApiExceptionMapper;
import org.killbill.billing.jaxrs.mappers.EntityPersistenceExceptionMapper;
import org.killbill.billing.jaxrs.mappers.InvoiceApiExceptionMapper;
import org.killbill.billing.jaxrs.mappers.LoggingResponse;
import org.killbill.billing.jaxrs.mappers.OverdueApiExceptionMapper;
import org.killbill.billing.jaxrs.mappers.PaymentApiExceptionMapper;
import org.killbill.billing.jaxrs.mappers.SubscriptionApiExceptionMapper;
import org.killbill.billing.jaxrs.mappers.SubscriptionBillingApiExceptionMapper;
import org.killbill.billing.jaxrs.mappers.SubscriptionRepairExceptionMapper;
import org.killbill.billing.jaxrs.mappers.TagApiExceptionMapper;
import org.killbill.billing.jaxrs.mappers.TagDefinitionApiExceptionMapper;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.subscription.api.SubscriptionBillingApiException;
import org.killbill.billing.subscription.api.timeline.SubscriptionBaseRepairException;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExceptionMapperBase {
    private static final Logger log = LoggerFactory.getLogger(ExceptionMapperBase.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String QUERY_WITH_STACK_TRACE = "withStackTrace";

    protected Response fallback(Exception exception, UriInfo uriInfo) {
        if (exception.getCause() == null) {
            return this.buildBadRequestResponse(exception, uriInfo);
        }
        return this.doFallback(exception, uriInfo);
    }

    private Response doFallback(Exception exception, UriInfo uriInfo) {
        if (!(exception.getCause() instanceof BillingExceptionBase)) {
            return this.buildBadRequestResponse(exception, uriInfo);
        }
        BillingExceptionBase cause = (BillingExceptionBase)exception.getCause();
        if (cause instanceof AccountApiException) {
            AccountApiExceptionMapper mapper = new AccountApiExceptionMapper(uriInfo);
            return mapper.toResponse((AccountApiException)cause);
        }
        if (cause instanceof BlockingApiException) {
            BlockingApiExceptionMapper mapper = new BlockingApiExceptionMapper(uriInfo);
            return mapper.toResponse((BlockingApiException)cause);
        }
        if (cause instanceof CatalogApiException) {
            CatalogApiExceptionMapper mapper = new CatalogApiExceptionMapper(uriInfo);
            return mapper.toResponse((CatalogApiException)cause);
        }
        if (cause instanceof EntitlementApiException) {
            EntitlementApiExceptionMapper mapper = new EntitlementApiExceptionMapper(uriInfo);
            return mapper.toResponse((EntitlementApiException)cause);
        }
        if (cause instanceof EntityPersistenceException) {
            EntityPersistenceExceptionMapper mapper = new EntityPersistenceExceptionMapper(uriInfo);
            return mapper.toResponse((EntityPersistenceException)cause);
        }
        if (cause instanceof InvoiceApiException) {
            InvoiceApiExceptionMapper mapper = new InvoiceApiExceptionMapper(uriInfo);
            return mapper.toResponse((InvoiceApiException)cause);
        }
        if (cause instanceof OverdueApiException) {
            OverdueApiExceptionMapper mapper = new OverdueApiExceptionMapper(uriInfo);
            return mapper.toResponse((OverdueApiException)cause);
        }
        if (cause instanceof PaymentApiException) {
            PaymentApiExceptionMapper mapper = new PaymentApiExceptionMapper(uriInfo);
            return mapper.toResponse((PaymentApiException)cause);
        }
        if (cause instanceof SubscriptionApiException) {
            SubscriptionApiExceptionMapper mapper = new SubscriptionApiExceptionMapper(uriInfo);
            return mapper.toResponse((SubscriptionApiException)cause);
        }
        if (cause instanceof SubscriptionBillingApiException) {
            SubscriptionBillingApiExceptionMapper mapper = new SubscriptionBillingApiExceptionMapper(uriInfo);
            return mapper.toResponse((SubscriptionBillingApiException)cause);
        }
        if (cause instanceof SubscriptionBaseRepairException) {
            SubscriptionRepairExceptionMapper mapper = new SubscriptionRepairExceptionMapper(uriInfo);
            return mapper.toResponse((SubscriptionBaseRepairException)cause);
        }
        if (cause instanceof TagApiException) {
            TagApiExceptionMapper mapper = new TagApiExceptionMapper(uriInfo);
            return mapper.toResponse((TagApiException)cause);
        }
        if (cause instanceof TagDefinitionApiException) {
            TagDefinitionApiExceptionMapper mapper = new TagDefinitionApiExceptionMapper(uriInfo);
            return mapper.toResponse((TagDefinitionApiException)cause);
        }
        return this.buildBadRequestResponse((Exception)cause, uriInfo);
    }

    protected Response buildConflictingRequestResponse(Exception e, UriInfo uriInfo) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.CONFLICT);
        this.serializeException(e, uriInfo, responseBuilder);
        return new LoggingResponse(e, responseBuilder.build());
    }

    protected Response buildNotFoundResponse(Exception e, UriInfo uriInfo) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.NOT_FOUND);
        this.serializeException(e, uriInfo, responseBuilder);
        return new LoggingResponse(e, responseBuilder.build());
    }

    protected Response buildBadRequestResponse(Exception e, UriInfo uriInfo) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        this.serializeException(e, uriInfo, responseBuilder);
        return new LoggingResponse(e, responseBuilder.build());
    }

    protected Response buildAuthorizationErrorResponse(Exception e, UriInfo uriInfo) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        this.serializeException(e, uriInfo, responseBuilder);
        return new LoggingResponse(e, responseBuilder.build());
    }

    protected Response buildInternalErrorResponse(Exception e, UriInfo uriInfo) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        this.serializeException(e, uriInfo, responseBuilder);
        return new LoggingResponse(e, responseBuilder.build());
    }

    protected Response buildPluginTimeoutResponse(Exception e, UriInfo uriInfo) {
        Response.ResponseBuilder responseBuilder = Response.status((int)504);
        this.serializeException(e, uriInfo, responseBuilder);
        return new LoggingResponse(e, responseBuilder.build());
    }

    protected void serializeException(Exception e, UriInfo uriInfo, Response.ResponseBuilder responseBuilder) {
        boolean withStackTrace = uriInfo.getQueryParameters() != null && "true".equals(uriInfo.getQueryParameters().getFirst((Object)QUERY_WITH_STACK_TRACE));
        BillingExceptionJson billingExceptionJson = new BillingExceptionJson(e, withStackTrace);
        try {
            String billingExceptionJsonAsString = mapper.writeValueAsString((Object)billingExceptionJson);
            responseBuilder.entity((Object)billingExceptionJsonAsString).type("application/json");
        }
        catch (JsonProcessingException jsonException) {
            log.warn("Unable to serialize exception", (Throwable)jsonException);
            responseBuilder.entity((Object)e.toString()).type(MediaType.TEXT_PLAIN_TYPE);
        }
    }
}

