/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.mappers;

import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.jaxrs.mappers.ExceptionMapperBase;

@Singleton
@Provider
public class EntitlementApiExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<EntitlementApiException> {
    private final UriInfo uriInfo;

    public EntitlementApiExceptionMapper(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public Response toResponse(EntitlementApiException exception) {
        if (exception.getCode() == ErrorCode.SUB_CANCEL_BAD_STATE.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_CHANGE_NON_ACTIVE.getCode()) {
            return this.buildInternalErrorResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_INVALID_SUBSCRIPTION_ID.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        if (exception.getCode() == ErrorCode.SUB_INVALID_SUBSCRIPTION_EXTERNAL_KEY.getCode()) {
            return this.buildNotFoundResponse((Exception)exception, this.uriInfo);
        }
        return this.fallback((Exception)exception, this.uriInfo);
    }
}

