/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.ObjectType;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.TagDefinition;

@ApiModel(value="Tag", parent=JsonBase.class)
public class TagJson
extends JsonBase {
    private final UUID tagId;
    @ApiModelProperty(dataType="org.killbill.billing.ObjectType")
    private final ObjectType objectType;
    private final UUID objectId;
    private final UUID tagDefinitionId;
    private final String tagDefinitionName;

    @JsonCreator
    public TagJson(@JsonProperty(value="tagId") UUID tagId, @JsonProperty(value="objectType") ObjectType objectType, @JsonProperty(value="objectId") UUID objectId, @JsonProperty(value="tagDefinitionId") UUID tagDefinitionId, @JsonProperty(value="tagDefinitionName") String tagDefinitionName, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.tagId = tagId;
        this.objectType = objectType;
        this.objectId = objectId;
        this.tagDefinitionId = tagDefinitionId;
        this.tagDefinitionName = tagDefinitionName;
    }

    public TagJson(Tag tag, TagDefinition tagDefinition, @Nullable List<AuditLog> auditLogs) {
        this(tag.getId(), tag.getObjectType(), tag.getObjectId(), tagDefinition.getId(), tagDefinition.getName(), (List<AuditLogJson>)TagJson.toAuditLogJson(auditLogs));
    }

    public UUID getTagId() {
        return this.tagId;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public UUID getTagDefinitionId() {
        return this.tagDefinitionId;
    }

    public String getTagDefinitionName() {
        return this.tagDefinitionName;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TagJson{");
        sb.append("tagId='").append(this.tagId).append('\'');
        sb.append(", objectType=").append(this.objectType);
        sb.append(", objectId=").append(this.objectId);
        sb.append(", tagDefinitionId='").append(this.tagDefinitionId).append('\'');
        sb.append(", tagDefinitionName='").append(this.tagDefinitionName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagJson tagJson = (TagJson)o;
        if (this.objectType != tagJson.objectType) {
            return false;
        }
        if (this.tagDefinitionId != null ? !this.tagDefinitionId.equals(tagJson.tagDefinitionId) : tagJson.tagDefinitionId != null) {
            return false;
        }
        if (this.objectId != null ? !this.objectId.equals(tagJson.objectId) : tagJson.objectId != null) {
            return false;
        }
        if (this.tagDefinitionName != null ? !this.tagDefinitionName.equals(tagJson.tagDefinitionName) : tagJson.tagDefinitionName != null) {
            return false;
        }
        return !(this.tagId != null ? !this.tagId.equals(tagJson.tagId) : tagJson.tagId != null);
    }

    public int hashCode() {
        int result = this.tagId != null ? this.tagId.hashCode() : 0;
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        result = 31 * result + (this.tagDefinitionId != null ? this.tagDefinitionId.hashCode() : 0);
        result = 31 * result + (this.objectId != null ? this.objectId.hashCode() : 0);
        result = 31 * result + (this.tagDefinitionName != null ? this.tagDefinitionName.hashCode() : 0);
        return result;
    }
}

