/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.ObjectType;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.tag.TagDefinition;

@ApiModel(value="TagDefinition", parent=JsonBase.class)
public class TagDefinitionJson
extends JsonBase {
    private final UUID id;
    private final Boolean isControlTag;
    @ApiModelProperty(required=true)
    private final String name;
    @ApiModelProperty(required=true)
    private final String description;
    private final Set<ObjectType> applicableObjectTypes;

    @JsonCreator
    public TagDefinitionJson(@JsonProperty(value="id") UUID id, @JsonProperty(value="isControlTag") Boolean isControlTag, @JsonProperty(value="name") String name, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="applicableObjectTypes") @Nullable List<ObjectType> applicableObjectTypes, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.id = id;
        this.isControlTag = isControlTag;
        this.name = name;
        this.description = description;
        this.applicableObjectTypes = new HashSet<ObjectType>(applicableObjectTypes);
    }

    public TagDefinitionJson(TagDefinition tagDefinition, @Nullable List<AuditLog> auditLogs) {
        this(tagDefinition.getId(), tagDefinition.isControlTag(), tagDefinition.getName(), tagDefinition.getDescription(), tagDefinition.getApplicableObjectTypes(), (List<AuditLogJson>)TagDefinitionJson.toAuditLogJson(auditLogs));
    }

    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="isControlTag")
    public Boolean isControlTag() {
        return this.isControlTag;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<ObjectType> getApplicableObjectTypes() {
        return this.applicableObjectTypes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TagDefinitionJson");
        sb.append("{id='").append(this.id).append('\'');
        sb.append(", isControlTag=").append(this.isControlTag);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", applicableObjectTypes='").append(this.applicableObjectTypes).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagDefinitionJson that = (TagDefinitionJson)o;
        if (!this.equalsNoId(that)) {
            return false;
        }
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public boolean equalsNoId(TagDefinitionJson that) {
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.isControlTag != null ? !this.isControlTag.equals(that.isControlTag) : that.isControlTag != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.applicableObjectTypes != null ? !this.applicableObjectTypes.equals(that.applicableObjectTypes) : that.applicableObjectTypes != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.isControlTag != null ? this.isControlTag.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.applicableObjectTypes != null ? this.applicableObjectTypes.hashCode() : 0);
        return result;
    }

    public static Set<ObjectType> toObjectType(Set<String> applicableObjectTypes) {
        return ImmutableSet.copyOf((Collection)Collections2.transform(applicableObjectTypes, (Function)new Function<String, ObjectType>(){

            public ObjectType apply(String input) {
                return ObjectType.valueOf((String)input);
            }
        }));
    }
}

