/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.usage.api.SubscriptionUsageRecord;
import org.killbill.billing.usage.api.UnitUsageRecord;
import org.killbill.billing.usage.api.UsageRecord;

@ApiModel(value="SubscriptionUsageRecord")
public class SubscriptionUsageRecordJson {
    @ApiModelProperty(required=true)
    private final UUID subscriptionId;
    @ApiModelProperty(required=true)
    private final List<UnitUsageRecordJson> unitUsageRecords;
    @ApiModelProperty(required=false)
    private final String trackingId;

    @JsonCreator
    public SubscriptionUsageRecordJson(@JsonProperty(value="subscriptionId") UUID subscriptionId, @JsonProperty(value="trackingId") String trackingId, @JsonProperty(value="unitUsageRecords") List<UnitUsageRecordJson> unitUsageRecords) {
        this.subscriptionId = subscriptionId;
        this.trackingId = trackingId;
        this.unitUsageRecords = unitUsageRecords;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public List<UnitUsageRecordJson> getUnitUsageRecords() {
        return this.unitUsageRecords;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public SubscriptionUsageRecord toSubscriptionUsageRecord() {
        ImmutableList tmp = ImmutableList.copyOf((Iterable)Iterables.transform(this.unitUsageRecords, (Function)new Function<UnitUsageRecordJson, UnitUsageRecord>(){

            public UnitUsageRecord apply(UnitUsageRecordJson input) {
                return input.toUnitUsageRecord();
            }
        }));
        SubscriptionUsageRecord result = new SubscriptionUsageRecord(this.subscriptionId, this.trackingId, (List)tmp);
        return result;
    }

    @ApiModel(value="UsageRecord")
    public static class UsageRecordJson {
        private final LocalDate recordDate;
        private final Long amount;

        @JsonCreator
        public UsageRecordJson(@JsonProperty(value="recordDate") LocalDate recordDate, @JsonProperty(value="amount") Long amount) {
            this.recordDate = recordDate;
            this.amount = amount;
        }

        public LocalDate getRecordDate() {
            return this.recordDate;
        }

        public Long getAmount() {
            return this.amount;
        }

        public UsageRecord toUsageRecord() {
            return new UsageRecord(this.recordDate, this.amount);
        }
    }

    @ApiModel(value="UnitUsageRecord")
    public static class UnitUsageRecordJson {
        private final String unitType;
        private final List<UsageRecordJson> usageRecords;

        @JsonCreator
        public UnitUsageRecordJson(@JsonProperty(value="unitType") String unitType, @JsonProperty(value="usageRecords") List<UsageRecordJson> usageRecords) {
            this.unitType = unitType;
            this.usageRecords = usageRecords;
        }

        public String getUnitType() {
            return this.unitType;
        }

        public List<UsageRecordJson> getUsageRecords() {
            return this.usageRecords;
        }

        public UnitUsageRecord toUnitUsageRecord() {
            ImmutableList tmp = ImmutableList.copyOf((Iterable)Iterables.transform(this.usageRecords, (Function)new Function<UsageRecordJson, UsageRecord>(){

                public UsageRecord apply(UsageRecordJson input) {
                    return input.toUsageRecord();
                }
            }));
            return new UnitUsageRecord(this.unitType, (List)tmp);
        }
    }
}

