/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.ObjectType;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionEvent;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.PhasePriceJson;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.audit.AuditLog;

@ApiModel(value="Subscription", parent=JsonBase.class)
public class SubscriptionJson
extends JsonBase {
    private final UUID accountId;
    private final UUID bundleId;
    private final UUID subscriptionId;
    private final String externalKey;
    private final String bundleExternalKey;
    private final LocalDate startDate;
    @ApiModelProperty(required=true)
    private final String productName;
    private final ProductCategory productCategory;
    @ApiModelProperty(required=true)
    private final BillingPeriod billingPeriod;
    private final PhaseType phaseType;
    @ApiModelProperty(required=true)
    private final String priceList;
    @ApiModelProperty(required=true)
    private final String planName;
    private final Entitlement.EntitlementState state;
    private final Entitlement.EntitlementSourceType sourceType;
    private final LocalDate cancelledDate;
    private final LocalDate chargedThroughDate;
    private final LocalDate billingStartDate;
    private final LocalDate billingEndDate;
    private final Integer billCycleDayLocal;
    private final List<EventSubscriptionJson> events;
    private final List<PhasePriceJson> prices;
    private final List<PhasePriceJson> priceOverrides;

    @JsonCreator
    public SubscriptionJson(@JsonProperty(value="accountId") @Nullable UUID accountId, @JsonProperty(value="bundleId") @Nullable UUID bundleId, @JsonProperty(value="bundleExternalKey") @Nullable String bundleExternalKey, @JsonProperty(value="subscriptionId") @Nullable UUID subscriptionId, @JsonProperty(value="externalKey") @Nullable String externalKey, @JsonProperty(value="startDate") @Nullable LocalDate startDate, @JsonProperty(value="productName") @Nullable String productName, @JsonProperty(value="productCategory") @Nullable ProductCategory productCategory, @JsonProperty(value="billingPeriod") @Nullable BillingPeriod billingPeriod, @JsonProperty(value="phaseType") @Nullable PhaseType phaseType, @JsonProperty(value="priceList") @Nullable String priceList, @JsonProperty(value="planName") @Nullable String planName, @JsonProperty(value="state") @Nullable Entitlement.EntitlementState state, @JsonProperty(value="sourceType") @Nullable Entitlement.EntitlementSourceType sourceType, @JsonProperty(value="cancelledDate") @Nullable LocalDate cancelledDate, @JsonProperty(value="chargedThroughDate") @Nullable LocalDate chargedThroughDate, @JsonProperty(value="billingStartDate") @Nullable LocalDate billingStartDate, @JsonProperty(value="billingEndDate") @Nullable LocalDate billingEndDate, @JsonProperty(value="billCycleDayLocal") @Nullable Integer billCycleDayLocal, @JsonProperty(value="events") @Nullable List<EventSubscriptionJson> events, @JsonProperty(value="priceOverrides") List<PhasePriceJson> priceOverrides, @JsonProperty(value="prices") List<PhasePriceJson> prices, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.startDate = startDate;
        this.productName = productName;
        this.productCategory = productCategory;
        this.billingPeriod = billingPeriod;
        this.phaseType = phaseType;
        this.priceList = priceList;
        this.planName = planName;
        this.state = state;
        this.sourceType = sourceType;
        this.cancelledDate = cancelledDate;
        this.chargedThroughDate = chargedThroughDate;
        this.billingStartDate = billingStartDate;
        this.billingEndDate = billingEndDate;
        this.billCycleDayLocal = billCycleDayLocal;
        this.accountId = accountId;
        this.bundleId = bundleId;
        this.subscriptionId = subscriptionId;
        this.externalKey = externalKey;
        this.bundleExternalKey = bundleExternalKey;
        this.events = events;
        this.priceOverrides = priceOverrides;
        this.prices = prices;
    }

    public SubscriptionJson(Subscription subscription, @Nullable Currency currency, @Nullable AccountAuditLogs accountAuditLogs) throws CatalogApiException {
        super((List<AuditLogJson>)SubscriptionJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForSubscription(subscription.getId())));
        SubscriptionEvent firstEvent;
        this.startDate = subscription.getEffectiveStartDate();
        List subscriptionEvents = subscription.getSubscriptionEvents();
        SubscriptionEvent subscriptionEvent = firstEvent = subscriptionEvents.isEmpty() ? null : (SubscriptionEvent)subscriptionEvents.get(0);
        this.productName = subscription.getLastActiveProduct() == null ? (firstEvent == null || firstEvent.getNextProduct() == null ? null : firstEvent.getNextProduct().getName()) : subscription.getLastActiveProduct().getName();
        this.productCategory = subscription.getLastActiveProductCategory() == null ? (firstEvent == null || firstEvent.getNextProduct() == null ? null : firstEvent.getNextProduct().getCategory()) : subscription.getLastActiveProductCategory();
        this.billingPeriod = subscription.getLastActivePlan() == null ? (firstEvent == null || firstEvent.getNextPlan() == null ? null : firstEvent.getNextPlan().getRecurringBillingPeriod()) : subscription.getLastActivePlan().getRecurringBillingPeriod();
        this.phaseType = subscription.getLastActivePhase() == null ? (firstEvent == null || firstEvent.getNextPhase() == null ? null : firstEvent.getNextPhase().getPhaseType()) : subscription.getLastActivePhase().getPhaseType();
        this.priceList = subscription.getLastActivePriceList() == null ? (firstEvent == null || firstEvent.getNextPriceList() == null ? null : firstEvent.getNextPriceList().getName()) : subscription.getLastActivePriceList().getName();
        this.planName = subscription.getLastActivePlan() == null ? (firstEvent == null || firstEvent.getNextPlan() == null ? null : firstEvent.getNextPlan().getName()) : subscription.getLastActivePlan().getName();
        this.state = subscription.getState();
        this.sourceType = subscription.getSourceType();
        this.cancelledDate = subscription.getEffectiveEndDate();
        this.chargedThroughDate = subscription.getChargedThroughDate();
        this.billingStartDate = subscription.getBillingStartDate();
        this.billingEndDate = subscription.getBillingEndDate();
        this.billCycleDayLocal = subscription.getBillCycleDayLocal();
        this.accountId = subscription.getAccountId();
        this.bundleId = subscription.getBundleId();
        this.subscriptionId = subscription.getId();
        this.externalKey = subscription.getExternalKey();
        this.bundleExternalKey = subscription.getBundleExternalKey();
        this.events = new LinkedList<EventSubscriptionJson>();
        this.prices = new ArrayList<PhasePriceJson>();
        String currentPhaseName = null;
        String currentPlanName = null;
        for (SubscriptionEvent subscriptionEvent2 : subscriptionEvents) {
            PlanPhase curPlanPhase;
            this.events.add(new EventSubscriptionJson(subscriptionEvent2, accountAuditLogs));
            if (currency == null) continue;
            Plan curPlan = subscriptionEvent2.getNextPlan();
            if (!(curPlan == null || currentPlanName != null && curPlan.getName().equals(currentPlanName))) {
                currentPlanName = curPlan.getName();
            }
            if ((curPlanPhase = subscriptionEvent2.getNextPhase()) == null || curPlanPhase.getName().equals(currentPhaseName)) continue;
            currentPhaseName = curPlanPhase.getName();
            BigDecimal fixedPrice = curPlanPhase.getFixed() != null ? curPlanPhase.getFixed().getPrice().getPrice(currency) : null;
            BigDecimal recurringPrice = curPlanPhase.getRecurring() != null ? curPlanPhase.getRecurring().getRecurringPrice().getPrice(currency) : null;
            PhasePriceJson phase = new PhasePriceJson(currentPlanName, curPlanPhase.getName(), curPlanPhase.getPhaseType().toString(), fixedPrice, recurringPrice, curPlanPhase.getUsages(), currency);
            this.prices.add(phase);
        }
        this.priceOverrides = null;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getBundleExternalKey() {
        return this.bundleExternalKey;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public String getProductName() {
        return this.productName;
    }

    public ProductCategory getProductCategory() {
        return this.productCategory;
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public PhaseType getPhaseType() {
        return this.phaseType;
    }

    public String getPriceList() {
        return this.priceList;
    }

    public String getPlanName() {
        return this.planName;
    }

    public Entitlement.EntitlementState getState() {
        return this.state;
    }

    public Entitlement.EntitlementSourceType getSourceType() {
        return this.sourceType;
    }

    public LocalDate getCancelledDate() {
        return this.cancelledDate;
    }

    public LocalDate getChargedThroughDate() {
        return this.chargedThroughDate;
    }

    public LocalDate getBillingStartDate() {
        return this.billingStartDate;
    }

    public LocalDate getBillingEndDate() {
        return this.billingEndDate;
    }

    public Integer getBillCycleDayLocal() {
        return this.billCycleDayLocal;
    }

    public List<EventSubscriptionJson> getEvents() {
        return this.events;
    }

    public List<PhasePriceJson> getPriceOverrides() {
        return this.priceOverrides;
    }

    public List<PhasePriceJson> getPrices() {
        return this.prices;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SubscriptionJson{");
        sb.append("accountId='").append(this.accountId).append('\'');
        sb.append(", bundleId='").append(this.bundleId).append('\'');
        sb.append(", bundleExternalKey='").append(this.bundleExternalKey).append('\'');
        sb.append(", subscriptionId='").append(this.subscriptionId).append('\'');
        sb.append(", externalKey='").append(this.externalKey).append('\'');
        sb.append(", startDate=").append(this.startDate);
        sb.append(", productName='").append(this.productName).append('\'');
        sb.append(", productCategory='").append(this.productCategory).append('\'');
        sb.append(", billingPeriod='").append(this.billingPeriod).append('\'');
        sb.append(", phaseType='").append(this.phaseType).append('\'');
        sb.append(", priceList='").append(this.priceList).append('\'');
        sb.append(", planName='").append(this.planName).append('\'');
        sb.append(", state='").append(this.state).append('\'');
        sb.append(", sourceType='").append(this.sourceType).append('\'');
        sb.append(", cancelledDate=").append(this.cancelledDate);
        sb.append(", chargedThroughDate=").append(this.chargedThroughDate);
        sb.append(", billingStartDate=").append(this.billingStartDate);
        sb.append(", billingEndDate=").append(this.billingEndDate);
        sb.append(", billCycleDayLocal=").append(this.billCycleDayLocal);
        sb.append(", events=").append(this.events);
        sb.append(", prices=").append(this.prices);
        sb.append(", priceOverrides=").append(this.priceOverrides);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionJson that = (SubscriptionJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.billingEndDate != null ? this.billingEndDate.compareTo((ReadablePartial)that.billingEndDate) != 0 : that.billingEndDate != null) {
            return false;
        }
        if (this.billingPeriod != null ? !this.billingPeriod.equals((Object)that.billingPeriod) : that.billingPeriod != null) {
            return false;
        }
        if (this.billingStartDate != null ? this.billingStartDate.compareTo((ReadablePartial)that.billingStartDate) != 0 : that.billingStartDate != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.cancelledDate != null ? this.cancelledDate.compareTo((ReadablePartial)that.cancelledDate) != 0 : that.cancelledDate != null) {
            return false;
        }
        if (this.chargedThroughDate != null ? this.chargedThroughDate.compareTo((ReadablePartial)that.chargedThroughDate) != 0 : that.chargedThroughDate != null) {
            return false;
        }
        if (this.events != null ? !this.events.equals(that.events) : that.events != null) {
            return false;
        }
        if (this.bundleExternalKey != null ? !this.bundleExternalKey.equals(that.bundleExternalKey) : that.bundleExternalKey != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.phaseType != null ? !this.phaseType.equals((Object)that.phaseType) : that.phaseType != null) {
            return false;
        }
        if (this.priceList != null ? !this.priceList.equals(that.priceList) : that.priceList != null) {
            return false;
        }
        if (this.planName != null ? !this.planName.equals(that.planName) : that.planName != null) {
            return false;
        }
        if (this.productCategory != null ? !this.productCategory.equals((Object)that.productCategory) : that.productCategory != null) {
            return false;
        }
        if (this.productName != null ? !this.productName.equals(that.productName) : that.productName != null) {
            return false;
        }
        if (this.sourceType != null ? !this.sourceType.equals((Object)that.sourceType) : that.sourceType != null) {
            return false;
        }
        if (this.startDate != null ? this.startDate.compareTo((ReadablePartial)that.startDate) != 0 : that.startDate != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals((Object)that.state) : that.state != null) {
            return false;
        }
        if (this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null) {
            return false;
        }
        if (this.priceOverrides != null ? !this.priceOverrides.equals(that.priceOverrides) : that.priceOverrides != null) {
            return false;
        }
        return !(this.billCycleDayLocal != null ? !this.billCycleDayLocal.equals(that.billCycleDayLocal) : that.billCycleDayLocal != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.bundleExternalKey != null ? this.bundleExternalKey.hashCode() : 0);
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.productName != null ? this.productName.hashCode() : 0);
        result = 31 * result + (this.productCategory != null ? this.productCategory.hashCode() : 0);
        result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
        result = 31 * result + (this.phaseType != null ? this.phaseType.hashCode() : 0);
        result = 31 * result + (this.priceList != null ? this.priceList.hashCode() : 0);
        result = 31 * result + (this.planName != null ? this.planName.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.sourceType != null ? this.sourceType.hashCode() : 0);
        result = 31 * result + (this.cancelledDate != null ? this.cancelledDate.hashCode() : 0);
        result = 31 * result + (this.chargedThroughDate != null ? this.chargedThroughDate.hashCode() : 0);
        result = 31 * result + (this.billingStartDate != null ? this.billingStartDate.hashCode() : 0);
        result = 31 * result + (this.billingEndDate != null ? this.billingEndDate.hashCode() : 0);
        result = 31 * result + (this.billCycleDayLocal != null ? this.billCycleDayLocal.hashCode() : 0);
        result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
        result = 31 * result + (this.priceOverrides != null ? this.priceOverrides.hashCode() : 0);
        return result;
    }

    @ApiModel(value="EventSubscription", parent=JsonBase.class)
    public static class EventSubscriptionJson
    extends JsonBase {
        private final UUID eventId;
        private final BillingPeriod billingPeriod;
        private final LocalDate effectiveDate;
        private final String plan;
        private final String product;
        private final String priceList;
        private final String phase;
        private final SubscriptionEventType eventType;
        private final Boolean isBlockedBilling;
        private final Boolean isBlockedEntitlement;
        private final String serviceName;
        private final String serviceStateName;

        @JsonCreator
        public EventSubscriptionJson(@JsonProperty(value="eventId") UUID eventId, @JsonProperty(value="billingPeriod") BillingPeriod billingPeriod, @JsonProperty(value="effectiveDate") LocalDate effectiveDate, @JsonProperty(value="plan") String plan, @JsonProperty(value="product") String product, @JsonProperty(value="priceList") String priceList, @JsonProperty(value="eventType") SubscriptionEventType eventType, @JsonProperty(value="isBlockedBilling") Boolean isBlockedBilling, @JsonProperty(value="isBlockedEntitlement") Boolean isBlockedEntitlement, @JsonProperty(value="serviceName") String serviceName, @JsonProperty(value="serviceStateName") String serviceStateName, @JsonProperty(value="phase") String phase, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
            super(auditLogs);
            this.eventId = eventId;
            this.billingPeriod = billingPeriod;
            this.effectiveDate = effectiveDate;
            this.plan = plan;
            this.product = product;
            this.priceList = priceList;
            this.eventType = eventType;
            this.isBlockedBilling = isBlockedBilling;
            this.isBlockedEntitlement = isBlockedEntitlement;
            this.serviceName = serviceName;
            this.serviceStateName = serviceStateName;
            this.phase = phase;
        }

        public EventSubscriptionJson(SubscriptionEvent subscriptionEvent, @Nullable AccountAuditLogs accountAuditLogs) {
            super((List<AuditLogJson>)EventSubscriptionJson.toAuditLogJson(EventSubscriptionJson.getAuditLogsForSubscriptionEvent(subscriptionEvent, accountAuditLogs)));
            BillingPeriod billingPeriod = subscriptionEvent.getNextBillingPeriod() != null ? subscriptionEvent.getNextBillingPeriod() : subscriptionEvent.getPrevBillingPeriod();
            Plan plan = subscriptionEvent.getNextPlan() != null ? subscriptionEvent.getNextPlan() : subscriptionEvent.getPrevPlan();
            Product product = subscriptionEvent.getNextProduct() != null ? subscriptionEvent.getNextProduct() : subscriptionEvent.getPrevProduct();
            PriceList priceList = subscriptionEvent.getNextPriceList() != null ? subscriptionEvent.getNextPriceList() : subscriptionEvent.getPrevPriceList();
            PlanPhase phase = subscriptionEvent.getNextPhase() != null ? subscriptionEvent.getNextPhase() : subscriptionEvent.getPrevPhase();
            this.eventId = subscriptionEvent.getId();
            this.billingPeriod = billingPeriod;
            this.effectiveDate = subscriptionEvent.getEffectiveDate();
            this.plan = plan != null ? plan.getName() : null;
            this.product = product != null ? product.getName() : null;
            this.priceList = priceList != null ? priceList.getName() : null;
            this.eventType = subscriptionEvent.getSubscriptionEventType();
            this.isBlockedBilling = subscriptionEvent.isBlockedBilling();
            this.isBlockedEntitlement = subscriptionEvent.isBlockedEntitlement();
            this.serviceName = subscriptionEvent.getServiceName();
            this.serviceStateName = subscriptionEvent.getServiceStateName();
            this.phase = phase != null ? phase.getName() : null;
        }

        private static List<AuditLog> getAuditLogsForSubscriptionEvent(SubscriptionEvent subscriptionEvent, @Nullable AccountAuditLogs accountAuditLogs) {
            if (accountAuditLogs == null) {
                return null;
            }
            ObjectType subscriptionEventObjectType = subscriptionEvent.getSubscriptionEventType().getObjectType();
            if (subscriptionEventObjectType == ObjectType.SUBSCRIPTION_EVENT) {
                return accountAuditLogs.getAuditLogsForSubscriptionEvent(subscriptionEvent.getId());
            }
            if (subscriptionEventObjectType == ObjectType.BLOCKING_STATES) {
                return accountAuditLogs.getAuditLogsForBlockingState(subscriptionEvent.getId());
            }
            throw new IllegalStateException("Unepxected objectType " + subscriptionEventObjectType + " for SubscriptionEvent " + subscriptionEvent.getId());
        }

        public UUID getEventId() {
            return this.eventId;
        }

        public BillingPeriod getBillingPeriod() {
            return this.billingPeriod;
        }

        public LocalDate getEffectiveDate() {
            return this.effectiveDate;
        }

        public String getPlan() {
            return this.plan;
        }

        public String getProduct() {
            return this.product;
        }

        public String getPriceList() {
            return this.priceList;
        }

        public SubscriptionEventType getEventType() {
            return this.eventType;
        }

        public Boolean getIsBlockedBilling() {
            return this.isBlockedBilling;
        }

        public Boolean getIsBlockedEntitlement() {
            return this.isBlockedEntitlement;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getServiceStateName() {
            return this.serviceStateName;
        }

        public String getPhase() {
            return this.phase;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("EventSubscriptionJson{");
            sb.append("eventId='").append(this.eventId).append('\'');
            sb.append(", billingPeriod='").append(this.billingPeriod).append('\'');
            sb.append(", effectiveDate=").append(this.effectiveDate);
            sb.append(", plan='").append(this.plan).append('\'');
            sb.append(", product='").append(this.product).append('\'');
            sb.append(", priceList='").append(this.priceList).append('\'');
            sb.append(", eventType='").append(this.eventType).append('\'');
            sb.append(", isBlockedBilling=").append(this.isBlockedBilling);
            sb.append(", isBlockedEntitlement=").append(this.isBlockedEntitlement);
            sb.append(", serviceName='").append(this.serviceName).append('\'');
            sb.append(", serviceStateName='").append(this.serviceStateName).append('\'');
            sb.append(", phase='").append(this.phase).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventSubscriptionJson that = (EventSubscriptionJson)o;
            if (this.billingPeriod != null ? !this.billingPeriod.equals((Object)that.billingPeriod) : that.billingPeriod != null) {
                return false;
            }
            if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadablePartial)that.effectiveDate) != 0 : that.effectiveDate != null) {
                return false;
            }
            if (this.eventId != null ? !this.eventId.equals(that.eventId) : that.eventId != null) {
                return false;
            }
            if (this.eventType != null ? !this.eventType.equals((Object)that.eventType) : that.eventType != null) {
                return false;
            }
            if (this.isBlockedBilling != null ? !this.isBlockedBilling.equals(that.isBlockedBilling) : that.isBlockedBilling != null) {
                return false;
            }
            if (this.isBlockedEntitlement != null ? !this.isBlockedEntitlement.equals(that.isBlockedEntitlement) : that.isBlockedEntitlement != null) {
                return false;
            }
            if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
                return false;
            }
            if (this.priceList != null ? !this.priceList.equals(that.priceList) : that.priceList != null) {
                return false;
            }
            if (this.plan != null ? !this.plan.equals(that.plan) : that.plan != null) {
                return false;
            }
            if (this.product != null ? !this.product.equals(that.product) : that.product != null) {
                return false;
            }
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
                return false;
            }
            return !(this.serviceStateName != null ? !this.serviceStateName.equals(that.serviceStateName) : that.serviceStateName != null);
        }

        public int hashCode() {
            int result = this.eventId != null ? this.eventId.hashCode() : 0;
            result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
            result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            result = 31 * result + (this.plan != null ? this.plan.hashCode() : 0);
            result = 31 * result + (this.product != null ? this.product.hashCode() : 0);
            result = 31 * result + (this.priceList != null ? this.priceList.hashCode() : 0);
            result = 31 * result + (this.eventType != null ? this.eventType.hashCode() : 0);
            result = 31 * result + (this.isBlockedBilling != null ? this.isBlockedBilling.hashCode() : 0);
            result = 31 * result + (this.isBlockedEntitlement != null ? this.isBlockedEntitlement.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.serviceStateName != null ? this.serviceStateName.hashCode() : 0);
            result = 31 * result + (this.phase != null ? this.phase.hashCode() : 0);
            return result;
        }
    }
}

