/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.swagger.annotations.ApiModel;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.usage.api.RolledUpUnit;
import org.killbill.billing.usage.api.RolledUpUsage;

@ApiModel(value="RolledUpUsage")
public class RolledUpUsageJson {
    private final UUID subscriptionId;
    private final LocalDate startDate;
    private final LocalDate endDate;
    private final List<RolledUpUnitJson> rolledUpUnits;

    @JsonCreator
    public RolledUpUsageJson(@JsonProperty(value="subscriptionId") UUID subscriptionId, @JsonProperty(value="startDate") LocalDate startDate, @JsonProperty(value="endDate") LocalDate endDate, @JsonProperty(value="rolledUpUnits") List<RolledUpUnitJson> rolledUpUnits) {
        this.subscriptionId = subscriptionId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.rolledUpUnits = rolledUpUnits;
    }

    public RolledUpUsageJson(RolledUpUsage input) {
        this(input.getSubscriptionId(), input.getStart(), input.getEnd(), (List<RolledUpUnitJson>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)input.getRolledUpUnits(), (Function)new Function<RolledUpUnit, RolledUpUnitJson>(){

            public RolledUpUnitJson apply(RolledUpUnit input) {
                return new RolledUpUnitJson(input);
            }
        })));
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public List<RolledUpUnitJson> getRolledUpUnits() {
        return this.rolledUpUnits;
    }

    @ApiModel(value="RolledUpUnit")
    public static class RolledUpUnitJson {
        private final String unitType;
        private final Long amount;

        @JsonCreator
        public RolledUpUnitJson(@JsonProperty(value="unitType") String unitType, @JsonProperty(value="amount") Long amount) {
            this.unitType = unitType;
            this.amount = amount;
        }

        public RolledUpUnitJson(RolledUpUnit input) {
            this(input.getUnitType(), input.getAmount());
        }

        public String getUnitType() {
            return this.unitType;
        }

        public Long getAmount() {
            return this.amount;
        }
    }
}

