/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.swagger.annotations.ApiModel;
import java.util.Set;
import org.killbill.billing.osgi.api.PluginInfo;
import org.killbill.billing.osgi.api.PluginServiceInfo;

@ApiModel(value="PluginInfo")
public class PluginInfoJson {
    private final String bundleSymbolicName;
    private final String pluginKey;
    private final String pluginName;
    private final String version;
    private final String state;
    private final Set<PluginServiceInfoJson> services;
    private final Boolean isSelectedForStart;

    @JsonCreator
    public PluginInfoJson(@JsonProperty(value="bundleSymbolicName") String bundleSymbolicName, @JsonProperty(value="pluginKey") String pluginKey, @JsonProperty(value="pluginName") String pluginName, @JsonProperty(value="version") String version, @JsonProperty(value="state") String state, @JsonProperty(value="isSelectedForStart") Boolean isSelectedForStart, @JsonProperty(value="services") Set<PluginServiceInfoJson> services) {
        this.bundleSymbolicName = bundleSymbolicName;
        this.pluginKey = pluginKey;
        this.pluginName = pluginName;
        this.version = version;
        this.state = state;
        this.isSelectedForStart = isSelectedForStart;
        this.services = services;
    }

    public PluginInfoJson(PluginInfo input) {
        this(input.getBundleSymbolicName(), input.getPluginKey(), input.getPluginName(), input.getVersion(), input.getPluginState().name(), input.isSelectedForStart(), (Set<PluginServiceInfoJson>)ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)input.getServices(), (Function)new Function<PluginServiceInfo, PluginServiceInfoJson>(){

            public PluginServiceInfoJson apply(PluginServiceInfo input) {
                return new PluginServiceInfoJson(input.getServiceTypeName(), input.getRegistrationName());
            }
        })));
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getVersion() {
        return this.version;
    }

    public String getState() {
        return this.state;
    }

    @JsonProperty(value="isSelectedForStart")
    public Boolean isSelectedForStart() {
        return this.isSelectedForStart;
    }

    public Set<PluginServiceInfoJson> getServices() {
        return this.services;
    }

    @ApiModel(value="PluginServiceInfo")
    public static class PluginServiceInfoJson {
        private final String serviceTypeName;
        private final String registrationName;

        @JsonCreator
        public PluginServiceInfoJson(@JsonProperty(value="serviceTypeName") String serviceTypeName, @JsonProperty(value="registrationName") String registrationName) {
            this.serviceTypeName = serviceTypeName;
            this.registrationName = registrationName;
        }

        public String getServiceTypeName() {
            return this.serviceTypeName;
        }

        public String getRegistrationName() {
            return this.registrationName;
        }
    }
}

