/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Tier;
import org.killbill.billing.catalog.api.TieredBlock;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.jaxrs.json.BlockPriceJson;
import org.killbill.billing.jaxrs.json.TierPriceJson;
import org.killbill.billing.jaxrs.json.UsagePriceJson;

@ApiModel(value="PhasePrice")
public class PhasePriceJson {
    private final String planName;
    private final String phaseName;
    private final String phaseType;
    private final BigDecimal fixedPrice;
    private final BigDecimal recurringPrice;
    private final List<UsagePriceJson> usagePrices;

    @JsonCreator
    public PhasePriceJson(@JsonProperty(value="planName") String planName, @JsonProperty(value="phaseName") String phaseName, @JsonProperty(value="phaseType") String phaseType, @Nullable @JsonProperty(value="fixedPrice") BigDecimal fixedPrice, @Nullable @JsonProperty(value="recurringPrice") BigDecimal recurringPrice, @Nullable @JsonProperty(value="usagePrices") List<UsagePriceJson> usagePrices) {
        this.planName = planName;
        this.phaseName = phaseName;
        this.phaseType = phaseType;
        this.fixedPrice = fixedPrice;
        this.recurringPrice = recurringPrice;
        this.usagePrices = usagePrices;
    }

    public PhasePriceJson(String planName, String phaseName, String phaseType, BigDecimal fixedPrice, BigDecimal recurringPrice, Usage[] usagePrices, Currency currency) throws CatalogApiException {
        this.planName = planName;
        this.phaseName = phaseName;
        this.phaseType = phaseType;
        this.fixedPrice = fixedPrice;
        this.recurringPrice = recurringPrice;
        this.usagePrices = new LinkedList<UsagePriceJson>();
        for (Usage usage : usagePrices) {
            LinkedList<TierPriceJson> usageTierPrices = new LinkedList<TierPriceJson>();
            for (Tier tier : usage.getTiers()) {
                LinkedList<BlockPriceJson> blockPrices = new LinkedList<BlockPriceJson>();
                for (TieredBlock block : tier.getTieredBlocks()) {
                    BlockPriceJson blockPriceJson = new BlockPriceJson(block.getUnit().getName(), block.getSize(), block.getPrice().getPrice(currency), block.getMax());
                    blockPrices.add(blockPriceJson);
                }
                TierPriceJson tierPriceJson = new TierPriceJson(blockPrices);
                usageTierPrices.add(tierPriceJson);
            }
            UsagePriceJson usagePriceJson = new UsagePriceJson(usage.getName(), usage.getUsageType(), usage.getBillingMode(), usage.getTierBlockPolicy(), usageTierPrices);
            this.usagePrices.add(usagePriceJson);
        }
    }

    public String getPlanName() {
        return this.planName;
    }

    public BigDecimal getFixedPrice() {
        return this.fixedPrice;
    }

    public BigDecimal getRecurringPrice() {
        return this.recurringPrice;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public String getPhaseType() {
        return this.phaseType;
    }

    public List<UsagePriceJson> getUsagePrices() {
        return this.usagePrices;
    }

    public String toString() {
        return "PhasePriceJson{planName='" + this.planName + '\'' + "phaseName='" + this.phaseName + '\'' + "phaseType='" + this.phaseType + '\'' + ", fixedPrice=" + this.fixedPrice + ", recurringPrice=" + this.recurringPrice + ", usageOverrides=" + this.usagePrices + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhasePriceJson)) {
            return false;
        }
        PhasePriceJson that = (PhasePriceJson)o;
        if (this.fixedPrice != null ? this.fixedPrice.compareTo(that.fixedPrice) != 0 : that.fixedPrice != null) {
            return false;
        }
        if (this.planName != null ? !this.planName.equals(that.planName) : that.planName != null) {
            return false;
        }
        if (this.phaseName != null ? !this.phaseName.equals(that.phaseName) : that.phaseName != null) {
            return false;
        }
        if (this.phaseType != null ? !this.phaseType.equals(that.phaseType) : that.phaseType != null) {
            return false;
        }
        if (this.recurringPrice != null ? this.recurringPrice.compareTo(that.recurringPrice) != 0 : that.recurringPrice != null) {
            return false;
        }
        return !(this.usagePrices != null ? !this.usagePrices.equals(that.usagePrices) : that.usagePrices != null);
    }

    public int hashCode() {
        int result = this.planName != null ? this.planName.hashCode() : 0;
        result = 31 * result + (this.phaseName != null ? this.phaseName.hashCode() : 0);
        result = 31 * result + (this.recurringPrice != null ? this.recurringPrice.hashCode() : 0);
        result = 31 * result + (this.phaseType != null ? this.phaseType.hashCode() : 0);
        result = 31 * result + (this.recurringPrice != null ? this.recurringPrice.hashCode() : 0);
        result = 31 * result + (this.usagePrices != null ? this.usagePrices.hashCode() : 0);
        return result;
    }
}

