/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.PluginPropertyJson;
import org.killbill.billing.payment.api.PaymentAttempt;
import org.killbill.billing.payment.api.TransactionType;
import org.killbill.billing.util.audit.AuditLog;

@ApiModel(value="PaymentAttempt", parent=JsonBase.class)
public class PaymentAttemptJson
extends JsonBase {
    private final UUID accountId;
    private final UUID paymentMethodId;
    private final String paymentExternalKey;
    private final UUID transactionId;
    private final String transactionExternalKey;
    private final TransactionType transactionType;
    @ApiModelProperty(dataType="org.joda.time.DateTime")
    private final DateTime effectiveDate;
    private final String stateName;
    @ApiModelProperty(value="Transaction amount, required except for void operations")
    private final BigDecimal amount;
    @ApiModelProperty(value="Amount currency (account currency unless specified)", dataType="org.killbill.billing.catalog.api.Currency")
    private final Currency currency;
    private final String pluginName;
    private final List<PluginPropertyJson> pluginProperties;

    @JsonCreator
    public PaymentAttemptJson(@JsonProperty(value="accountId") UUID accountId, @JsonProperty(value="paymentMethodId") UUID paymentMethodId, @JsonProperty(value="paymentExternalKey") String paymentExternalKey, @JsonProperty(value="transactionId") UUID transactionId, @JsonProperty(value="transactionExternalKey") String transactionExternalKey, @JsonProperty(value="transactionType") TransactionType transactionType, @JsonProperty(value="effectiveDate") DateTime effectiveDate, @JsonProperty(value="stateName") String stateName, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency") Currency currency, @JsonProperty(value="pluginName") String pluginName, @JsonProperty(value="pluginProperties") List<PluginPropertyJson> pluginProperties, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.accountId = accountId;
        this.paymentMethodId = paymentMethodId;
        this.paymentExternalKey = paymentExternalKey;
        this.transactionId = transactionId;
        this.transactionExternalKey = transactionExternalKey;
        this.transactionType = transactionType;
        this.effectiveDate = effectiveDate;
        this.stateName = stateName;
        this.amount = amount;
        this.currency = currency;
        this.pluginName = pluginName;
        this.pluginProperties = pluginProperties;
    }

    public PaymentAttemptJson(PaymentAttempt paymentAttempt, String paymentExternalKey, @Nullable List<AuditLog> attemptsLogs) {
        this(paymentAttempt.getAccountId(), paymentAttempt.getPaymentMethodId(), paymentExternalKey, paymentAttempt.getTransactionId(), paymentAttempt.getTransactionExternalKey(), paymentAttempt.getTransactionType(), paymentAttempt.getEffectiveDate(), paymentAttempt.getStateName(), paymentAttempt.getAmount(), paymentAttempt.getCurrency() != null ? paymentAttempt.getCurrency() : null, paymentAttempt.getPluginName(), paymentAttempt.getPluginProperties() == null ? null : PaymentAttemptJson.toPluginPropertyJson(paymentAttempt.getPluginProperties()), (List<AuditLogJson>)PaymentAttemptJson.toAuditLogJson(attemptsLogs));
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public String getPaymentExternalKey() {
        return this.paymentExternalKey;
    }

    public UUID getTransactionId() {
        return this.transactionId;
    }

    public String getTransactionExternalKey() {
        return this.transactionExternalKey;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public String getStateName() {
        return this.stateName;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public List<PluginPropertyJson> getPluginProperties() {
        return this.pluginProperties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PaymentAttemptJson{");
        sb.append("accountId='").append(this.accountId).append('\'');
        sb.append(", paymentMethodId='").append(this.paymentMethodId).append('\'');
        sb.append(", paymentExternalKey='").append(this.paymentExternalKey).append('\'');
        sb.append(", transactionId='").append(this.transactionId).append('\'');
        sb.append(", transactionExternalKey='").append(this.transactionExternalKey).append('\'');
        sb.append(", transactionType='").append(this.transactionType).append('\'');
        sb.append(", effectiveDate=").append(this.effectiveDate);
        sb.append(", stateName='").append(this.stateName).append('\'');
        sb.append(", amount=").append(this.amount);
        sb.append(", currency='").append(this.currency).append('\'');
        sb.append(", pluginName='").append(this.pluginName).append('\'');
        sb.append(", pluginProperties=").append(this.pluginProperties);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentAttemptJson that = (PaymentAttemptJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
            return false;
        }
        if (this.paymentExternalKey != null ? !this.paymentExternalKey.equals(that.paymentExternalKey) : that.paymentExternalKey != null) {
            return false;
        }
        if (this.transactionId != null ? !this.transactionId.equals(that.transactionId) : that.transactionId != null) {
            return false;
        }
        if (this.transactionExternalKey != null ? !this.transactionExternalKey.equals(that.transactionExternalKey) : that.transactionExternalKey != null) {
            return false;
        }
        if (this.transactionType != null ? !this.transactionType.equals((Object)that.transactionType) : that.transactionType != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadableInstant)that.effectiveDate) != 0 : that.effectiveDate != null) {
            return false;
        }
        if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) {
            return false;
        }
        if (this.amount != null ? this.amount.compareTo(that.amount) != 0 : that.amount != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals((Object)that.currency) : that.currency != null) {
            return false;
        }
        if (this.pluginName != null ? !this.pluginName.equals(that.pluginName) : that.pluginName != null) {
            return false;
        }
        return !(this.pluginProperties != null ? !this.pluginProperties.equals(that.pluginProperties) : that.pluginProperties != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0);
        result = 31 * result + (this.paymentExternalKey != null ? this.paymentExternalKey.hashCode() : 0);
        result = 31 * result + (this.transactionId != null ? this.transactionId.hashCode() : 0);
        result = 31 * result + (this.transactionExternalKey != null ? this.transactionExternalKey.hashCode() : 0);
        result = 31 * result + (this.transactionType != null ? this.transactionType.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.pluginName != null ? this.pluginName.hashCode() : 0);
        result = 31 * result + (this.pluginProperties != null ? this.pluginProperties.hashCode() : 0);
        return result;
    }
}

