/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import org.joda.time.Period;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueState;

@ApiModel(value="OverdueState")
public class OverdueStateJson {
    private final String name;
    private final String externalMessage;
    private final Boolean isDisableEntitlementAndChangesBlocked;
    private final Boolean isBlockChanges;
    private final Boolean isClearState;
    private final Integer reevaluationIntervalDays;

    @JsonCreator
    public OverdueStateJson(@JsonProperty(value="name") String name, @JsonProperty(value="externalMessage") String externalMessage, @JsonProperty(value="isDisableEntitlementAndChangesBlocked") Boolean isDisableEntitlementAndChangesBlocked, @JsonProperty(value="isBlockChanges") Boolean isBlockChanges, @JsonProperty(value="isClearState") Boolean isClearState, @JsonProperty(value="reevaluationIntervalDays") Integer reevaluationIntervalDays) {
        this.name = name;
        this.externalMessage = externalMessage;
        this.isDisableEntitlementAndChangesBlocked = isDisableEntitlementAndChangesBlocked;
        this.isBlockChanges = isBlockChanges;
        this.isClearState = isClearState;
        this.reevaluationIntervalDays = reevaluationIntervalDays;
    }

    public OverdueStateJson(OverdueState overdueState) {
        this.name = overdueState.getName();
        this.externalMessage = overdueState.getExternalMessage();
        this.isDisableEntitlementAndChangesBlocked = overdueState.isDisableEntitlementAndChangesBlocked();
        this.isBlockChanges = overdueState.isBlockChanges();
        this.isClearState = overdueState.isClearState();
        Period reevaluationIntervalPeriod = null;
        try {
            reevaluationIntervalPeriod = overdueState.getAutoReevaluationInterval().toJodaPeriod();
        }
        catch (OverdueApiException overdueApiException) {
            // empty catch block
        }
        this.reevaluationIntervalDays = reevaluationIntervalPeriod != null ? Integer.valueOf(reevaluationIntervalPeriod.getDays()) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getExternalMessage() {
        return this.externalMessage;
    }

    @JsonProperty(value="isDisableEntitlementAndChangesBlocked")
    public Boolean isDisableEntitlementAndChangesBlocked() {
        return this.isDisableEntitlementAndChangesBlocked;
    }

    @JsonProperty(value="isBlockChanges")
    public Boolean isBlockChanges() {
        return this.isBlockChanges;
    }

    @JsonProperty(value="isClearState")
    public Boolean isClearState() {
        return this.isClearState;
    }

    public Integer getReevaluationIntervalDays() {
        return this.reevaluationIntervalDays;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OverdueStateJson");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", externalMessage='").append(this.externalMessage).append('\'');
        sb.append(", isDisableEntitlementAndChangesBlocked=").append(this.isDisableEntitlementAndChangesBlocked);
        sb.append(", isBlockChanges=").append(this.isBlockChanges);
        sb.append(", isClearState=").append(this.isClearState);
        sb.append(", reevaluationIntervalDays=").append(this.reevaluationIntervalDays);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverdueStateJson that = (OverdueStateJson)o;
        if (this.isBlockChanges != null ? !this.isBlockChanges.equals(that.isBlockChanges) : that.isBlockChanges != null) {
            return false;
        }
        if (this.isDisableEntitlementAndChangesBlocked != null ? !this.isDisableEntitlementAndChangesBlocked.equals(that.isDisableEntitlementAndChangesBlocked) : that.isDisableEntitlementAndChangesBlocked != null) {
            return false;
        }
        if (this.externalMessage != null ? !this.externalMessage.equals(that.externalMessage) : that.externalMessage != null) {
            return false;
        }
        if (this.isClearState != null ? !this.isClearState.equals(that.isClearState) : that.isClearState != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.reevaluationIntervalDays != null ? !this.reevaluationIntervalDays.equals(that.reevaluationIntervalDays) : that.reevaluationIntervalDays != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.externalMessage != null ? this.externalMessage.hashCode() : 0);
        result = 31 * result + (this.isDisableEntitlementAndChangesBlocked != null ? this.isDisableEntitlementAndChangesBlocked.hashCode() : 0);
        result = 31 * result + (this.isBlockChanges != null ? this.isBlockChanges.hashCode() : 0);
        result = 31 * result + (this.isClearState != null ? this.isClearState.hashCode() : 0);
        result = 31 * result + (this.reevaluationIntervalDays != null ? this.reevaluationIntervalDays.hashCode() : 0);
        return result;
    }
}

