/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import org.killbill.billing.jaxrs.json.OverdueConditionJson;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueCancellationPolicy;
import org.killbill.billing.overdue.api.OverdueState;

@ApiModel(value="OverdueStateConfig")
public class OverdueStateConfigJson {
    private final String name;
    private final Boolean isClearState;
    private final OverdueConditionJson condition;
    private final String externalMessage;
    private final Boolean isBlockChanges;
    private final Boolean isDisableEntitlement;
    private final OverdueCancellationPolicy subscriptionCancellationPolicy;
    private final Integer autoReevaluationIntervalDays;

    @JsonCreator
    public OverdueStateConfigJson(@JsonProperty(value="name") String name, @JsonProperty(value="isClearState") Boolean isClearState, @JsonProperty(value="condition") OverdueConditionJson condition, @JsonProperty(value="externalMessage") String externalMessage, @JsonProperty(value="isBlockChanges") Boolean isBlockChanges, @JsonProperty(value="isDisableEntitlement") Boolean isDisableEntitlement, @JsonProperty(value="subscriptionCancellationPolicy") OverdueCancellationPolicy subscriptionCancellationPolicy, @JsonProperty(value="autoReevaluationIntervalDays") Integer autoReevaluationInterval) {
        this.name = name;
        this.isClearState = isClearState;
        this.condition = condition;
        this.externalMessage = externalMessage;
        this.isBlockChanges = isBlockChanges;
        this.isDisableEntitlement = isDisableEntitlement;
        this.subscriptionCancellationPolicy = subscriptionCancellationPolicy;
        this.autoReevaluationIntervalDays = autoReevaluationInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverdueStateConfigJson(OverdueState input) {
        this.name = input.getName();
        this.isClearState = input.isClearState();
        this.condition = input.getOverdueCondition() != null ? new OverdueConditionJson(input.getOverdueCondition()) : null;
        this.externalMessage = input.getExternalMessage();
        this.isBlockChanges = input.isBlockChanges();
        this.isDisableEntitlement = input.isDisableEntitlementAndChangesBlocked();
        this.subscriptionCancellationPolicy = input.getOverdueCancellationPolicy();
        Integer tmpAutoReevaluationIntervalDays = null;
        try {
            tmpAutoReevaluationIntervalDays = input.getAutoReevaluationInterval().toJodaPeriod().getDays();
        }
        catch (OverdueApiException overdueApiException) {
        }
        finally {
            this.autoReevaluationIntervalDays = tmpAutoReevaluationIntervalDays;
        }
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="isClearState")
    public Boolean isClearState() {
        return this.isClearState;
    }

    public OverdueConditionJson getCondition() {
        return this.condition;
    }

    public String getExternalMessage() {
        return this.externalMessage;
    }

    @JsonProperty(value="isBlockChanges")
    public Boolean isBlockChanges() {
        return this.isBlockChanges;
    }

    @JsonProperty(value="isDisableEntitlement")
    public Boolean isDisableEntitlement() {
        return this.isDisableEntitlement;
    }

    public OverdueCancellationPolicy getSubscriptionCancellationPolicy() {
        return this.subscriptionCancellationPolicy;
    }

    public Integer getAutoReevaluationIntervalDays() {
        return this.autoReevaluationIntervalDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverdueStateConfigJson)) {
            return false;
        }
        OverdueStateConfigJson that = (OverdueStateConfigJson)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.isClearState != null ? !this.isClearState.equals(that.isClearState) : that.isClearState != null) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.externalMessage != null ? !this.externalMessage.equals(that.externalMessage) : that.externalMessage != null) {
            return false;
        }
        if (this.isBlockChanges != null ? !this.isBlockChanges.equals(that.isBlockChanges) : that.isBlockChanges != null) {
            return false;
        }
        if (this.isDisableEntitlement != null ? !this.isDisableEntitlement.equals(that.isDisableEntitlement) : that.isDisableEntitlement != null) {
            return false;
        }
        if (this.subscriptionCancellationPolicy != that.subscriptionCancellationPolicy) {
            return false;
        }
        return this.autoReevaluationIntervalDays != null ? this.autoReevaluationIntervalDays.equals(that.autoReevaluationIntervalDays) : that.autoReevaluationIntervalDays == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.isClearState != null ? this.isClearState.hashCode() : 0);
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.externalMessage != null ? this.externalMessage.hashCode() : 0);
        result = 31 * result + (this.isBlockChanges != null ? this.isBlockChanges.hashCode() : 0);
        result = 31 * result + (this.isDisableEntitlement != null ? this.isDisableEntitlement.hashCode() : 0);
        result = 31 * result + (this.subscriptionCancellationPolicy != null ? this.subscriptionCancellationPolicy.hashCode() : 0);
        result = 31 * result + (this.autoReevaluationIntervalDays != null ? this.autoReevaluationIntervalDays.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OverdueStateConfigJson{name='" + this.name + '\'' + ", isClearState=" + this.isClearState + ", condition=" + this.condition + ", externalMessage='" + this.externalMessage + '\'' + ", isBlockChanges=" + this.isBlockChanges + ", isDisableEntitlement=" + this.isDisableEntitlement + ", subscriptionCancellationPolicy=" + this.subscriptionCancellationPolicy + ", autoReevaluationIntervalDays=" + this.autoReevaluationIntervalDays + '}';
    }
}

