/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.swagger.annotations.ApiModel;
import java.util.List;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.jaxrs.json.OverdueConditionJson;
import org.killbill.billing.jaxrs.json.OverdueStateConfigJson;
import org.killbill.billing.overdue.api.OverdueConfig;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.config.DefaultDuration;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.overdue.config.DefaultOverdueState;
import org.killbill.billing.overdue.config.DefaultOverdueStatesAccount;

@ApiModel(value="Overdue")
public class OverdueJson {
    private final Integer initialReevaluationIntervalDays;
    private final List<OverdueStateConfigJson> overdueStates;

    @JsonCreator
    public OverdueJson(@JsonProperty(value="initialReevaluationInterval") Integer initialReevaluationInterval, @JsonProperty(value="overdueStates") List<OverdueStateConfigJson> overdueStates) {
        this.initialReevaluationIntervalDays = initialReevaluationInterval;
        this.overdueStates = overdueStates;
    }

    public OverdueJson(OverdueConfig overdueConfig) {
        this.initialReevaluationIntervalDays = overdueConfig.getOverdueStatesAccount().getInitialReevaluationInterval() != null ? Integer.valueOf(overdueConfig.getOverdueStatesAccount().getInitialReevaluationInterval().getDays()) : null;
        this.overdueStates = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)ImmutableList.copyOf((Object[])overdueConfig.getOverdueStatesAccount().getStates()), (Function)new Function<OverdueState, OverdueStateConfigJson>(){

            public OverdueStateConfigJson apply(OverdueState input) {
                return new OverdueStateConfigJson(input);
            }
        }));
    }

    public Integer getInitialReevaluationInterval() {
        return this.initialReevaluationIntervalDays;
    }

    public List<OverdueStateConfigJson> getOverdueStates() {
        return this.overdueStates;
    }

    public String toString() {
        return "OverdueJson{initialReevaluationIntervalDays=" + this.initialReevaluationIntervalDays + ", overdueStates=" + this.overdueStates + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverdueJson)) {
            return false;
        }
        OverdueJson that = (OverdueJson)o;
        if (this.initialReevaluationIntervalDays != null ? !this.initialReevaluationIntervalDays.equals(that.initialReevaluationIntervalDays) : that.initialReevaluationIntervalDays != null) {
            return false;
        }
        return this.overdueStates != null ? this.overdueStates.equals(that.overdueStates) : that.overdueStates == null;
    }

    public int hashCode() {
        int result = this.initialReevaluationIntervalDays != null ? this.initialReevaluationIntervalDays.hashCode() : 0;
        result = 31 * result + (this.overdueStates != null ? this.overdueStates.hashCode() : 0);
        return result;
    }

    public static OverdueConfig toOverdueConfigWithValidation(OverdueJson input) {
        DefaultOverdueConfig result = new DefaultOverdueConfig();
        DefaultOverdueStatesAccount overdueStateAccount = new DefaultOverdueStatesAccount();
        result.setOverdueStates(overdueStateAccount);
        DefaultOverdueState[] states = new DefaultOverdueState[input.getOverdueStates().size()];
        int i = 0;
        int prevTimeSinceEarliestUnpaidInvoice = -1;
        for (OverdueStateConfigJson cur : input.getOverdueStates()) {
            Preconditions.checkNotNull((Object)cur.getName());
            Preconditions.checkNotNull((Object)cur.getCondition());
            Preconditions.checkNotNull((Object)cur.getCondition().getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds());
            Preconditions.checkNotNull((Object)cur.getCondition().getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds().getUnit());
            Preconditions.checkState((cur.getCondition().getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds().getUnit() == TimeUnit.DAYS ? 1 : 0) != 0);
            Preconditions.checkState((cur.getCondition().getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds().getNumber() > 0 ? 1 : 0) != 0);
            DefaultOverdueState state = new DefaultOverdueState();
            state.setName(cur.getName());
            state.setExternalMessage(cur.getExternalMessage());
            state.setBlockChanges(cur.isBlockChanges().booleanValue());
            state.setDisableEntitlement(cur.isDisableEntitlement().booleanValue());
            state.setSubscriptionCancellationPolicy(cur.getSubscriptionCancellationPolicy());
            state.setClearState(cur.isClearState().booleanValue());
            state.setAutoReevaluationInterval(OverdueJson.computeReevaluationInterval(cur.getAutoReevaluationIntervalDays(), prevTimeSinceEarliestUnpaidInvoice, cur.getCondition().getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds().getNumber()));
            state.setCondition(OverdueConditionJson.toOverdueCondition(cur.getCondition()));
            states[i++] = state;
            prevTimeSinceEarliestUnpaidInvoice = cur.getCondition().getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds().getNumber();
        }
        overdueStateAccount.setAccountOverdueStates(states);
        overdueStateAccount.setInitialReevaluationInterval(OverdueJson.computeReevaluationInterval(null, prevTimeSinceEarliestUnpaidInvoice, 0));
        return result;
    }

    private static DefaultDuration computeReevaluationInterval(Integer inputReevaluationInterval, int prevTimeSinceEarliestUnpaidInvoice, int curTimeSinceEarliestUnpaidInvoice) {
        if (inputReevaluationInterval != null && inputReevaluationInterval > 0) {
            return new DefaultDuration().setUnit(TimeUnit.DAYS).setNumber(inputReevaluationInterval);
        }
        if (prevTimeSinceEarliestUnpaidInvoice == -1) {
            return null;
        }
        Preconditions.checkState((prevTimeSinceEarliestUnpaidInvoice - curTimeSinceEarliestUnpaidInvoice > 0 ? 1 : 0) != 0);
        return new DefaultDuration().setUnit(TimeUnit.DAYS).setNumber(Integer.valueOf(prevTimeSinceEarliestUnpaidInvoice - curTimeSinceEarliestUnpaidInvoice));
    }
}

