/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import org.killbill.billing.jaxrs.json.CatalogJson;
import org.killbill.billing.overdue.api.OverdueCondition;
import org.killbill.billing.overdue.config.DefaultDuration;
import org.killbill.billing.overdue.config.DefaultOverdueCondition;
import org.killbill.billing.payment.api.PaymentResponse;
import org.killbill.billing.util.tag.ControlTagType;

@ApiModel(value="OverdueCondition")
public class OverdueConditionJson {
    private final CatalogJson.DurationJson timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
    private final ControlTagType controlTagInclusion;
    private final ControlTagType controlTagExclusion;
    private final Integer numberOfUnpaidInvoicesEqualsOrExceeds;
    private final PaymentResponse[] responseForLastFailedPayment;
    private final BigDecimal totalUnpaidInvoiceBalanceEqualsOrExceeds;

    @JsonCreator
    public OverdueConditionJson(@JsonProperty(value="timeSinceEarliestUnpaidInvoiceEqualsOrExceeds") CatalogJson.DurationJson timeSinceEarliestUnpaidInvoiceEqualsOrExceeds, @JsonProperty(value="controlTagInclusion") ControlTagType controlTagInclusion, @JsonProperty(value="controlTagExclusion") ControlTagType controlTagExclusion, @JsonProperty(value="numberOfUnpaidInvoicesEqualsOrExceeds") Integer numberOfUnpaidInvoicesEqualsOrExceeds, @JsonProperty(value="responseForLastFailedPayment") PaymentResponse[] responseForLastFailedPayment, @JsonProperty(value="totalUnpaidInvoiceBalanceEqualsOrExceeds") BigDecimal totalUnpaidInvoiceBalanceEqualsOrExceeds) {
        this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds = timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
        this.controlTagInclusion = controlTagInclusion;
        this.controlTagExclusion = controlTagExclusion;
        this.numberOfUnpaidInvoicesEqualsOrExceeds = numberOfUnpaidInvoicesEqualsOrExceeds;
        this.responseForLastFailedPayment = responseForLastFailedPayment;
        this.totalUnpaidInvoiceBalanceEqualsOrExceeds = totalUnpaidInvoiceBalanceEqualsOrExceeds;
    }

    public OverdueConditionJson(OverdueCondition overdueCondition) {
        this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds = new CatalogJson.DurationJson(overdueCondition.getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds());
        this.controlTagInclusion = overdueCondition.getInclusionControlTagType();
        this.controlTagExclusion = overdueCondition.getExclusionControlTagType();
        this.numberOfUnpaidInvoicesEqualsOrExceeds = overdueCondition.getNumberOfUnpaidInvoicesEqualsOrExceeds();
        this.responseForLastFailedPayment = overdueCondition.getResponseForLastFailedPaymentIn();
        this.totalUnpaidInvoiceBalanceEqualsOrExceeds = overdueCondition.getTotalUnpaidInvoiceBalanceEqualsOrExceeds();
    }

    public CatalogJson.DurationJson getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds() {
        return this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
    }

    public ControlTagType getControlTagInclusion() {
        return this.controlTagInclusion;
    }

    public ControlTagType getControlTagExclusion() {
        return this.controlTagExclusion;
    }

    public Integer getNumberOfUnpaidInvoicesEqualsOrExceeds() {
        return this.numberOfUnpaidInvoicesEqualsOrExceeds;
    }

    public PaymentResponse[] getResponseForLastFailedPayment() {
        return this.responseForLastFailedPayment;
    }

    public BigDecimal getTotalUnpaidInvoiceBalanceEqualsOrExceeds() {
        return this.totalUnpaidInvoiceBalanceEqualsOrExceeds;
    }

    public String toString() {
        return "OverdueConditionJson{timeSinceEarliestUnpaidInvoiceEqualsOrExceeds=" + this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds + ", controlTagInclusion=" + this.controlTagInclusion + ", controlTagExclusion=" + this.controlTagExclusion + ", numberOfUnpaidInvoicesEqualsOrExceeds=" + this.numberOfUnpaidInvoicesEqualsOrExceeds + ", responseForLastFailedPayment=" + this.responseForLastFailedPayment + ", totalUnpaidInvoiceBalanceEqualsOrExceeds=" + this.totalUnpaidInvoiceBalanceEqualsOrExceeds + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverdueConditionJson)) {
            return false;
        }
        OverdueConditionJson that = (OverdueConditionJson)o;
        if (this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds != null ? !this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds.equals(that.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds) : that.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds != null) {
            return false;
        }
        if (this.controlTagInclusion != that.controlTagInclusion) {
            return false;
        }
        if (this.controlTagExclusion != that.controlTagExclusion) {
            return false;
        }
        if (!this.numberOfUnpaidInvoicesEqualsOrExceeds.equals(that.numberOfUnpaidInvoicesEqualsOrExceeds)) {
            return false;
        }
        if (this.responseForLastFailedPayment != that.responseForLastFailedPayment) {
            return false;
        }
        return this.totalUnpaidInvoiceBalanceEqualsOrExceeds.equals(that.totalUnpaidInvoiceBalanceEqualsOrExceeds);
    }

    public int hashCode() {
        int result = this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds != null ? this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds.hashCode() : 0;
        result = 31 * result + (this.controlTagInclusion != null ? this.controlTagInclusion.hashCode() : 0);
        result = 31 * result + (this.controlTagExclusion != null ? this.controlTagExclusion.hashCode() : 0);
        result = 31 * result + (this.numberOfUnpaidInvoicesEqualsOrExceeds != null ? this.numberOfUnpaidInvoicesEqualsOrExceeds.hashCode() : 0);
        result = 31 * result + (this.responseForLastFailedPayment != null ? this.responseForLastFailedPayment.hashCode() : 0);
        result = 31 * result + (this.totalUnpaidInvoiceBalanceEqualsOrExceeds != null ? this.totalUnpaidInvoiceBalanceEqualsOrExceeds.hashCode() : 0);
        return result;
    }

    public static DefaultOverdueCondition toOverdueCondition(OverdueConditionJson input) {
        DefaultOverdueCondition result = new DefaultOverdueCondition();
        if (input.getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds() != null) {
            result.setTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds(new DefaultDuration().setUnit(input.getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds().getUnit()).setNumber(Integer.valueOf(input.getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds().getNumber())));
        }
        result.setControlTagInclusion(input.getControlTagInclusion());
        result.setControlTagExclusion(input.getControlTagExclusion());
        result.setNumberOfUnpaidInvoicesEqualsOrExceeds(input.getNumberOfUnpaidInvoicesEqualsOrExceeds());
        result.setResponseForLastFailedPayment(input.getResponseForLastFailedPayment());
        result.setTotalUnpaidInvoiceBalanceEqualsOrExceeds(input.getTotalUnpaidInvoiceBalanceEqualsOrExceeds());
        return result;
    }
}

