/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.UUID;
import org.killbill.billing.notification.plugin.api.ExtBusEvent;

@ApiModel(value="Notification")
public class NotificationJson {
    private final String eventType;
    private final UUID accountId;
    private final String objectType;
    private final UUID objectId;
    private String metaData;

    @JsonCreator
    public NotificationJson(@JsonProperty(value="eventType") String eventType, @JsonProperty(value="accountId") UUID accountId, @JsonProperty(value="objectType") String objectType, @JsonProperty(value="objectId") UUID objectId, @JsonProperty(value="metaData") String metaData) {
        this.eventType = eventType;
        this.accountId = accountId;
        this.objectType = objectType;
        this.objectId = objectId;
        this.metaData = metaData;
    }

    public NotificationJson(ExtBusEvent event) {
        this(event.getEventType().toString(), event.getAccountId(), event.getObjectType().toString(), event.getObjectId(), event.getMetaData());
    }

    public String getEventType() {
        return this.eventType;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NotificationJson{");
        sb.append("eventType='").append(this.eventType).append('\'');
        sb.append(", accountId=").append(this.accountId);
        sb.append(", objectType='").append(this.objectType).append('\'');
        sb.append(", objectId=").append(this.objectId);
        sb.append(", metaData='").append(this.metaData).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationJson that = (NotificationJson)o;
        if (this.eventType != null ? !this.eventType.equals(that.eventType) : that.eventType != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.objectType != null ? !this.objectType.equals(that.objectType) : that.objectType != null) {
            return false;
        }
        if (this.objectId != null ? !this.objectId.equals(that.objectId) : that.objectId != null) {
            return false;
        }
        return this.metaData != null ? this.metaData.equals(that.metaData) : that.metaData == null;
    }

    public int hashCode() {
        int result = this.eventType != null ? this.eventType.hashCode() : 0;
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        result = 31 * result + (this.objectId != null ? this.objectId.hashCode() : 0);
        result = 31 * result + (this.metaData != null ? this.metaData.hashCode() : 0);
        return result;
    }
}

